/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.daemon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.net.Base64Encoder;
import org.ops4j.pax.runner.CommandLine;
import org.ops4j.pax.runner.CommandLineImpl;
import org.ops4j.pax.runner.Run;
import org.ops4j.pax.runner.platform.DefaultJavaRunner;
import org.ops4j.pax.runner.platform.StoppableJavaRunner;

public class Daemon {
    public static final String PASSWORD_FILE = "org.ops4j.pax.runner.daemon.password.file";
    private static final String INFO_FILE = "org.ops4j.pax.runner.daemon.info";
    private static final String LOCK_FILE = "org.ops4j.pax.runner.daemon.lock";
    private static final String NEWLINE = "\r\n";
    private static final String OPT_NETWORK_TIMEOUT = "org.ops4j.pax.runner.daemon.network.timeout";
    private static final String OPT_SHUTDOWN_TIMEOUT = "org.ops4j.pax.runner.daemon.shutdown.timeout";
    private static final String OPT_SHUTDOWN_CMD = "org.ops4j.pax.runner.daemon.shutdown.cmd";
    private static final String OPT_SHUTDOWN_PORT = "org.ops4j.pax.runner.daemon.shutdown.port";
    private CommandLine commandLine = null;
    private String[] cmdArgs = null;
    private StoppableJavaRunner runner = null;
    private Thread shutdownHook = null;
    private int networkTimeout = 60000;
    private long shutdownTimeout = 0L;
    private ServerSocket serverSocket = null;
    private boolean continueAwait = true;
    private static Daemon instance = null;
    private static String shutdown = "shutdown";
    private static int shutdownPort = 8008;
    private static final Log LOG = LogFactory.getLog(Daemon.class);

    public static void main(String[] args) {
        Daemon.getInstance();
        instance.load(args);
        instance.start();
    }

    public static Daemon getInstance() {
        if (instance == null) {
            instance = new Daemon();
        }
        return instance;
    }

    public static boolean isDaemonStarted() {
        File lock = new File(Daemon.getRunnerHomeDir(false), LOCK_FILE);
        return lock.exists() && lock.isFile();
    }

    public void load(String ... args) {
        this.cmdArgs = args;
        this.commandLine = new CommandLineImpl(args);
        this.setNetworkTimeout(this.commandLine.getOption(OPT_NETWORK_TIMEOUT));
        this.setShutdown(this.commandLine.getOption(OPT_SHUTDOWN_CMD));
        this.setShutdownPort(this.commandLine.getOption(OPT_SHUTDOWN_PORT));
        this.setShutdownTimeout(this.commandLine.getOption(OPT_SHUTDOWN_TIMEOUT));
    }

    public void start() {
        new RunnerLauncher().start();
        this.await();
    }

    public void stop() {
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            LOG.trace((Object)"Removed Shutdown Hook.");
            this.shutdownHook.run();
            this.shutdownHook = null;
        } else {
            this.shutdown();
        }
    }

    static File getPasswordFile(String passwordFilePath) {
        if (passwordFilePath == null || passwordFilePath.length() == 0) {
            return new File(Daemon.getRunnerHomeDir(true), PASSWORD_FILE);
        }
        return new File(passwordFilePath);
    }

    static String encrypt(String message) {
        MessageDigest d = null;
        try {
            d = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        d.reset();
        d.update(message.getBytes());
        return new String(Base64Encoder.encode(d.digest()));
    }

    static void writeToFile(File file, String content) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(content);
            fw.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating file.", e);
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
                fw = null;
            }
            catch (IOException e) {}
        }
    }

    static int getShutdownPort() {
        int port = shutdownPort;
        String sPort = Daemon.readDaemonProperty(OPT_SHUTDOWN_PORT);
        port = Daemon.parseSafeInt(sPort);
        if (port != -1) {
            return port;
        }
        return shutdownPort;
    }

    static String getShutdown() {
        String read = Daemon.readDaemonProperty(OPT_SHUTDOWN_CMD);
        if (read != null && read.length() > 0) {
            return read;
        }
        return shutdown;
    }

    private void await() {
        this.createInfoFile();
        this.createLockFile();
        this.shutdownHook = this.createShutdownHook();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        try {
            LOG.debug((Object)("Setting up shutdown port on " + Daemon.getShutdownPort()));
            this.serverSocket = new ServerSocket(Daemon.getShutdownPort());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set up shutdown port [" + Daemon.getShutdownPort() + "].", e);
        }
        while (this.continueAwait) {
            try {
                new ClientHandler().handle(this.serverSocket.accept());
            }
            catch (IOException e) {
                LOG.debug((Object)("Stopped accepting connections." + e.getMessage()));
            }
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.trace((Object)"Finished awaiting...");
    }

    private void stopAwait() {
        this.continueAwait = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
                LOG.info((Object)"Stopped shutdown port.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private StoppableJavaRunner createJavaRunner() {
        return new DefaultJavaRunner();
    }

    private Thread createShutdownHook() {
        return new Thread(new Runnable(){

            public void run() {
                LOG.trace((Object)"Executing shutdown hook...");
                Daemon.this.shutdown();
            }
        }, "Pax Runner Daemon Shutdown Hook");
    }

    private void createLockFile() {
        File lock = new File(Daemon.getRunnerHomeDir(true), LOCK_FILE);
        if (lock.exists()) {
            throw new RuntimeException("org.ops4j.pax.runner.daemon.lock exists. Please make sure that the Pax Runner daemon is not already running.");
        }
        try {
            lock.createNewFile();
            lock.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createInfoFile() {
        File info = new File(Daemon.getRunnerHomeDir(true), INFO_FILE);
        for (int count = 10; info.exists() && count > 0; --count) {
            info.delete();
        }
        try {
            info.createNewFile();
            String content = "org.ops4j.pax.runner.daemon.shutdown.cmd=" + shutdown + NEWLINE + OPT_SHUTDOWN_PORT + "=" + shutdownPort;
            Daemon.writeToFile(info, content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readEncryptedPassword() {
        return this.readFile(Daemon.getPasswordFile(this.commandLine.getOption(PASSWORD_FILE)));
    }

    private String readFile(File file) {
        try {
            LOG.debug((Object)("Read file:" + file.getAbsolutePath()));
            BufferedReader br = new BufferedReader(new FileReader(file));
            return br.readLine();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void shutdown() {
        this.stopAwait();
        if (this.runner != null) {
            LOG.debug((Object)"Bringing down Runner...");
            this.runner.shutdown();
            this.runner = null;
            LOG.info((Object)"Pax Runner daemon stopped.");
        }
    }

    private void setShutdownPort(String shutdownPort) {
        if (Daemon.parseSafeInt(shutdownPort) != -1) {
            Daemon.shutdownPort = Daemon.parseSafeInt(shutdownPort);
        }
    }

    private void setNetworkTimeout(String networkTimeout) {
        if (Daemon.parseSafeInt(networkTimeout) != -1) {
            this.networkTimeout = Daemon.parseSafeInt(networkTimeout);
        }
    }

    private void setShutdownTimeout(String shutdownTimeout) {
        if (Daemon.parseSafeInt(shutdownTimeout) != -1) {
            this.shutdownTimeout = Daemon.parseSafeInt(shutdownTimeout);
        }
    }

    private static File getRunnerHomeDir(boolean create) {
        String homeDirPath = System.getProperty("user.home") + File.separator + ".pax" + File.separator + "runner";
        File homeDir = new File(homeDirPath);
        if (!homeDir.exists() && create && homeDir.mkdirs()) {
            LOG.debug((Object)"Created Pax Runner Home.");
        }
        return homeDir;
    }

    private static int parseSafeInt(String arg) {
        if (arg != null && arg.length() > 0) {
            try {
                return Integer.parseInt(arg);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    private static String readDaemonProperty(String key) {
        File info = new File(Daemon.getRunnerHomeDir(false), INFO_FILE);
        if (info.exists()) {
            Properties props = new Properties();
            try {
                props.load(new FileInputStream(info));
                return props.getProperty(key);
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void setShutdown(String shutdown) {
        if (shutdown != null && shutdown.length() > 0) {
            Daemon.shutdown = shutdown;
        }
    }

    class ClientHandler {
        ClientHandler() {
        }

        public void handle(final Socket socket) {
            new Thread(new Runnable(){

                public void run() {
                    boolean isLocalConnect = false;
                    InputStream stream = null;
                    PrintWriter out = null;
                    try {
                        isLocalConnect = socket.getInetAddress().isLoopbackAddress();
                        socket.setSoTimeout(Daemon.this.networkTimeout);
                        LOG.trace((Object)"Connected.");
                        stream = socket.getInputStream();
                        out = new PrintWriter(socket.getOutputStream(), true);
                    }
                    catch (AccessControlException ace) {
                        LOG.warn((Object)("StandardServer.accept security exception: " + ace.getMessage()), (Throwable)ace);
                        return;
                    }
                    catch (IOException e) {
                        return;
                    }
                    if (!isLocalConnect) {
                        String welcome = "Welcome to Pax-Runner Remote Console";
                        String underline = "===============================================";
                        out.write(underline.substring(0, welcome.length()) + Daemon.NEWLINE);
                        out.write(welcome + Daemon.NEWLINE);
                        out.write(underline.substring(0, welcome.length()) + Daemon.NEWLINE);
                        out.flush();
                        String passwordHash = new String(Daemon.this.readEncryptedPassword());
                        if (passwordHash != null && passwordHash.trim().length() > 0) {
                            boolean matched = false;
                            for (int count = 3; count > 0; --count) {
                                out.write("Please enter password: ");
                                out.flush();
                                String clientPassword = ClientHandler.this.readStream(stream);
                                ClientHandler.this.readStream(stream);
                                clientPassword = new String(Daemon.encrypt(clientPassword));
                                if (!passwordHash.trim().equals(clientPassword.trim())) continue;
                                matched = true;
                                break;
                            }
                            if (!matched) {
                                out.write("Invalid password attempts exceeded limits.\r\n");
                                out.write("Try connecting again.\r\n");
                                out.flush();
                                try {
                                    socket.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                    }
                    LOG.trace((Object)"Going to ask the client to supply command.");
                    out.write("Enter the command to shutdown the Pax Runner:\r\n");
                    out.write("> ");
                    out.flush();
                    String command = ClientHandler.this.readStream(stream);
                    LOG.trace((Object)("Recieved Command [ " + command + "] from [" + socket.getRemoteSocketAddress() + "]."));
                    try {
                        String[] commands = command.split("\\\\s+");
                        if (commands.length > 1) {
                            command = commands[0];
                            Daemon.this.setShutdownTimeout(command);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    boolean match = command.toString().equals(shutdown);
                    if (match) {
                        LOG.trace((Object)"Shutdown command recieved via Telnet.");
                        LOG.trace((Object)("Stop after " + Daemon.this.shutdownTimeout + "ms."));
                        try {
                            Thread.sleep(Daemon.this.shutdownTimeout);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)"Problems in shutdown timeout.");
                        }
                        Daemon.this.stop();
                        return;
                    }
                    LOG.warn((Object)"Pax Runner: Invalid command.");
                    out.write("Invalid Command!\r\n");
                    out.flush();
                    try {
                        LOG.trace((Object)"Closing the socket now that we are done with it...");
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Exception in closing socket..", (Throwable)e);
                    }
                }
            }, "ClientHandler-" + socket.getRemoteSocketAddress()).start();
        }

        private String readStream(InputStream stream) {
            StringBuffer command = new StringBuffer();
            for (int expected = 1024; stream != null && expected > 0; --expected) {
                int ch = -1;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
            }
            return command.toString();
        }
    }

    class RunnerLauncher
    extends Thread {
        RunnerLauncher() {
            super("RunnerLauncher");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (Daemon.this.runner == null) {
                Daemon.this.runner = Daemon.this.createJavaRunner();
                LOG.trace((Object)"Created Runner.");
            }
            try {
                Run.main(Daemon.this.runner, Daemon.this.cmdArgs);
            }
            finally {
                instance.shutdown();
            }
        }
    }
}

