/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.commons.Info;

public class StreamUtils {
    private static final Log LOGGER = LogFactory.getLog(StreamUtils.class);

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(InputStream in, BufferedOutputStream out, ProgressBar progressBar) throws IOException {
        NullArgumentException.validateNotNull(in, "Input stream");
        NullArgumentException.validateNotNull(out, "Output stream");
        long start = System.currentTimeMillis();
        int b = in.read();
        int counter = 0;
        int bytes = 0;
        ProgressBar feedbackBar = progressBar;
        if (feedbackBar == null) {
            feedbackBar = new NullProgressBar();
        }
        try {
            while (b != -1) {
                out.write(b);
                b = in.read();
                counter = (counter + 1) % 102400;
                if (counter == 0) {
                    feedbackBar.increment(bytes, (long)bytes / Math.max(System.currentTimeMillis() - start, 1L));
                }
                ++bytes;
            }
        }
        finally {
            feedbackBar.increment(bytes, (long)bytes / Math.max(System.currentTimeMillis() - start, 1L));
            feedbackBar.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCopy(URL url, BufferedOutputStream out, ProgressBar progressBar) throws IOException {
        NullArgumentException.validateNotNull(url, "URL");
        InputStream is = null;
        try {
            is = url.openStream();
            StreamUtils.streamCopy(is, out, progressBar);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public static class CoarseGrainedProgressBar
    implements ProgressBar {
        private final String m_downloadTargetName;
        private long m_bytes;
        private long m_kbps;

        public CoarseGrainedProgressBar(String downloadTargetName) {
            this.m_downloadTargetName = downloadTargetName;
            LOGGER.info((Object)(downloadTargetName + " : downloading..."));
        }

        public void increment(long bytes, long kbps) {
            this.m_bytes = bytes;
            this.m_kbps = kbps;
        }

        public void stop() {
            LOGGER.info((Object)(this.m_downloadTargetName + " : " + this.m_bytes + " bytes @ [ " + this.m_kbps + "kBps ]"));
        }
    }

    public static class FineGrainedProgressBar
    implements ProgressBar {
        int counter = 0;
        private final String m_downloadTargetName;

        public FineGrainedProgressBar(String downloadTargetName) {
            this.m_downloadTargetName = downloadTargetName;
            Info.print(downloadTargetName + " : connecting...\r");
        }

        public void increment(long bytes, long kbps) {
            Info.print(this.m_downloadTargetName + " : " + bytes + " bytes @ [ " + kbps + "kBps ]\r");
            ++this.counter;
        }

        public void stop() {
            Info.println();
        }
    }

    public static class NullProgressBar
    implements ProgressBar {
        public void increment(long bytes, long kbps) {
        }

        public void stop() {
        }
    }

    public static interface ProgressBar {
        public void increment(long var1, long var3);

        public void stop();
    }
}

