/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.dir.internal.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.url.dir.internal.ResourceLocator;
import org.ops4j.pax.url.dir.internal.bundle.DuplicateAwareJarOutputStream;

public class BundleBuilder {
    private ResourceLocator m_resourceLocator;
    private Properties m_refs;

    public BundleBuilder(Properties ref, ResourceLocator resourceLocator) {
        NullArgumentException.validateNotNull(ref, "ref");
        NullArgumentException.validateNotNull(resourceLocator, "resourceLocator");
        this.m_resourceLocator = resourceLocator;
        this.m_refs = ref;
    }

    public InputStream build() {
        try {
            final PipedOutputStream pout = new PipedOutputStream();
            PipedInputStream fis = new PipedInputStream(pout);
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DuplicateAwareJarOutputStream jos = new DuplicateAwareJarOutputStream(pout);
                        BundleBuilder.this.m_resourceLocator.write(jos);
                        jos.close();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        try {
                            pout.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }.start();
            if (this.m_refs.getProperty("Bundle-SymbolicName") == null) {
                this.m_refs.setProperty("Bundle-SymbolicName", "BuiltByDirUrlHandler");
            }
            InputStream result = BndUtils.createBundle(fis, this.m_refs, this.m_resourceLocator.toString());
            fis.close();
            pout.close();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

