/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tinybundles.dp.intern;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.DPContentType;
import org.ops4j.store.Handle;

public class Bucket {
    private final Map<String, TypedBinaryHandle> m_store = new HashMap<String, TypedBinaryHandle>();
    private final Set<String> m_missing = new HashSet<String>();

    public String[] getEntries() {
        return this.m_store.keySet().toArray(new String[this.m_store.size()]);
    }

    public boolean isMissing(String entry) {
        return this.m_missing.contains(entry);
    }

    public void remove(String entry) {
        this.m_store.remove(entry);
    }

    public void store(String entry, Handle binaryHandle, DPContentType type, boolean includeContent) {
        if (!includeContent) {
            this.m_missing.add(entry);
        } else {
            this.m_missing.remove(entry);
        }
        this.m_store.put(entry, new TypedBinaryHandle(binaryHandle, type));
    }

    public Handle getHandle(String entry) {
        return this.m_store.get(entry);
    }

    public boolean isType(String name, DPContentType bundle) {
        return this.m_store.get(name).getType() == bundle;
    }

    private class TypedBinaryHandle
    implements Handle {
        private final Handle m_handle;
        private final DPContentType m_type;

        public TypedBinaryHandle(Handle handle, DPContentType type) {
            this.m_handle = handle;
            this.m_type = type;
        }

        public String getIdentification() {
            return this.m_handle.getIdentification();
        }

        public DPContentType getType() {
            return this.m_type;
        }
    }
}

