/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.swissbox.tinybundles.dp.intern;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundle;
import org.ops4j.pax.swissbox.tinybundles.dp.TinyDP;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.Bucket;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.DPBuilder;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.DPContentType;
import org.ops4j.pax.swissbox.tinybundles.dp.intern.VersionRange;
import org.ops4j.store.Store;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TinyDPImpl
implements TinyDP {
    private static Log LOG = LogFactory.getLog(TinyDPImpl.class);
    private final Store<InputStream> m_cache;
    private final Bucket m_meta;
    private final DPBuilder m_builder;
    private final Map<String, String> m_dpHeaders = new HashMap<String, String>();

    public TinyDPImpl(DPBuilder builder, InputStream parent, Bucket bucket, Store<InputStream> cache) {
        this.m_cache = cache;
        this.m_builder = builder;
        this.m_meta = bucket;
        if (parent != null) {
            JarInputStream jin = null;
            try {
                ZipEntry entry;
                jin = new JarInputStream(parent);
                Manifest man = jin.getManifest();
                Attributes att = man.getMainAttributes();
                for (Object o : att.keySet()) {
                    String k = o.toString();
                    String v = att.getValue(k);
                    if (k.equals("DeploymentPackage-Version")) {
                        VersionRange versionRange = VersionRange.parse(v);
                        Version is = versionRange.getLow();
                        String n = is.getMajor() + "." + is.getMinor() + "." + (is.getMicro() + 1) + (is.getQualifier() != null && is.getQualifier().trim().length() > 0 ? "-" + is.getQualifier() : "");
                        this.set("DeploymentPackage-FixPack", "(0," + n + "]");
                        this.set("DeploymentPackage-Version", n);
                    }
                    this.set(k, v);
                }
                HashSet<String> bundles = new HashSet<String>();
                HashSet<String> resources = new HashSet<String>();
                for (String s : man.getEntries().keySet()) {
                    Attributes attrs = man.getAttributes(s);
                    if (attrs.getValue("Bundle-SymbolicName") != null) {
                        bundles.add(s);
                        continue;
                    }
                    resources.add(s);
                }
                while ((entry = jin.getNextEntry()) != null) {
                    if (bundles.contains(entry.getName())) {
                        this.setBundle(entry.getName(), jin, false);
                        continue;
                    }
                    if (!resources.contains(entry.getName())) continue;
                    this.setResource(entry.getName(), jin, false);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (jin != null) {
                    try {
                        jin.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    @Override
    public TinyDP setBundle(String s, TinyBundle bundle) throws IOException {
        return this.setBundle(s, bundle.build());
    }

    @Override
    public TinyDP setBundle(String name, String inp) throws IOException {
        return this.setBundle(name, new URL(inp).openStream());
    }

    @Override
    public TinyDP setBundle(String name, InputStream inp) throws IOException {
        this.setBundle(name, inp, true);
        return this;
    }

    @Override
    public TinyDP setResource(String name, InputStream inp) throws IOException {
        return this.addResource(name, inp);
    }

    @Override
    public TinyDP setResource(String name, String url) throws IOException {
        return this.addResource(name, new URL(url).openStream());
    }

    @Override
    public TinyDP set(String key, String value) {
        this.m_dpHeaders.put(key, value);
        return this;
    }

    @Override
    public TinyDP setSymbolicName(String value) {
        return this.set("DeploymentPackage-SymbolicName", value);
    }

    @Override
    public TinyDP setVersion(String value) {
        return this.set("DeploymentPackage-Version", value);
    }

    @Override
    public TinyDP remove(String s) {
        this.m_meta.remove(s);
        return this;
    }

    @Override
    public InputStream build() throws IOException {
        return this.m_builder.build(this.m_dpHeaders, this.m_cache, this.m_meta);
    }

    private TinyDP setBundle(String name, InputStream inp, boolean includeContent) throws IOException {
        this.m_meta.store(name, this.m_cache.store((Object)inp), DPContentType.BUNDLE, includeContent);
        return this;
    }

    private TinyDP addResource(String name, InputStream inp) throws IOException {
        this.setResource(name, inp, true);
        return this;
    }

    private TinyDP setResource(String name, InputStream inp, boolean includeContent) throws IOException {
        this.m_meta.store(name, this.m_cache.store((Object)inp), DPContentType.OTHERRESOURCE, includeContent);
        return this;
    }
}

