/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import org.ops4j.pax.transx.connection.utils.AbstractConnectionHandle;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.Wrappers;

public class ConnectionHandle<MCF extends AbstractManagedConnectionFactory<MCF, MC, Connection, ConnectionHandle<MCF, MC>>, MC extends AbstractManagedConnection<MCF, MC, Connection, ConnectionHandle<MCF, MC>>>
extends AbstractConnectionHandle<MCF, MC, Connection, ConnectionHandle<MCF, MC>>
implements Connection {
    public ConnectionHandle(MCF mcf, ConnectionRequestInfo cri, MC mc) {
        super(mcf, cri, mc);
    }

    @Override
    protected <E extends Exception> E wrapException(String msg, Exception e) {
        if (msg == null && e instanceof SQLException) {
            return (E)e;
        }
        if (msg == null && e != null && e.getCause() instanceof SQLException) {
            return (E)((Exception)e.getCause());
        }
        return (E)new SQLException(msg, e);
    }

    @Override
    public void commit() throws SQLException {
        Object mc = this.getManagedConnection();
        if (((AbstractManagedConnection)mc).isInXaTransaction()) {
            throw new SQLException("Can not commit within an XA transaction");
        }
        Connection c = (Connection)((AbstractManagedConnection)mc).getPhysicalConnection();
        if (c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = ((AbstractManagedConnection)mc).getClientLocalTransaction();
            tx.commit();
            tx.begin();
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        Object mc = this.getManagedConnection();
        if (((AbstractManagedConnection)mc).isInXaTransaction()) {
            throw new SQLException("Can not rollback within an XA transaction");
        }
        Connection c = (Connection)((AbstractManagedConnection)mc).getPhysicalConnection();
        if (c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = ((AbstractManagedConnection)mc).getClientLocalTransaction();
            tx.rollback();
            tx.begin();
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Object mc = this.getManagedConnection();
        if (((AbstractManagedConnection)mc).isInXaTransaction()) {
            throw new SQLException("Can not set autoCommit within an XA transaction");
        }
        Connection c = (Connection)((AbstractManagedConnection)mc).getPhysicalConnection();
        if (autoCommit == c.getAutoCommit()) {
            return;
        }
        try {
            LocalTransaction tx = ((AbstractManagedConnection)mc).getClientLocalTransaction();
            if (autoCommit) {
                tx.commit();
            } else {
                tx.begin();
            }
        }
        catch (ResourceException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.call(Connection::getAutoCommit);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.wrapStatement(this.call(Connection::createStatement));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapStatement(this.call(c -> c.createStatement(resultSetType, resultSetConcurrency)));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapStatement(this.call(c -> c.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql, autoGeneratedKeys)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql, columnIndexes)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql, columnNames)));
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.call(Connection::createClob);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.call(Connection::createBlob);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.call(Connection::createNClob);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.call(Connection::createSQLXML);
    }

    @Override
    public boolean isValid(int i) throws SQLException {
        return this.call(c -> c.isValid(i));
    }

    @Override
    public void setClientInfo(String s, String s1) throws SQLClientInfoException {
        this.execute(c -> c.setClientInfo(s, s1));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.execute(c -> c.setClientInfo(properties));
    }

    @Override
    public String getClientInfo(String s) throws SQLException {
        return this.call(c -> c.getClientInfo(s));
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.call(Connection::getClientInfo);
    }

    @Override
    public Array createArrayOf(String s, Object[] objects) throws SQLException {
        return this.call(c -> c.createArrayOf(s, objects));
    }

    @Override
    public Struct createStruct(String s, Object[] objects) throws SQLException {
        return this.call(c -> c.createStruct(s, objects));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql, resultSetType, resultSetConcurrency)));
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapPreparedStatement(this.call(c -> c.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability)));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.wrapCallableStatement(this.call(c -> c.prepareCall(sql)));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.wrapCallableStatement(this.call(c -> c.prepareCall(sql, resultSetType, resultSetConcurrency)));
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.wrapCallableStatement(this.call(c -> c.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability)));
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.wrapMetaData(this.call(Connection::getMetaData));
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.call(Connection::getCatalog);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.execute(c -> c.setCatalog(catalog));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.call(Connection::getHoldability);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.execute(c -> c.setHoldability(holdability));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.call(Connection::getTransactionIsolation);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.execute(c -> c.setTransactionIsolation(level));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.call(Connection::getTypeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.execute(c -> c.setTypeMap(map));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.call(Connection::getWarnings);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.execute(Connection::clearWarnings);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.call(Connection::isReadOnly);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.execute(c -> c.setReadOnly(readOnly));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.call(Connection::setSavepoint);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.call(c -> c.setSavepoint(name));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.execute(c -> c.releaseSavepoint(savepoint));
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.execute(c -> c.rollback(savepoint));
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.call(c -> c.nativeSQL(sql));
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.execute(c -> c.setSchema(schema));
    }

    @Override
    public String getSchema() throws SQLException {
        return this.call(Connection::getSchema);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.execute(c -> c.abort(executor));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.execute(c -> c.setNetworkTimeout(executor, milliseconds));
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.call(Connection::getNetworkTimeout);
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        if (tClass.isInstance(this)) {
            return tClass.cast(this);
        }
        return (T)this.call(c -> c.unwrap(tClass));
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        if (aClass.isInstance(this)) {
            return true;
        }
        return this.call(c -> c.isWrapperFor(aClass));
    }

    private Statement wrapStatement(Statement s) {
        return Wrappers.wrap(Statement.class, this, s);
    }

    private PreparedStatement wrapPreparedStatement(PreparedStatement ps) {
        return Wrappers.wrap(PreparedStatement.class, this, ps);
    }

    private CallableStatement wrapCallableStatement(CallableStatement cs) {
        return Wrappers.wrap(CallableStatement.class, this, cs);
    }

    private DatabaseMetaData wrapMetaData(DatabaseMetaData dbmd) {
        return Wrappers.wrap(DatabaseMetaData.class, this, dbmd);
    }
}

