/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jdbc.KnownSQLStateExceptionSorter;
import org.ops4j.pax.transx.jdbc.impl.AbstractJdbcManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.ManagedJDBCConnection;

public class LocalDataSourceMCF
extends AbstractJdbcManagedConnectionFactory<LocalDataSourceMCF, ManagedJDBCConnection, DataSource> {
    public LocalDataSourceMCF(DataSource datasource) {
        this(datasource, new KnownSQLStateExceptionSorter(), true);
    }

    public LocalDataSourceMCF(DataSource dataSource, ExceptionSorter exceptionSorter, boolean commitBeforeAutocommit) {
        super(dataSource, exceptionSorter);
        this.commitBeforeAutocommit = commitBeforeAutocommit;
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return TransactionSupport.TransactionSupportLevel.LocalTransaction;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        CredentialExtractor credentialExtractor = new CredentialExtractor(subject, connectionRequestInfo, this);
        Connection jdbcConnection = this.getPhysicalConnection(credentialExtractor);
        return new ManagedJDBCConnection(this, this.wrap(jdbcConnection), credentialExtractor, this.exceptionSorter);
    }

    protected Connection getPhysicalConnection(CredentialExtractor credentialExtractor) throws ResourceException {
        try {
            String username = credentialExtractor.getUserName();
            String password = credentialExtractor.getPassword();
            if (username != null) {
                return ((DataSource)this.dataSource).getConnection(username, password);
            }
            return ((DataSource)this.dataSource).getConnection();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to obtain physical connection to " + this.dataSource, (Throwable)e);
        }
    }
}

