/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.TransactionServicePlugin;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.xa.XARecoveryManager;

public class JtaTransactionServicePlugin
implements TransactionServicePlugin {
    private static Logger LOGGER = LoggerFactory.createLogger(JtaTransactionServicePlugin.class);
    public static final String DEFAULT_JTA_TIMEOUT_PROPERTY_NAME = "com.atomikos.icatch.default_jta_timeout";
    public static final String SERIAL_JTA_TRANSACTIONS_PROPERTY_NAME = "com.atomikos.icatch.serial_jta_transactions";
    public static final String CLIENT_DEMARCATION_PROPERTY_NAME = "com.atomikos.icatch.client_demarcation";

    @Override
    public void beforeInit() {
        ConfigProperties configProperties = Configuration.getConfigProperties();
        long defaultTimeoutInMillis = configProperties.getAsLong(DEFAULT_JTA_TIMEOUT_PROPERTY_NAME);
        int defaultJtaTimeout = 0;
        defaultJtaTimeout = (int)defaultTimeoutInMillis / 1000;
        if (defaultJtaTimeout <= 0) {
            LOGGER.logWarning("WARNING: com.atomikos.icatch.default_jta_timeout should be more than 1000 milliseconds - resetting to 10000 milliseconds instead...");
            defaultJtaTimeout = 10;
        }
        TransactionManagerImp.setDefaultTimeout(defaultJtaTimeout);
        boolean defaultSerial = configProperties.getAsBoolean(SERIAL_JTA_TRANSACTIONS_PROPERTY_NAME);
        TransactionManagerImp.setDefaultSerial(defaultSerial);
    }

    @Override
    public void afterShutdown() {
        TransactionManagerImp.installTransactionManager(null);
        XARecoveryManager.installXARecoveryManager(null);
    }

    @Override
    public void afterInit() {
        TransactionManagerImp.installTransactionManager(Configuration.getCompositeTransactionManager());
        RecoveryLog recoveryLog = Configuration.getRecoveryLog();
        if (recoveryLog != null) {
            XARecoveryManager.installXARecoveryManager(Configuration.getConfigProperties().getTmUniqueName());
        }
    }
}

