/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.tm.impl.atomikos;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.config.UserTransactionService;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import com.atomikos.icatch.jta.J2eeTransactionManager;
import com.atomikos.icatch.jta.J2eeUserTransaction;
import com.atomikos.icatch.jta.TransactionManagerImp;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.transaction.UserTransaction;
import org.ops4j.pax.transx.tm.TransactionManager;
import org.ops4j.pax.transx.tm.impl.atomikos.OsgiAssembler;
import org.ops4j.pax.transx.tm.impl.atomikos.TransactionManagerWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;

public class TransactionManagerService {
    public static final String TRANSACTION_TIMEOUT = "timeout";
    public static final String RECOVERABLE = "recoverable";
    public static final String TMID = "tmid";
    public static final String HOWL_BUFFER_CLASS_NAME = "howl.bufferClassName";
    public static final String HOWL_BUFFER_SIZE = "howl.bufferSize";
    public static final String HOWL_CHECKSUM_ENABLED = "howl.checksumEnabled";
    public static final String HOWL_ADLER32_CHECKSUM = "howl.adler32Checksum";
    public static final String HOWL_FLUSH_SLEEP_TIME = "howl.flushSleepTime";
    public static final String HOWL_LOG_FILE_EXT = "howl.logFileExt";
    public static final String HOWL_LOG_FILE_NAME = "howl.logFileName";
    public static final String HOWL_MAX_BLOCKS_PER_FILE = "howl.maxBlocksPerFile";
    public static final String HOWL_MAX_LOG_FILES = "howl.maxLogFiles";
    public static final String HOWL_MAX_BUFFERS = "howl.maxBuffers";
    public static final String HOWL_MIN_BUFFERS = "howl.minBuffers";
    public static final String HOWL_THREADS_WAITING_FORCE_THRESHOLD = "howl.threadsWaitingForceThreshold";
    public static final String HOWL_LOG_FILE_DIR = "howl.logFileDir";
    public static final String HOWL_FLUSH_PARTIAL_BUFFERS = "flushPartialBuffers";
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 600;
    public static final boolean DEFAULT_RECOVERABLE = false;
    private final String pid;
    private final Dictionary properties;
    private final BundleContext bundleContext;
    private final UserTransactionService uts;
    private final TransactionManagerImp tm;
    private List<ServiceRegistration<?>> services;

    public TransactionManagerService(String pid, Dictionary<String, ?> properties, BundleContext bundleContext) throws ConfigurationException {
        this.pid = pid;
        this.properties = properties;
        this.bundleContext = bundleContext;
        int transactionTimeout = this.getInt(TRANSACTION_TIMEOUT, 600);
        if (transactionTimeout <= 0) {
            throw new ConfigurationException(TRANSACTION_TIMEOUT, "The transaction timeout property must be greater than zero.");
        }
        OsgiAssembler.setConfig(properties);
        Configuration.init();
        Configuration.getTransactionService();
        new J2eeUserTransaction();
        this.uts = new UserTransactionServiceImp();
        this.uts.init();
        this.tm = (TransactionManagerImp)TransactionManagerImp.getTransactionManager();
    }

    public void init() throws Exception {
        this.services = new ArrayList();
        this.services.add(this.bundleContext.registerService(UserTransaction.class, (Object)new J2eeUserTransaction(), null));
        this.services.add(this.bundleContext.registerService(javax.transaction.TransactionManager.class, (Object)new J2eeTransactionManager(), null));
        this.services.add(this.bundleContext.registerService(TransactionManager.class, (Object)new TransactionManagerWrapper(this.tm), null));
    }

    public void destroy() throws Exception {
        for (ServiceRegistration<?> sr : this.services) {
            try {
                sr.unregister();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.services.clear();
        Configuration.shutdown(false);
    }

    private String getString(String property, String dflt) throws ConfigurationException {
        String value;
        String string = value = this.properties != null ? (String)this.properties.get(property) : null;
        if (value != null) {
            return value;
        }
        return dflt;
    }

    private int getInt(String property, int dflt) throws ConfigurationException {
        String value;
        String string = value = this.properties != null ? (String)this.properties.get(property) : null;
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                throw new ConfigurationException(property, "The property " + property + " should have an integer value, but the value " + value + " is not an integer.", (Throwable)e);
            }
        }
        return dflt;
    }

    private boolean getBool(String property, boolean dflt) throws ConfigurationException {
        String value;
        String string = value = this.properties != null ? (String)this.properties.get(property) : null;
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                throw new ConfigurationException(property, "The property " + property + " should have an boolean value, but the value " + value + " is not a boolean.", (Throwable)e);
            }
        }
        return dflt;
    }
}

