/*
 * Decompiled with CFR 0.152.
 */
package shaded.eu.maveniverse.maven.mima.context.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import shaded.eu.maveniverse.maven.mima.context.Lookup;

public final class IteratingLookup
implements Lookup {
    private final Collection<Lookup> lookups;

    public IteratingLookup(Lookup ... lookups) {
        this(Arrays.asList(lookups));
    }

    public IteratingLookup(Collection<Lookup> lookups) {
        this.lookups = Objects.requireNonNull(lookups);
    }

    @Override
    public <T> Optional<T> lookup(Class<T> type) {
        for (Lookup lookup : this.lookups) {
            Optional<T> result = lookup.lookup(type);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> lookup(Class<T> type, String name) {
        for (Lookup lookup : this.lookups) {
            Optional<T> result = lookup.lookup(type, name);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }
}

