/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtil.class);

    private ClassPathUtil() {
    }

    public static URL[] getClassPathJars(Bundle bundle, boolean useClassSpace) {
        String bundleClasspath;
        ArrayList<URL> urls = new ArrayList<URL>();
        String string = bundleClasspath = bundle.getHeaders() == null ? null : (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            String[] segments;
            for (String segment : segments = bundleClasspath.split("\\s*,\\s*")) {
                URL url = bundle.getEntry(segment);
                if (url == null || !url.toExternalForm().endsWith("jar")) continue;
                try {
                    urls.add(new URL("jar:" + url.toExternalForm() + "!/"));
                }
                catch (MalformedURLException e) {
                    LOG.debug(e.getMessage());
                }
            }
        }
        if (useClassSpace) {
            urls.addAll(ClassPathUtil.getLocationsOfBundlesInClassSpace(bundle));
        }
        return urls.toArray(new URL[0]);
    }

    public static URL[] getClassPathURLs(Bundle bundle) {
        String bundleClasspath;
        ArrayList<URL> urls = new ArrayList<URL>();
        String string = bundleClasspath = bundle.getHeaders() == null ? null : (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            String[] segments;
            for (String segment : segments = bundleClasspath.split("\\s*,\\s*")) {
                URL url = bundle.getEntry(segment);
                if (url == null) continue;
                String ef = url.toExternalForm();
                try {
                    if (ef.endsWith("jar")) {
                        urls.add(new URL("jar:" + ef + "!/"));
                        continue;
                    }
                    if (!ef.endsWith("/")) {
                        urls.add(new URL(ef + "/"));
                        continue;
                    }
                    urls.add(url);
                }
                catch (MalformedURLException e) {
                    LOG.debug(e.getMessage());
                }
            }
        }
        return urls.toArray(new URL[0]);
    }

    public static URL[] getClassPathNonJars(Bundle bundle) {
        String[] segments;
        String bundleClasspath;
        ArrayList<URL> urls = new ArrayList<URL>();
        String string = bundleClasspath = bundle.getHeaders() == null ? null : (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath == null) {
            return new URL[]{bundle.getEntry("/")};
        }
        for (String segment : segments = bundleClasspath.split("\\s*,\\s*")) {
            URL url = bundle.getEntry(segment);
            if (url == null) continue;
            String ef = url.toExternalForm();
            try {
                if (ef.endsWith("jar")) continue;
                if (!ef.endsWith("/")) {
                    urls.add(new URL(ef + "/"));
                    continue;
                }
                urls.add(url);
            }
            catch (MalformedURLException e) {
                LOG.debug(e.getMessage());
            }
        }
        return urls.toArray(new URL[0]);
    }

    @Deprecated
    public static URL[] getClassPathJars(Bundle bundle) {
        return ClassPathUtil.getClassPathJars(bundle, true);
    }

    private static List<URL> getLocationsOfBundlesInClassSpace(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set<Bundle> importedBundles = ClassPathUtil.getBundlesInClassSpace(bundle, new HashSet<Bundle>());
        for (Bundle importedBundle : importedBundles) {
            URL url = ClassPathUtil.getLocationOfBundle(importedBundle);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private static URL getLocationOfBundle(Bundle bundle) {
        URL url = null;
        try {
            url = new URL(bundle.getLocation());
        }
        catch (MalformedURLException e) {
            try {
                url = bundle.getEntry("/");
            }
            catch (Exception e2) {
                LOG.warn("Exception while calculating location of bundle", (Throwable)e);
            }
        }
        return url;
    }

    public static Set<Bundle> getBundlesInClassSpace(Bundle bundle, Set<Bundle> bundleSet) {
        List extenderWires;
        BundleWiring bundleWiring;
        BundleWiring bundleWiring2 = bundleWiring = bundle == null ? null : (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundle == null || bundleWiring == null) {
            throw new IllegalArgumentException("Bundle, BundleContext or BundleWiring is null");
        }
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        List requiredWires = bundleWiring.getRequiredWires(null);
        for (Object bundleWire : requiredWires) {
            Bundle exportingBundle;
            if (!bundleWire.getRequirement().getNamespace().equals("osgi.wiring.bundle") && !bundleWire.getRequirement().getNamespace().equals("osgi.wiring.package") || (exportingBundle = bundleWire.getCapability().getRevision().getBundle()).getBundleId() == 0L) continue;
            bundles.add(exportingBundle);
        }
        List providedWires = bundleWiring.getProvidedWires("osgi.wiring.host");
        if (providedWires != null) {
            for (BundleWire wire : providedWires) {
                Bundle b2 = wire.getRequirerWiring().getBundle();
                bundles.add(b2);
            }
        }
        if ((extenderWires = bundleWiring.getRequiredWires("osgi.extender")) != null) {
            for (BundleWire wire : extenderWires) {
                Bundle extenderBundle = wire.getCapability().getRevision().getBundle();
                bundles.add(extenderBundle);
            }
        }
        if (!bundleSet.containsAll(bundles)) {
            bundles.removeAll(bundleSet);
            bundleSet.addAll(bundles);
            for (Bundle b2 : bundles) {
                ClassPathUtil.getBundlesInClassSpace(b2, bundleSet);
            }
        }
        bundleSet.removeIf(b -> b.getState() == 1);
        bundleSet.removeIf(b -> b.getBundleId() == 0L);
        return bundleSet;
    }

    public static List<URL> listResources(Iterable<Bundle> bundles, String path, String pattern, boolean recurse) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (Bundle bundle : bundles) {
            int options = 2 | (recurse ? 1 : 0);
            boolean isFragment = bundle.adapt(BundleRevision.class) != null && (((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0;
            if (isFragment) continue;
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            Collection names = wiring.listResources(path, pattern, options);
            for (String name : names) {
                resources.add(bundle.getResource(name));
            }
        }
        return resources;
    }

    public static List<URL> getResources(Iterable<Bundle> bundles, String path) {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (Bundle bundle : bundles) {
            boolean isFragment = bundle.adapt(BundleRevision.class) != null && (((BundleRevision)bundle.adapt(BundleRevision.class)).getTypes() & 1) != 0;
            if (isFragment) continue;
            try {
                Enumeration e = bundle.getResources(path);
                if (e == null) continue;
                while (e.hasMoreElements()) {
                    resources.add((URL)e.nextElement());
                }
            }
            catch (IOException ioe) {
                LOG.warn("Problem getting {} resource from {}: {}", new Object[]{path, bundle, ioe.getMessage(), ioe});
            }
        }
        return resources;
    }

    public static List<URL> findEntries(Bundle bundle, String path, String pattern, boolean recurse, boolean useBundleClasspath) throws IOException {
        return ClassPathUtil.findEntries(Collections.singletonList(bundle), path, pattern, recurse, useBundleClasspath);
    }

    public static List<URL> findEntries(Iterable<Bundle> bundles, String path, String pattern, boolean recurse, boolean useBundleClasspath) throws IOException {
        LinkedList<URL> resources = new LinkedList<URL>();
        if (pattern != null) {
            while (pattern.startsWith("/")) {
                pattern = pattern.substring(1);
            }
        } else {
            pattern = "*";
        }
        for (Bundle bundle : bundles) {
            int options;
            int n = options = recurse ? 1 : 0;
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (wiring == null) continue;
            List entries = wiring.findEntries(ClassPathUtil.normalizeBase(path, false), pattern, options);
            resources.addAll(entries);
            if (!useBundleClasspath) continue;
            URL[] jars = ClassPathUtil.getClassPathURLs(bundle);
            resources.addAll(ClassPathUtil.findEntries(bundle, jars, ClassPathUtil.normalizeBase(path, true), pattern, recurse));
        }
        return resources;
    }

    private static String normalizeBase(String path, boolean ensureTrailingSlash) {
        Object base;
        Object object = base = path == null ? "" : path;
        while (((String)base).startsWith("/")) {
            base = ((String)base).substring(1);
        }
        if (ensureTrailingSlash && !"".equals(base) && !((String)base).endsWith("/")) {
            base = (String)base + "/";
        }
        return base;
    }

    public static URL[] getURLs(ClassLoader loader) {
        URL[] urls = new URL[]{};
        if (loader instanceof URLClassLoader) {
            urls = ((URLClassLoader)loader).getURLs();
        } else {
            try {
                Field ucpField;
                try {
                    ucpField = loader.getClass().getDeclaredField("ucp");
                }
                catch (NoSuchFieldException e) {
                    ucpField = loader.getClass().getSuperclass().getDeclaredField("ucp");
                }
                ucpField.setAccessible(true);
                Object ucp = ucpField.get(loader);
                Method getURLsMethod = ucp.getClass().getDeclaredMethod("getURLs", new Class[0]);
                urls = (URL[])getURLsMethod.invoke(ucp, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return urls;
    }

    public static List<URL> findEntries(ClassLoader loader, String path, String pattern, boolean recurse) throws IOException {
        if (pattern == null) {
            pattern = "*";
        }
        while (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        String base = ClassPathUtil.normalizeBase(path, true);
        LinkedList<URL> roots = new LinkedList<URL>();
        if ("".equals(base)) {
            URL[] urls = ClassPathUtil.getURLs(loader);
            if (urls.length == 1 && urls[0].toExternalForm().endsWith("jar")) {
                urls = ClassPathUtil.jarToItsClassPath(urls[0]);
            }
            for (URL entry : urls) {
                File dir;
                if ("jar".equals(entry.getProtocol())) {
                    roots.add(entry);
                    continue;
                }
                if (entry.getPath().endsWith(".jar")) {
                    roots.add(new URL("jar:" + entry.toExternalForm() + "!/"));
                    continue;
                }
                if (!"file".equals(entry.getProtocol()) || !(dir = new File(URI.create(entry.toExternalForm()))).isDirectory()) continue;
                roots.add(dir.toURI().toURL());
            }
        } else {
            Enumeration<URL> e = loader.getResources(base);
            while (e.hasMoreElements()) {
                roots.add(e.nextElement());
            }
        }
        LinkedList<URL> resources = new LinkedList<URL>();
        ClassPathUtil.scanRoots(null, roots, pattern, recurse, resources);
        return resources;
    }

    public static URL[] jarToItsClassPath(URL url) throws IOException {
        String cp;
        URL[] urls = new URL[]{url};
        URLConnection con = new URL("jar:" + urls[0].toExternalForm() + "!/").openConnection();
        if (con instanceof JarURLConnection && (cp = ((JarURLConnection)con).getManifest().getMainAttributes().getValue("Class-Path")) != null) {
            String[] entries = cp.split(" ");
            urls = new URL[entries.length];
            int pos = 0;
            for (String e : entries) {
                urls[pos++] = new URL(e);
            }
        }
        return urls;
    }

    public static List<URL> findEntries(Bundle bundle, URL[] roots, String path, String pattern, boolean recurse) throws IOException {
        LinkedList<URL> resources = new LinkedList<URL>();
        while (pattern.startsWith("/")) {
            pattern = pattern.substring(1);
        }
        LinkedList<URL> newRoots = new LinkedList<URL>();
        String base = ClassPathUtil.normalizeBase(path, true);
        for (URL root : roots) {
            newRoots.add(new URL(root, base));
        }
        ClassPathUtil.scanRoots(bundle, newRoots, pattern, recurse, resources);
        return resources;
    }

    private static void scanRoots(Bundle bundle, List<URL> roots, String pattern, boolean recurse, List<URL> resources) {
        Pattern p = Pattern.compile(pattern.replaceAll("\\?", ".").replaceAll("\\*", ".*"));
        for (URL root : roots) {
            String protocol = root.getProtocol();
            if ("jar".equals(protocol) && !ClassPathUtil.jarClassPathEntryExists(root)) continue;
            if ("jar".equals(protocol)) {
                ClassPathUtil.scanJar(root, p, recurse, resources);
                continue;
            }
            if ("file".equals(protocol)) {
                ClassPathUtil.scanDirectory(new File(URI.create(root.toExternalForm())), p, recurse, resources);
                continue;
            }
            if (bundle == null || !"bundle".equals(protocol) && !"bundleresource".equals(protocol) && !"bundleentry".equals(protocol)) continue;
            ClassPathUtil.scanBundle(bundle, root, pattern, recurse, resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanJar(URL root, Pattern pattern, boolean recurse, Collection<URL> result) {
        boolean closeJar = false;
        ZipFile jar = null;
        try {
            Object rootEntryPath;
            URLConnection con = root.openConnection();
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                jar = jarCon.getJarFile();
                JarEntry jarEntry = jarCon.getJarEntry();
                rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
                closeJar = !jarCon.getUseCaches();
            } else {
                String location = root.getFile();
                int separator = location.indexOf("!/");
                if (separator != -1) {
                    jar = new JarFile(location.substring(0, separator));
                    rootEntryPath = location.substring(separator + 2);
                } else {
                    jar = new JarFile(location);
                    rootEntryPath = "";
                }
                closeJar = true;
            }
            if (!"".equals(rootEntryPath) && !((String)rootEntryPath).endsWith("/")) {
                rootEntryPath = (String)rootEntryPath + "/";
            }
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith((String)rootEntryPath)) continue;
                String relativePath = entryPath.substring(((String)rootEntryPath).length());
                if (relativePath.startsWith("/")) {
                    relativePath = relativePath.substring(1);
                }
                if (!ClassPathUtil.matches(relativePath, pattern, recurse)) continue;
                relativePath = relativePath.replaceAll("#", "%23");
                result.add(new URL(root, relativePath));
            }
        }
        catch (IOException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
        finally {
            if (closeJar && jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void scanBundle(Bundle bundle, URL root, String pattern, boolean recurse, Collection<URL> result) {
        Enumeration e = bundle.findEntries(root.getPath(), pattern, recurse);
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            result.add((URL)e.nextElement());
        }
    }

    private static void scanDirectory(File file, final Pattern pattern, final boolean recurse, final Collection<URL> result) {
        if (!file.isDirectory()) {
            return;
        }
        try {
            final Path root = file.toPath();
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relativePath = root.relativize(file).toString();
                    if (ClassPathUtil.matches(relativePath, pattern, recurse)) {
                        result.add(new URL(root.toUri().toURL(), relativePath));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static boolean matches(String path, Pattern pattern, boolean recurse) {
        String nPath = path.replaceAll("\\\\", "/");
        return recurse ? pattern.matcher(nPath).find() : pattern.matcher(nPath).matches();
    }

    public static boolean jarClassPathEntryExists(URL root) {
        String protocol = root.getProtocol();
        if (!"jar".equals(protocol)) {
            throw new IllegalArgumentException(root + " url not supported");
        }
        try {
            URLConnection con = root.openConnection();
            if (con.getContentLengthLong() > 0L) {
                return true;
            }
            con.getInputStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

