/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.JsrSessionListener;

public class JsrSessionTracker
extends AbstractLifeCycle
implements JsrSessionListener,
Dumpable {
    private final Set<JsrSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<Session> getSessions() {
        return Collections.unmodifiableSet(new HashSet<JsrSession>(this.sessions));
    }

    @Override
    public void onSessionOpened(JsrSession session) {
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(JsrSession session) {
        this.sessions.remove(session);
    }

    @Override
    protected void doStop() throws Exception {
        for (Session session : this.sessions) {
            LifeCycle.stop(session);
        }
        super.doStop();
    }

    @ManagedAttribute(value="Total number of active WebSocket Sessions")
    public int getNumSessions() {
        return this.sessions.size();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.sessions);
    }
}

