/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.File;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.SessionCookieConfig;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.http.HttpSessionAttributeListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.ClientCertAuthenticator;
import org.eclipse.jetty.security.authentication.ConfigurableSpnegoAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.FileSessionDataStoreFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.ops4j.pax.web.service.AuthenticatorService;
import org.ops4j.pax.web.service.jetty.internal.JettyFactory;
import org.ops4j.pax.web.service.jetty.internal.JettyServerControllerFactory;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterHolder;
import org.ops4j.pax.web.service.jetty.internal.PaxWebFilterMapping;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletContextHandler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHandler;
import org.ops4j.pax.web.service.jetty.internal.PaxWebServletHolder;
import org.ops4j.pax.web.service.jetty.internal.PaxWebSessionIdManager;
import org.ops4j.pax.web.service.jetty.internal.PrioritizedHandlerCollection;
import org.ops4j.pax.web.service.jetty.internal.PriorityValue;
import org.ops4j.pax.web.service.jetty.internal.web.JettyResourceServlet;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.config.LogConfiguration;
import org.ops4j.pax.web.service.spi.config.SessionConfiguration;
import org.ops4j.pax.web.service.spi.model.ContextMetadataModel;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.model.ServletContextModel;
import org.ops4j.pax.web.service.spi.model.elements.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.elements.ElementModel;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.SecurityConstraintModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.SessionConfigurationModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;
import org.ops4j.pax.web.service.spi.model.elements.WelcomeFileModel;
import org.ops4j.pax.web.service.spi.model.events.ServerEvent;
import org.ops4j.pax.web.service.spi.servlet.Default404Servlet;
import org.ops4j.pax.web.service.spi.servlet.DynamicRegistrations;
import org.ops4j.pax.web.service.spi.servlet.OsgiDynamicServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiInitializedServlet;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContext;
import org.ops4j.pax.web.service.spi.servlet.OsgiServletContextClassLoader;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;
import org.ops4j.pax.web.service.spi.servlet.PreprocessorFilterConfig;
import org.ops4j.pax.web.service.spi.servlet.RegisteringContainerInitializer;
import org.ops4j.pax.web.service.spi.servlet.SCIWrapper;
import org.ops4j.pax.web.service.spi.task.BatchVisitor;
import org.ops4j.pax.web.service.spi.task.Change;
import org.ops4j.pax.web.service.spi.task.ClearDynamicRegistrationsChange;
import org.ops4j.pax.web.service.spi.task.ContainerInitializerModelChange;
import org.ops4j.pax.web.service.spi.task.ContextMetadataModelChange;
import org.ops4j.pax.web.service.spi.task.ContextParamsChange;
import org.ops4j.pax.web.service.spi.task.ContextStartChange;
import org.ops4j.pax.web.service.spi.task.ContextStopChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageModelChange;
import org.ops4j.pax.web.service.spi.task.ErrorPageStateChange;
import org.ops4j.pax.web.service.spi.task.EventListenerModelChange;
import org.ops4j.pax.web.service.spi.task.FilterModelChange;
import org.ops4j.pax.web.service.spi.task.FilterStateChange;
import org.ops4j.pax.web.service.spi.task.MimeAndLocaleMappingChange;
import org.ops4j.pax.web.service.spi.task.OpCode;
import org.ops4j.pax.web.service.spi.task.OsgiContextModelChange;
import org.ops4j.pax.web.service.spi.task.SecurityConfigChange;
import org.ops4j.pax.web.service.spi.task.ServletContextModelChange;
import org.ops4j.pax.web.service.spi.task.ServletModelChange;
import org.ops4j.pax.web.service.spi.task.TransactionStateChange;
import org.ops4j.pax.web.service.spi.task.WebSocketModelChange;
import org.ops4j.pax.web.service.spi.task.WelcomeFileModelChange;
import org.ops4j.pax.web.service.spi.util.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JettyServerWrapper
implements BatchVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JettyServerWrapper.class);
    private final Bundle paxWebJettyBundle;
    private final ClassLoader classLoader;
    private Server server;
    private QueuedThreadPool qtp;
    private MBeanContainer mbeanContainer;
    private final PrioritizedHandlerCollection mainHandler;
    private final Map<String, HttpConfiguration> httpConfigs = new LinkedHashMap<String, HttpConfiguration>();
    private final JettyFactory jettyFactory;
    private final Set<String> transactions = new HashSet<String>();
    private final Map<String, List<ElementModel<?, ?>>> delayedRemovals = new HashMap();
    private final Map<String, PaxWebServletContextHandler> contextHandlers = new HashMap<String, PaxWebServletContextHandler>();
    private final Map<OsgiContextModel, OsgiServletContext> osgiServletContexts = new HashMap<OsgiContextModel, OsgiServletContext>();
    private final Map<String, TreeSet<OsgiContextModel>> osgiContextModels = new HashMap<String, TreeSet<OsgiContextModel>>();
    private final Map<String, LinkedHashMap<Integer, SCIWrapper>> initializers = new HashMap<String, LinkedHashMap<Integer, SCIWrapper>>();
    private final Map<String, DynamicRegistrations> dynamicRegistrations = new HashMap<String, DynamicRegistrations>();
    private final Configuration configuration;
    private final Default404Servlet default404Servlet = new Default404Servlet();
    private SessionCookieConfig defaultSessionCookieConfig;
    private final List<EventListenerModel> sessionListenerModels = new ArrayList<EventListenerModel>();
    private final Set<PriorityValue<HttpConfiguration.Customizer>> registeredCustomizers = new TreeSet(JettyServerControllerFactory.priorityComparator);
    private final Map<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>> contextSecurityConstraints = new HashMap<String, TreeMap<OsgiContextModel, SecurityConfigurationModel>>();

    JettyServerWrapper(Configuration config, JettyFactory jettyFactory, Bundle paxWebJettyBundle, ClassLoader classLoader) {
        this.configuration = config;
        this.jettyFactory = jettyFactory;
        this.paxWebJettyBundle = paxWebJettyBundle;
        this.classLoader = classLoader;
        this.mainHandler = new PrioritizedHandlerCollection();
    }

    public void configure() throws Exception {
        LOG.info("Creating Jetty server instance using configuration properties.");
        this.createServer();
        this.server.setHandler(this.mainHandler);
        this.applyJettyConfiguration();
        this.verifyConnectorConfiguration();
        this.qtp = (QueuedThreadPool)this.server.getThreadPool();
        LOG.info("Eagerly starting Jetty thread pool {}", (Object)this.qtp);
        this.qtp.start();
        if (this.server.getErrorHandler() == null) {
            this.server.setErrorHandler(new ErrorHandler());
        }
        if (this.configuration.logging().isLogNCSAFormatEnabled().booleanValue() && this.server.getRequestLog() == null) {
            this.configureRequestLog();
        }
        this.defaultSessionCookieConfig = this.configuration.session().getDefaultSessionCookieConfig();
        if (this.configuration.session().getSessionStoreDirectory() != null) {
            FileSessionDataStoreFactory dsFactory = new FileSessionDataStoreFactory();
            dsFactory.setDeleteUnrestorableFiles(true);
            dsFactory.setStoreDir(this.configuration.session().getSessionStoreDirectory());
            this.server.addBean(dsFactory);
        }
        this.configureServerCustomizers();
        this.mbeanContainer = this.jettyFactory.enableJmxIfPossible(this.server);
    }

    private void createServer() {
        QueuedThreadPool qtp = this.jettyFactory.createThreadPool(this.configuration);
        this.server = new Server(qtp);
        this.server.setSessionIdManager(new PaxWebSessionIdManager(this.server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyJettyConfiguration() throws Exception {
        File[] locations = this.configuration.server().getConfigurationFiles();
        URL jettyResource = this.getClass().getResource("/jetty.xml");
        if (locations.length == 0) {
            if (jettyResource == null) {
                LOG.info("No external Jetty configuration files specified. Default/PID configuration will be used.");
            } else {
                LOG.info("Found \"jetty.xml\" resource on the classpath: {}.", (Object)jettyResource);
            }
        } else {
            LOG.info("Processing Jetty configuration from files: {}", Arrays.asList(locations));
            if (jettyResource != null) {
                LOG.info("Found additional \"jetty.xml\" resource on the classpath: {}.", (Object)jettyResource);
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader jettyXmlCl = null;
            if (this.paxWebJettyBundle != null) {
                for (Bundle b : this.paxWebJettyBundle.getBundleContext().getBundles()) {
                    if (!"org.eclipse.jetty.xml".equals(b.getSymbolicName())) continue;
                    jettyXmlCl = ((BundleWiring)b.adapt(BundleWiring.class)).getClassLoader();
                    break;
                }
            }
            Thread.currentThread().setContextClassLoader(jettyXmlCl);
            URL emptyConfig = this.getClass().getResource("/jetty-empty.xml");
            if (emptyConfig != null) {
                new XmlConfiguration(Resource.newResource(emptyConfig));
            }
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                OsgiServletContextClassLoader cl = new OsgiServletContextClassLoader();
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                if (bundle != null) {
                    cl.addBundle(bundle);
                    for (Bundle b : bundle.getBundleContext().getBundles()) {
                        String sn = b.getSymbolicName();
                        if (!"org.eclipse.jetty.http".equals(sn) && !"org.eclipse.jetty.http2.hpack".equals(sn)) continue;
                        cl.addBundles(new Bundle[]{b});
                    }
                    Thread.currentThread().setContextClassLoader((ClassLoader)cl);
                }
                new PreEncodedHttpField("empty", "empty");
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            XmlConfiguration previous = null;
            LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
            objects.put("Server", this.server);
            objects.put("threadPool", this.server.getThreadPool());
            ArrayList<XmlConfiguration> configs = new ArrayList<XmlConfiguration>();
            for (File location : locations) {
                configs.add(new XmlConfiguration(Resource.newResource(location)));
            }
            if (jettyResource != null) {
                configs.add(new XmlConfiguration(Resource.newResource(jettyResource)));
            }
            for (XmlConfiguration cfg : configs) {
                LOG.debug("Parsing {}", (Object)cfg);
                this.processConfiguration(cfg, previous, objects);
                previous = cfg;
            }
            if (locations.length > 0 || jettyResource != null) {
                objects.values().forEach(bean -> {
                    if (Server.class.isAssignableFrom(bean.getClass()) && bean != this.server) {
                        String msg = "Can't create new instance of Jetty server in external configuration files.";
                        throw new IllegalArgumentException(msg);
                    }
                });
                Connector[] connectors = this.server.getConnectors();
                if (connectors != null && connectors.length > 0) {
                    for (Connector connector : connectors) {
                        String host = ((ServerConnector)connector).getHost();
                        if (host == null) {
                            host = "0.0.0.0";
                        }
                        int port = ((ServerConnector)connector).getPort();
                        LOG.info("Found configured connector \"{}\": {}:{}", new Object[]{connector.getName(), host, port});
                    }
                } else {
                    LOG.debug("No connectors configured in external Jetty configuration files.");
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    private void verifyConnectorConfiguration() {
        String[] addresses;
        boolean httpEnabled = this.configuration.server().isHttpEnabled();
        Integer httpPort = this.configuration.server().getHttpPort();
        boolean httpsEnabled = this.configuration.server().isHttpSecureEnabled();
        Integer httpsPort = this.configuration.server().getHttpSecurePort();
        for (String address : addresses = this.configuration.server().getListeningAddresses()) {
            this.verifyConnector(address, HttpConnectionFactory.class, httpPort, httpEnabled, false, () -> this.jettyFactory.createDefaultConnector(this.server, this.httpConfigs, address, this.configuration));
            this.verifyConnector(address, SslConnectionFactory.class, httpsPort, httpsEnabled, true, () -> this.jettyFactory.createSecureConnector(this.server, this.httpConfigs, address, this.configuration));
        }
    }

    private void verifyConnector(String address, Class<? extends ConnectionFactory> cfClass, Integer port, boolean enabled, boolean secure, Supplier<Connector> connectorProvider) {
        ServerConnector expectedConnector = null;
        boolean connectorFound = false;
        ServerConnector backupConnector = null;
        Connector[] currentConnectors = this.server.getConnectors();
        if (currentConnectors == null) {
            currentConnectors = new Connector[]{};
        }
        for (Connector connector : currentConnectors) {
            if (connector.getConnectionFactory(cfClass) == null) continue;
            if (this.match(address, port, connector)) {
                if (expectedConnector == null) {
                    expectedConnector = (ServerConnector)connector;
                }
                connectorFound = true;
                continue;
            }
            if (backupConnector != null) continue;
            backupConnector = (ServerConnector)connector;
        }
        if (expectedConnector == null && backupConnector != null) {
            expectedConnector = backupConnector;
        }
        if (connectorFound) {
            if (enabled) {
                LOG.info("Using configured {} as {} connector for address: {}:{}", new Object[]{expectedConnector, secure ? "secure" : "non secure", address, port});
            } else {
                for (Connector connector : currentConnectors) {
                    if (connector.getConnectionFactory(cfClass) == null) continue;
                    LOG.warn("Connector defined in external configuration will be removed, because it's not enabled: {}", (Object)connector);
                    this.server.removeConnector(connector);
                }
            }
        } else if (enabled) {
            LOG.info("Creating {} connector for address {}:{}", new Object[]{secure ? "secure" : "non secure", address, port});
            Connector connector = connectorProvider.get();
            this.server.addConnector(connector);
        }
    }

    private boolean match(String address1, Integer port1, Connector connector) {
        if (!(connector instanceof ServerConnector)) {
            LOG.warn(connector + " is not an instance of ServerConnector");
            return false;
        }
        ServerConnector sc = (ServerConnector)connector;
        String address2 = sc.getHost();
        int port2 = sc.getPort();
        InetSocketAddress isa1 = address1 != null ? new InetSocketAddress(address1, (int)port1) : new InetSocketAddress(port1);
        InetSocketAddress isa2 = address2 != null ? new InetSocketAddress(address2, port2) : new InetSocketAddress(port2);
        return isa1.equals(isa2);
    }

    public void configureRequestLog() {
        LogConfiguration lc = this.configuration.logging();
        if (lc.getLogNCSADirectory() == null) {
            throw new IllegalArgumentException("Log directory for NCSA logging is not specified. Please set org.ops4j.pax.web.log.ncsa.directory property.");
        }
        File logDir = new File(lc.getLogNCSADirectory());
        if (logDir.isFile()) {
            throw new IllegalArgumentException(logDir + " is not a valid directory to store request logs");
        }
        RequestLogWriter writer = new RequestLogWriter();
        writer.setAppend(lc.isLogNCSAAppend());
        if (lc.getLogNCSAFile() != null) {
            writer.setFilename(new File(lc.getLogNCSADirectory(), lc.getLogNCSAFile()).getAbsolutePath());
        } else {
            writer.setFilename(new File(lc.getLogNCSADirectory(), "yyyy_mm_dd.request.log").getAbsolutePath());
        }
        writer.setFilenameDateFormat(lc.getLogNCSAFilenameDateFormat());
        writer.setRetainDays(lc.getLogNCSARetainDays());
        writer.setTimeZone(lc.getLogNCSATimeZone());
        CustomRequestLog requestLog = new CustomRequestLog(writer, lc.isLogNCSAExtended() != false ? "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"" : "%{client}a - %u %t \"%r\" %s %O");
        this.server.setRequestLog(requestLog);
        LOG.info("NCSARequestlogging is using directory {}", (Object)lc.getLogNCSADirectory());
    }

    public void start() throws Exception {
        LOG.info("Starting {}", (Object)this.server);
        this.server.start();
    }

    public void stop() throws Exception {
        Handler[] childHandlers;
        LOG.info("Stopping {}", (Object)this.server);
        if (this.mbeanContainer != null) {
            LOG.info("Destroying Jetty JMX MBean container");
            this.server.removeBean(this.mbeanContainer);
            this.mbeanContainer.destroy();
            this.mbeanContainer = null;
        }
        this.server.stop();
        LOG.info("Stopping Jetty thread pool {}", (Object)this.qtp);
        this.qtp.stop();
        for (Handler handler : childHandlers = this.server.getChildHandlers()) {
            handler.stop();
        }
        LOG.info("Destroying Jetty server {}", (Object)this.server);
        this.server.destroy();
        this.dynamicRegistrations.clear();
        this.initializers.clear();
        this.osgiContextModels.clear();
        this.contextHandlers.forEach((path, sch) -> this.mainHandler.removeHandler((Handler)sch));
        this.contextHandlers.clear();
        this.mainHandler.mapContexts();
        this.osgiServletContexts.values().forEach(OsgiServletContext::unregister);
    }

    public ServerEvent.Address[] getAddresses(boolean useLocalPort) {
        if (this.server == null || this.server.getConnectors() == null || this.server.getConnectors().length == 0) {
            return new ServerEvent.Address[0];
        }
        ArrayList<ServerEvent.Address> result = new ArrayList<ServerEvent.Address>(this.server.getConnectors().length);
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof ServerConnector)) continue;
            ServerConnector sc = (ServerConnector)connector;
            int port = useLocalPort ? sc.getLocalPort() : sc.getPort();
            SslConnectionFactory cf = sc.getConnectionFactory(SslConnectionFactory.class);
            if (sc.getHost() == null) {
                result.add(new ServerEvent.Address(new InetSocketAddress(port), cf != null));
                continue;
            }
            result.add(new ServerEvent.Address(new InetSocketAddress(sc.getHost(), port), cf != null));
        }
        return result.toArray(new ServerEvent.Address[0]);
    }

    public void visitTransactionStateChange(TransactionStateChange change) {
        String contextPath = change.getContextPath();
        if (change.getKind() == OpCode.ASSOCIATE) {
            if (!this.transactions.add(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is already associated with config transaction");
            }
            this.delayedRemovals.computeIfAbsent(contextPath, cp -> new ArrayList());
        } else if (change.getKind() == OpCode.DISASSOCIATE) {
            PaxWebServletContextHandler sch;
            if (!this.transactions.remove(contextPath)) {
                throw new IllegalStateException("Context path " + contextPath + " is not associated with any config transaction");
            }
            List<ElementModel<?, ?>> toRemove = this.delayedRemovals.get(contextPath);
            if (toRemove != null) {
                Iterator<ElementModel<?, ?>> iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    ElementModel<?, ?> model = iterator.next();
                    if (model instanceof ServletModel) {
                        this.removeServletModel(contextPath, (ServletModel)model);
                    } else if (model instanceof EventListenerModel) {
                        this.removeEventListenerModel(this.contextHandlers.get(contextPath), (EventListenerModel)model);
                    }
                    iterator.remove();
                }
                this.delayedRemovals.remove(contextPath);
            }
            if (this.contextHandlers.containsKey(contextPath) && (sch = this.contextHandlers.get(contextPath)).getServer().isStarted()) {
                this.ensureServletContextStarted(sch);
            }
        }
    }

    public void visitServletContextModelChange(ServletContextModelChange change) {
        ServletContextModel model = change.getServletContextModel();
        String contextPath = model.getContextPath();
        if (change.getKind() == OpCode.ADD) {
            if (this.contextHandlers.containsKey(contextPath)) {
                return;
            }
            LOG.info("Creating new Jetty context for {}", (Object)model);
            PaxWebServletContextHandler sch = new PaxWebServletContextHandler(null, contextPath, this.configuration);
            sch.setServletHandler(new PaxWebServletHandler((Servlet)this.default404Servlet, new OsgiSessionAttributeListener(this.sessionListenerModels)));
            sch.setAllowNullPathInfo(false);
            sch.setWelcomeFiles(new String[0]);
            ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
            errorHandler.setShowStacks(this.configuration.server().isShowStacks());
            sch.setErrorHandler(errorHandler);
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.dirAllowed", "false");
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.etags", "true");
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.welcomeServlets", "true");
            Integer totalCacheSize = this.configuration.resources().maxTotalCacheSize();
            Integer maxEntrySize = this.configuration.resources().maxCacheEntrySize();
            Integer maxEntries = this.configuration.resources().maxCacheEntries();
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.maxCacheSize", totalCacheSize != null ? Integer.toString(totalCacheSize * 1024) : Integer.toString(0x400000));
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.maxCachedFileSize", maxEntrySize != null ? Integer.toString(maxEntrySize * 1024) : Integer.toString(0x200000));
            sch.setInitParameter("org.eclipse.jetty.servlet.Default.maxCachedFiles", maxEntries != null ? Integer.toString(maxEntries) : "2048");
            this.mainHandler.addHandler(sch);
            this.mainHandler.mapContexts();
            SessionHandler sessions = sch.getSessionHandler();
            if (sessions != null) {
                SessionIdManager sidManager;
                SessionConfiguration sc = this.configuration.session();
                sessions.setMaxInactiveInterval(sc.getSessionTimeout());
                sessions.setSessionCookie(this.defaultSessionCookieConfig.getName());
                sessions.getSessionCookieConfig().setDomain(this.defaultSessionCookieConfig.getDomain());
                sessions.getSessionCookieConfig().setPath(this.defaultSessionCookieConfig.getPath());
                sessions.getSessionCookieConfig().setMaxAge(this.defaultSessionCookieConfig.getMaxAge());
                sessions.getSessionCookieConfig().setHttpOnly(this.defaultSessionCookieConfig.isHttpOnly());
                sessions.getSessionCookieConfig().setSecure(this.defaultSessionCookieConfig.isSecure());
                sessions.getSessionCookieConfig().setComment(this.defaultSessionCookieConfig.getComment());
                String sameSiteValue = sc.getSessionCookieSameSite();
                if (sameSiteValue != null && !"unset".equalsIgnoreCase(sameSiteValue)) {
                    if ("none".equalsIgnoreCase(sameSiteValue)) {
                        sessions.setSameSite(HttpCookie.SameSite.NONE);
                    } else if ("lax".equalsIgnoreCase(sameSiteValue)) {
                        sessions.setSameSite(HttpCookie.SameSite.LAX);
                    } else if ("strict".equalsIgnoreCase(sameSiteValue)) {
                        sessions.setSameSite(HttpCookie.SameSite.STRICT);
                    }
                }
                if (sc.getSessionUrlPathParameter() != null) {
                    sessions.setSessionIdPathParameterName(sc.getSessionUrlPathParameter());
                }
                if (sc.getSessionWorkerName() != null && (sidManager = this.server.getSessionIdManager()) instanceof DefaultSessionIdManager) {
                    ((DefaultSessionIdManager)sidManager).setWorkerName(sc.getSessionWorkerName());
                }
            }
            this.contextHandlers.put(contextPath, sch);
            this.osgiContextModels.put(contextPath, new TreeSet());
            this.initializers.put(contextPath, new LinkedHashMap());
            this.dynamicRegistrations.put(contextPath, new DynamicRegistrations());
        } else if (change.getKind() == OpCode.DELETE) {
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (highestRankedModel != null) {
                return;
            }
            this.dynamicRegistrations.remove(contextPath);
            this.initializers.remove(contextPath);
            this.osgiContextModels.remove(contextPath);
            PaxWebServletContextHandler sch = this.contextHandlers.remove(contextPath);
            if (sch != null) {
                if (sch.isStarted()) {
                    LOG.info("Stopping Jetty context \"{}\"", (Object)contextPath);
                    try {
                        sch.stop();
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                    }
                }
                this.mainHandler.removeHandler(sch);
                this.mainHandler.mapContexts();
            }
        }
    }

    public void visitOsgiContextModelChange(OsgiContextModelChange change) {
        OsgiContextModel highestRankedModel;
        if (change.getKind() == OpCode.ASSOCIATE || change.getKind() == OpCode.DISASSOCIATE) {
            return;
        }
        OsgiContextModel osgiModel = change.getOsgiContextModel();
        ServletContextModel servletContextModel = change.getServletContextModel();
        String contextPath = osgiModel.getContextPath();
        PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
        if (sch == null) {
            if (change.getKind() == OpCode.DELETE) {
                return;
            }
            this.visitServletContextModelChange(new ServletContextModelChange(OpCode.ADD, new ServletContextModel(contextPath)));
            sch = this.contextHandlers.get(contextPath);
        }
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding {} to {}", (Object)osgiModel, (Object)sch);
            if (this.osgiServletContexts.containsKey(osgiModel)) {
                throw new IllegalStateException(osgiModel + " is already registered");
            }
            Object classLoader = null;
            if (osgiModel.getClassLoader() != null) {
                classLoader = osgiModel.getClassLoader();
            }
            if (this.paxWebJettyBundle != null) {
                OsgiServletContextClassLoader loader = classLoader != null ? classLoader : new OsgiServletContextClassLoader();
                loader.addBundle(osgiModel.getOwnerBundle());
                loader.addBundle(this.paxWebJettyBundle);
                loader.addBundle(Utils.getPaxWebJspBundle((Bundle)this.paxWebJettyBundle));
                loader.addBundles(new Bundle[]{Utils.getJettyWebSocketBundle((Bundle)this.paxWebJettyBundle)});
                loader.makeImmutable();
                classLoader = loader;
            } else if (classLoader == null) {
                classLoader = this.classLoader;
            }
            OsgiServletContext osgiContext = new OsgiServletContext((ServletContext)sch.getServletContext(), osgiModel, servletContextModel, this.defaultSessionCookieConfig, (ClassLoader)classLoader);
            File tmpLocation = new File(this.configuration.server().getTemporaryDirectory(), osgiModel.getTemporaryLocation());
            if (!tmpLocation.exists() && !tmpLocation.mkdirs()) {
                LOG.warn("Can't create temporary directory for {}: {}", (Object)osgiModel, (Object)tmpLocation.getAbsolutePath());
            }
            osgiModel.getInitialContextAttributes().put("javax.servlet.context.tempdir", tmpLocation);
            osgiContext.setAttribute("javax.servlet.context.tempdir", (Object)tmpLocation);
            this.osgiServletContexts.put(osgiModel, osgiContext);
            this.osgiContextModels.get(contextPath).add(osgiModel);
        }
        boolean hasStopped = false;
        if (change.getKind() == OpCode.DELETE) {
            OsgiServletContext currentHighestRankedContext;
            LOG.info("Removing {} from {}", (Object)osgiModel, (Object)sch);
            OsgiServletContext removedOsgiServletContext = this.osgiServletContexts.remove(osgiModel);
            TreeSet<OsgiContextModel> models = this.osgiContextModels.get(contextPath);
            if (models != null) {
                models.remove(osgiModel);
            }
            if (removedOsgiServletContext != null) {
                removedOsgiServletContext.unregister();
                removedOsgiServletContext.releaseWebContainerContext();
            }
            if ((currentHighestRankedContext = ((PaxWebServletHandler)sch.getServletHandler()).getDefaultServletContext()) == removedOsgiServletContext || this.pendingTransaction(contextPath)) {
                if (sch.isStarted()) {
                    LOG.info("Stopping Jetty context \"{}\"", (Object)contextPath);
                    try {
                        sch.stop();
                        hasStopped = true;
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                    }
                }
                ((PaxWebServletHandler)sch.getServletHandler()).setDefaultOsgiContextModel(null, null);
                ((PaxWebServletHandler)sch.getServletHandler()).setDefaultServletContext(null);
            }
        }
        if ((highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath))) != null) {
            if (highestRankedModel != ((PaxWebServletHandler)sch.getServletHandler()).getDefaultOsgiContextModel()) {
                LOG.info("Changing default OSGi context model for " + sch);
                OsgiServletContext highestRankedContext = this.osgiServletContexts.get(highestRankedModel);
                ((PaxWebServletHandler)sch.getServletHandler()).setDefaultOsgiContextModel(highestRankedModel, highestRankedContext.getResolvedWebContainerContext());
                ((PaxWebServletHandler)sch.getServletHandler()).setDefaultServletContext(highestRankedContext);
                this.osgiServletContexts.forEach((ocm, osc) -> {
                    if (ocm.getContextPath().equals(contextPath) && osc != highestRankedContext) {
                        osc.unregister();
                    }
                });
                if (!hasStopped && sch.isStarted()) {
                    LOG.info("Stopping Jetty context \"{}\"", (Object)contextPath);
                    try {
                        sch.stop();
                        hasStopped = true;
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
                    }
                }
            }
            if (hasStopped) {
                if (this.pendingTransaction(contextPath)) {
                    change.registerBatchCompletedAction((Change)new ContextStartChange(OpCode.MODIFY, contextPath));
                } else {
                    this.ensureServletContextStarted(sch);
                }
            }
        } else {
            ((PaxWebServletHandler)sch.getServletHandler()).setDefaultOsgiContextModel(null, null);
            ((PaxWebServletHandler)sch.getServletHandler()).setDefaultServletContext(null);
            this.visitServletContextModelChange(new ServletContextModelChange(OpCode.DELETE, new ServletContextModel(contextPath)));
        }
    }

    public void visitContextMetadataModelChange(ContextMetadataModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            OsgiContextModel ocm = change.getOsgiContextModel();
            ContextMetadataModel meta = change.getMetadata();
            String contextPath = ocm.getContextPath();
            ServletContextHandler sch = this.contextHandlers.get(contextPath);
            if (sch == null) {
                throw new IllegalStateException(ocm + " refers to unknown ServletContext for path " + contextPath);
            }
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (ocm == highestRankedModel) {
                LOG.info("Configuring metadata of {}", (Object)ocm);
                sch.getServletContext().setEffectiveMajorVersion(meta.getMajorVersion());
                sch.getServletContext().setEffectiveMinorVersion(meta.getMinorVersion());
                sch.setDisplayName(meta.getDisplayName());
                if (sch.getSecurityHandler() instanceof ConstraintAware) {
                    ((ConstraintAware)((Object)sch.getSecurityHandler())).setDenyUncoveredHttpMethods(meta.isDenyUncoveredHttpMethods());
                }
            }
        }
    }

    public void visitMimeAndLocaleMappingChange(MimeAndLocaleMappingChange change) {
        if (change.getKind() == OpCode.ADD) {
            OsgiContextModel ocm = change.getOsgiContextModel();
            String contextPath = ocm.getContextPath();
            ServletContextHandler sch = this.contextHandlers.get(contextPath);
            if (sch == null) {
                throw new IllegalStateException(ocm + " refers to unknown ServletContext for path " + contextPath);
            }
            OsgiContextModel highestRankedModel = Utils.getHighestRankedModel((Set)this.osgiContextModels.get(contextPath));
            if (ocm == highestRankedModel) {
                LOG.info("Configuring MIME and Locale Encoding mapping of {}", (Object)ocm);
                MimeTypes mimeTypes = new MimeTypes();
                mimeTypes.setMimeMap(change.getMimeMapping());
                sch.setMimeTypes(mimeTypes);
                change.getLocaleEncodingMapping().forEach(sch::addLocaleEncoding);
            }
        }
    }

    public void visitServletModelChange(ServletModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            ServletModel model = change.getServletModel();
            if (change.getNewModelsInfo() == null) {
                LOG.info("Adding servlet {}", (Object)model);
            } else {
                LOG.info("Adding servlet {} to new contexts {}", (Object)model, (Object)change.getNewModelsInfo());
            }
            change.getContextModels().forEach(osgiContextModel -> {
                String contextPath = osgiContextModel.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                LOG.debug("Adding servlet {} to {}", (Object)model.getName(), (Object)contextPath);
                PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
                OsgiServletContext context = this.osgiServletContexts.get(osgiContextModel);
                PaxWebServletHolder holder = new PaxWebServletHolder(model, (OsgiContextModel)osgiContextModel, context);
                holder.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                ServletMapping mapping = new ServletMapping();
                mapping.setServletName(model.getName());
                mapping.setPathSpecs(model.getUrlPatterns());
                mapping.setDefault(model.isOverridable());
                boolean isDefaultResourceServlet = model.isResourceServlet();
                for (String pattern : model.getUrlPatterns()) {
                    isDefaultResourceServlet &= "/".equals(pattern);
                }
                if (model.isResourceServlet()) {
                    holder.setInitParameter("pathInfoOnly", Boolean.toString(!isDefaultResourceServlet));
                }
                ServletHandler sh = sch.getServletHandler();
                if (isDefaultResourceServlet && "default".equals(model.getName())) {
                    PaxWebServletHolder defaultHolder = (PaxWebServletHolder)sh.getServlet(model.getName());
                    ServletMapping defaultMapping = sh.getServletMapping("/");
                    if (defaultHolder != null) {
                        sh.setServlets(ArrayUtil.removeFromArray(sh.getServlets(), defaultHolder));
                        sh.setServletMappings(ArrayUtil.removeFromArray(sh.getServletMappings(), defaultMapping));
                    }
                }
                model.getRoleLinks().forEach(holder::setUserRoleLink);
                holder.setRunAsRole(model.getRunAs());
                ((PaxWebServletHandler)sh).addServletWithMapping(holder, mapping);
                ErrorPageModel epm = model.getErrorPageModel();
                if (epm != null && epm.isValid()) {
                    String location = epm.getLocation();
                    ErrorPageErrorHandler eph = (ErrorPageErrorHandler)sch.getErrorHandler();
                    this.configureErrorPages(location, eph, epm);
                }
                if (!change.isDynamic()) {
                    this.ensureServletContextStarted(sch);
                } else if (model.isServletSecurityPresent() && sch.getSecurityHandler() != null) {
                    ArrayList<SecurityConstraintModel> dynamicModels = new ArrayList<SecurityConstraintModel>();
                    model.getContextModels().forEach(ocm -> {
                        for (SecurityConstraintModel sc : ocm.getSecurityConfiguration().getSecurityConstraints()) {
                            if (sc.getServletModel() != model) continue;
                            dynamicModels.add(sc);
                        }
                    });
                    this.ensureSecurityConstraintsConfigured((ConstraintSecurityHandler)sch.getSecurityHandler(), dynamicModels);
                }
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getServletModels().entrySet()) {
                ServletModel model = (ServletModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of servlet {}", (Object)model);
                        this.delayedRemovals.get(contextPath).add((ElementModel<?, ?>)model);
                        return;
                    }
                    this.removeServletModel(contextPath, model);
                });
            }
        }
    }

    private void removeServletModel(String contextPath, ServletModel model) {
        ServletContextHandler sch = this.contextHandlers.get(contextPath);
        if (sch == null) {
            return;
        }
        ((PaxWebServletHandler)sch.getServletHandler()).removeServletWithMapping(model);
        LOG.info("Removing servlet {}", (Object)model);
        LOG.debug("Removing servlet {} from context {}", (Object)model.getName(), (Object)contextPath);
        ErrorPageModel epm = model.getErrorPageModel();
        if (epm != null) {
            String location = epm.getLocation();
            ErrorPageErrorHandler eph = (ErrorPageErrorHandler)sch.getErrorHandler();
            Map<String, String> existing = eph.getErrorPages();
            for (String string : epm.getExceptionClassNames()) {
                existing.entrySet().removeIf(e -> ((String)e.getKey()).equals(ex) && ((String)e.getValue()).equals(location));
            }
            Iterator<Object> iterator = epm.getErrorCodes().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                existing.entrySet().removeIf(e -> ((String)e.getKey()).equals(Integer.toString(code)) && ((String)e.getValue()).equals(location));
            }
            if (epm.isXx4() || epm.isXx5()) {
                eph = new ErrorPageErrorHandler();
                sch.setErrorHandler(eph);
                if (epm.isXx4()) {
                    existing.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("4") && ((String)e.getKey()).length() == 3 && ((String)e.getValue()).equals(location));
                }
                if (epm.isXx5()) {
                    existing.entrySet().removeIf(e -> ((String)e.getKey()).startsWith("5") && ((String)e.getKey()).length() == 3 && ((String)e.getValue()).equals(location));
                }
            }
            for (Map.Entry entry : existing.entrySet()) {
                eph.addErrorPage((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void visitFilterModelChange(FilterModelChange change) {
        FilterModel model = change.getFilterModel();
        HashSet<String> done = new HashSet<String>();
        if (change.getKind() == OpCode.ADD && model.isDynamic()) {
            for (OsgiContextModel ocm : change.getContextModels()) {
                String contextPath = ocm.getContextPath();
                if (!done.add(contextPath)) continue;
                LOG.info("Adding dynamic filter {} to context {}", (Object)model, (Object)contextPath);
                OsgiContextModel highestRankedModel = null;
                for (OsgiContextModel cm : model.getContextModels()) {
                    if (!cm.getContextPath().equals(contextPath)) continue;
                    highestRankedModel = cm;
                    break;
                }
                if (highestRankedModel == null) {
                    highestRankedModel = ocm;
                }
                PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
                OsgiServletContext context = this.osgiServletContexts.get(highestRankedModel);
                ServletHandler servletHandler = sch.getServletHandler();
                List<PaxWebFilterMapping> mapping = this.configureFilterMappings(model);
                PaxWebFilterHolder holder = new PaxWebFilterHolder(model, context);
                holder.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                holder.setMapping(mapping);
                for (PaxWebFilterMapping m : mapping) {
                    servletHandler.addFilter(holder);
                    if (m.isAfter()) {
                        servletHandler.addFilterMapping(m);
                        continue;
                    }
                    servletHandler.prependFilterMapping(m);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitFilterStateChange(FilterStateChange change) {
        if (change.isDynamic()) {
            return;
        }
        Map contextFilters = change.getContextFilters();
        for (Map.Entry entry : contextFilters.entrySet()) {
            String contextPath = (String)entry.getKey();
            Map filtersMap = (Map)entry.getValue();
            TreeSet filters = new TreeSet(filtersMap.keySet());
            PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
            if (sch == null) continue;
            LOG.info("Changing filter configuration for context {}", (Object)contextPath);
            OsgiContextModel defaultHighestRankedModel = this.osgiContextModels.get(contextPath).iterator().next();
            HashSet<PreprocessorFilterConfig> toDestroy = new HashSet<PreprocessorFilterConfig>(((PaxWebServletHandler)sch.getServletHandler()).getPreprocessors());
            LinkedList<PreprocessorFilterConfig> toInit = new LinkedList<PreprocessorFilterConfig>();
            ((PaxWebServletHandler)sch.getServletHandler()).getPreprocessors().clear();
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                FilterModel model = (FilterModel)iterator.next();
                if (!model.isPreprocessor()) continue;
                PreprocessorFilterConfig filterConfig = new PreprocessorFilterConfig(model, this.osgiServletContexts.get(defaultHighestRankedModel));
                if (toDestroy.stream().noneMatch(pfc -> pfc.getModel().equals((Object)model))) {
                    toInit.add(filterConfig);
                } else {
                    toDestroy.removeIf(pfc -> {
                        boolean match = pfc.getModel().equals((Object)model);
                        if (match) {
                            filterConfig.copyFrom(pfc);
                        }
                        return match;
                    });
                }
                ((PaxWebServletHandler)sch.getServletHandler()).getPreprocessors().add(filterConfig);
                iterator.remove();
            }
            if (sch.isStarted()) {
                for (PreprocessorFilterConfig fc : toInit) {
                    try {
                        fc.getInstance().init((FilterConfig)fc);
                        fc.setInitCalled(true);
                    }
                    catch (ServletException ex) {
                        LOG.warn("Problem during preprocessor initialization: {}", (Object)ex.getMessage(), (Object)ex);
                    }
                }
                for (PreprocessorFilterConfig fc : toDestroy) {
                    fc.destroy();
                    fc.setInitCalled(false);
                }
            }
            FilterHolder[] newFilterHolders = new PaxWebFilterHolder[filters.size()];
            int pos = 0;
            boolean noQuick = false;
            for (FilterModel model : filters) {
                noQuick |= filtersMap.get(model) != null;
                OsgiContextModel highestRankedModel = null;
                List contextModels = filtersMap.get(model) != null ? (List)filtersMap.get(model) : model.getContextModels();
                for (OsgiContextModel osgiContextModel : contextModels) {
                    if (!osgiContextModel.getContextPath().equals(contextPath)) continue;
                    highestRankedModel = osgiContextModel;
                    break;
                }
                if (highestRankedModel == null) {
                    LOG.warn("(dev) Can't find proper OsgiContextModel for the filter. Falling back to highest ranked OsgiContextModel for given ServletContextModel");
                    highestRankedModel = defaultHighestRankedModel;
                }
                OsgiServletContext context = this.osgiServletContexts.get(highestRankedModel);
                PaxWebFilterHolder paxWebFilterHolder = new PaxWebFilterHolder(model, context);
                paxWebFilterHolder.setWhiteboardTCCL("whiteboard".equalsIgnoreCase(this.configuration.server().getTCCLType()));
                paxWebFilterHolder.setMapping(this.configureFilterMappings(model));
                newFilterHolders[pos] = paxWebFilterHolder;
                ++pos;
            }
            LinkedList<PaxWebFilterMapping> newFilterMappingsListBefore = new LinkedList<PaxWebFilterMapping>();
            LinkedList<PaxWebFilterMapping> newFilterMappingsListAfter = new LinkedList<PaxWebFilterMapping>();
            if (!change.isDynamic() && sch.getServletHandler().getFilters().length > 0) {
                void var20_30;
                ArrayList newFiltersList = new ArrayList();
                FilterHolder[] filterHolderArray = sch.getServletHandler().getFilters();
                int n = filterHolderArray.length;
                boolean bl = false;
                while (var20_30 < n) {
                    PaxWebFilterHolder pwfh;
                    FilterHolder fh = filterHolderArray[var20_30];
                    if (fh instanceof PaxWebFilterHolder && ((pwfh = (PaxWebFilterHolder)fh).getFilterModel() == null || pwfh.getFilterModel().isDynamic())) {
                        newFiltersList.add(pwfh);
                        if (pwfh.getMapping() != null) {
                            for (PaxWebFilterMapping pwfm : pwfh.getMapping()) {
                                if (pwfm.isAfter()) {
                                    newFilterMappingsListAfter.add(pwfm);
                                    continue;
                                }
                                newFilterMappingsListBefore.add(pwfm);
                            }
                        }
                    }
                    ++var20_30;
                }
                Collections.addAll(newFiltersList, newFilterHolders);
                newFilterHolders = newFiltersList.toArray(new PaxWebFilterHolder[0]);
            }
            if (noQuick || !this.quickFilterChange(sch.getServletHandler(), (PaxWebFilterHolder[])newFilterHolders)) {
                for (FilterHolder filterHolder : sch.getServletHandler().getFilters()) {
                    try {
                        filterHolder.stop();
                    }
                    catch (Exception e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    Field maiField = ServletHandler.class.getDeclaredField("_matchAfterIndex");
                    maiField.setAccessible(true);
                    maiField.set(sch.getServletHandler(), -1);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
                sch.getServletHandler().setFilters(new FilterHolder[0]);
                sch.getServletHandler().setFilterMappings(new FilterMapping[0]);
                for (PaxWebFilterHolder paxWebFilterHolder : newFilterHolders) {
                    if ("Jetty_WebSocketUpgradeFilter".equals(paxWebFilterHolder.getName())) {
                        sch.getServletContext().removeAttribute("org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter");
                    }
                    sch.getServletHandler().addFilter(paxWebFilterHolder);
                    if (paxWebFilterHolder.getMapping() == null) continue;
                    for (PaxWebFilterMapping fm : paxWebFilterHolder.getMapping()) {
                        if (fm.isAfter()) {
                            newFilterMappingsListAfter.add(fm);
                            continue;
                        }
                        newFilterMappingsListBefore.add(fm);
                    }
                }
                newFilterMappingsListBefore.addAll(newFilterMappingsListAfter);
                sch.getServletHandler().setFilters(newFilterHolders);
                sch.getServletHandler().setFilterMappings(newFilterMappingsListBefore.toArray(new PaxWebFilterMapping[0]));
            }
            if (change.isDynamic()) continue;
            this.ensureServletContextStarted(sch);
        }
    }

    public void visitEventListenerModelChange(EventListenerModelChange change) {
        HashSet done = new HashSet();
        if (change.getKind() == OpCode.ADD) {
            EventListenerModel eventListenerModel = change.getEventListenerModel();
            List contextModels = change.getContextModels();
            contextModels.forEach(context -> {
                String contextPath = context.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                PaxWebServletContextHandler servletContextHandler = this.contextHandlers.get(contextPath);
                EventListener eventListener = eventListenerModel.resolveEventListener();
                if (eventListener instanceof ServletContextAttributeListener) {
                    OsgiServletContext c = this.osgiServletContexts.get(context);
                    c.addServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                }
                if (eventListener instanceof HttpSessionAttributeListener) {
                    this.sessionListenerModels.add(eventListenerModel);
                }
                boolean stopped = false;
                if (servletContextHandler.isStarted() && ServletContextListener.class.isAssignableFrom(eventListener.getClass())) {
                    try {
                        LOG.info("Stopping Jetty context \"{}\" before registering a ServletContextListener", (Object)contextPath);
                        servletContextHandler.stop();
                        stopped = true;
                    }
                    catch (Exception e) {
                        LOG.warn("Problem stopping {}: {}", (Object)servletContextHandler, (Object)e.getMessage());
                    }
                }
                servletContextHandler.addEventListener(eventListenerModel, eventListener);
                if (stopped) {
                    LOG.info("Scheduling start of the {} context after listener registration for already started context", (Object)contextPath);
                    change.registerBatchCompletedAction((Change)new ContextStartChange(OpCode.MODIFY, contextPath));
                }
            });
        }
        if (change.getKind() == OpCode.DELETE) {
            List eventListenerModels = change.getEventListenerModels();
            for (EventListenerModel eventListenerModel : eventListenerModels) {
                List contextModels = eventListenerModel.getContextModels();
                contextModels.forEach(context -> {
                    OsgiServletContext c;
                    String contextPath = context.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    PaxWebServletContextHandler servletContextHandler = this.contextHandlers.get(contextPath);
                    EventListener eventListener = eventListenerModel.resolveEventListener();
                    if (eventListener instanceof ServletContextAttributeListener && (c = this.osgiServletContexts.get(context)) != null) {
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)eventListener);
                    }
                    if (eventListener instanceof HttpSessionAttributeListener) {
                        this.sessionListenerModels.remove(eventListenerModel);
                    }
                    if (this.pendingTransaction(contextPath)) {
                        LOG.debug("Delaying removal of event listener {}", (Object)eventListenerModel);
                        return;
                    }
                    this.removeEventListenerModel(servletContextHandler, eventListenerModel);
                });
            }
        }
    }

    private void removeEventListenerModel(PaxWebServletContextHandler servletContextHandler, EventListenerModel eventListenerModel) {
        if (servletContextHandler != null) {
            LOG.info("Removing event listener {}", (Object)eventListenerModel);
            servletContextHandler.removeEventListener(eventListenerModel, eventListenerModel.resolveEventListener());
            eventListenerModel.releaseEventListener();
        }
    }

    public void visitWelcomeFileModelChange(WelcomeFileModelChange change) {
        WelcomeFileModel model = change.getWelcomeFileModel();
        OpCode op = change.getKind();
        if (op == OpCode.ADD || op == OpCode.DELETE) {
            List contextModels = op == OpCode.ADD ? change.getContextModels() : model.getContextModels();
            contextModels.forEach(context -> {
                LinkedHashSet<String> currentWelcomeFiles;
                OsgiServletContext osgiServletContext = this.osgiServletContexts.get(context);
                ServletContextHandler servletContextHandler = this.contextHandlers.get(context.getContextPath());
                if (osgiServletContext == null) {
                    return;
                }
                LinkedHashSet<String> linkedHashSet = currentWelcomeFiles = osgiServletContext.getWelcomeFiles() == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(Arrays.asList(osgiServletContext.getWelcomeFiles()));
                if (op == OpCode.ADD) {
                    currentWelcomeFiles.addAll(Arrays.asList(model.getWelcomeFiles()));
                } else if (model.getWelcomeFiles().length == 0) {
                    currentWelcomeFiles.clear();
                } else {
                    for (String s : model.getWelcomeFiles()) {
                        currentWelcomeFiles.remove(s);
                    }
                }
                String[] newWelcomeFiles = currentWelcomeFiles.toArray(new String[0]);
                osgiServletContext.setWelcomeFiles(newWelcomeFiles);
                osgiServletContext.setWelcomeFilesRedirect(model.isRedirect());
                LOG.info("Reconfiguration of welcome files for all resource servlets in context \"{}\"", context);
                if (servletContextHandler != null && servletContextHandler.getServletHandler() != null && servletContextHandler.getServletHandler().getServlets() != null) {
                    for (ServletHolder sh : servletContextHandler.getServletHandler().getServlets()) {
                        PaxWebServletHolder pwsh = (PaxWebServletHolder)sh;
                        if (pwsh.getServletModel() == null || !pwsh.getServletModel().isResourceServlet() || context != pwsh.getOsgiContextModel()) continue;
                        try {
                            Servlet servlet = sh.getServlet();
                            if (servlet instanceof ServletHolder.Wrapper) {
                                servlet = ((ServletHolder.Wrapper)servlet).getWrapped();
                            }
                            if (servlet instanceof JettyResourceServlet) {
                                ((JettyResourceServlet)servlet).setWelcomeFiles(newWelcomeFiles);
                                ((JettyResourceServlet)servlet).setWelcomeFilesRedirect(model.isRedirect());
                                continue;
                            }
                            if (!(servlet instanceof OsgiInitializedServlet)) continue;
                            ((JettyResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFiles(newWelcomeFiles);
                            ((JettyResourceServlet)((OsgiInitializedServlet)servlet).getDelegate()).setWelcomeFilesRedirect(model.isRedirect());
                        }
                        catch (Exception e) {
                            LOG.warn("Problem reconfiguring welcome files in servlet {}", (Object)sh, (Object)e);
                        }
                    }
                }
            });
        }
    }

    public void visitErrorPageModelChange(ErrorPageModelChange change) {
    }

    public void visitErrorPageStateChange(ErrorPageStateChange change) {
        Map contextErrorPages = change.getContextErrorPages();
        for (Map.Entry entry : contextErrorPages.entrySet()) {
            String contextPath = (String)entry.getKey();
            TreeMap errorPageModelsMap = (TreeMap)entry.getValue();
            Set errorPageModels = errorPageModelsMap.keySet();
            LOG.info("Changing error page configuration for context {}", (Object)contextPath);
            ServletContextHandler sch = this.contextHandlers.get(contextPath);
            if (sch == null) {
                return;
            }
            ErrorPageErrorHandler eph = (ErrorPageErrorHandler)sch.getErrorHandler();
            eph.getErrorPages().clear();
            for (ErrorPageModel model : errorPageModels) {
                String location = model.getLocation();
                this.configureErrorPages(location, eph, model);
            }
        }
    }

    public void visitContainerInitializerModelChange(ContainerInitializerModelChange change) {
        if (change.getKind() == OpCode.ADD) {
            ContainerInitializerModel model = change.getContainerInitializerModel();
            if (!model.isForAnyRuntime() && !model.isForJetty()) {
                return;
            }
            List contextModels = change.getContextModels();
            contextModels.forEach(context -> {
                String path = context.getContextPath();
                ServletContextHandler sch = this.contextHandlers.get(context.getContextPath());
                if (sch.isStarted()) {
                    LOG.info("Stopping Jetty context \"{}\" before registering a ServletContextInitializer", (Object)path);
                    try {
                        sch.stop();
                    }
                    catch (Exception e) {
                        LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{path, e.getMessage(), e});
                    }
                }
                DynamicRegistrations registrations = this.dynamicRegistrations.get(path);
                OsgiDynamicServletContext dynamicContext = new OsgiDynamicServletContext(this.osgiServletContexts.get(context), registrations);
                SCIWrapper wrapper = new SCIWrapper(dynamicContext, model);
                this.initializers.get(path).put(System.identityHashCode(model.getContainerInitializer()), wrapper);
            });
        }
        if (change.getKind() == OpCode.DELETE) {
            List models = change.getContainerInitializerModels();
            for (ContainerInitializerModel model : models) {
                if (!model.isForAnyRuntime() && !model.isForJetty()) continue;
                List contextModels = model.getContextModels();
                contextModels.forEach(context -> {
                    String path = context.getContextPath();
                    ServletContainerInitializer initializer = model.getContainerInitializer();
                    LinkedHashMap<Integer, SCIWrapper> wrappers = this.initializers.get(path);
                    if (wrappers != null) {
                        wrappers.remove(System.identityHashCode(initializer));
                    }
                });
            }
        }
    }

    public void visitWebSocketModelChange(WebSocketModelChange change) {
        if (change.getKind() == OpCode.ADD && !change.isDisabled() || change.getKind() == OpCode.ENABLE) {
            WebSocketModel model = change.getWebSocketModel();
            HashSet done = new HashSet();
            change.getContextModels().forEach(osgiContextModel -> {
                String contextPath = osgiContextModel.getContextPath();
                if (!done.add(contextPath)) {
                    return;
                }
                LOG.info("Adding web socket {} to {}", (Object)model, (Object)contextPath);
                this.ensureServletContextStarted(this.contextHandlers.get(contextPath));
            });
            return;
        }
        if (change.getKind() == OpCode.DISABLE || change.getKind() == OpCode.DELETE) {
            for (Map.Entry entry : change.getWebSocketModels().entrySet()) {
                WebSocketModel model = (WebSocketModel)entry.getKey();
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                HashSet done = new HashSet();
                model.getContextModels().forEach(osgiContextModel -> {
                    String contextPath = osgiContextModel.getContextPath();
                    if (!done.add(contextPath)) {
                        return;
                    }
                    LOG.info("Removing web socket {} from context {}", (Object)model, (Object)contextPath);
                    this.ensureServletContextStarted(this.contextHandlers.get(contextPath));
                });
            }
        }
    }

    public void visitClearDynamicRegistrationsChange(ClearDynamicRegistrationsChange change) {
        HashSet done = new HashSet();
        change.getContextModels().forEach(context -> {
            String contextPath = context.getContextPath();
            if (!done.add(contextPath)) {
                return;
            }
            this.clearDynamicRegistrations(contextPath, (OsgiContextModel)context);
        });
    }

    private void clearDynamicRegistrations(String contextPath, OsgiContextModel context) {
        DynamicRegistrations contextRegistrations;
        PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
        if (sch == null) {
            return;
        }
        if (sch.isStarted()) {
            LOG.info("Stopping Jetty context \"{}\"", (Object)contextPath);
            try {
                sch.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
            }
        }
        int[] removed = new int[]{0};
        ServletHolder[] allServlets = sch.getServletHandler().getServlets();
        HashMap<ServletModel, Boolean> toRemove = new HashMap<ServletModel, Boolean>();
        for (ServletHolder sh : allServlets) {
            ServletModel model2;
            if (!(sh instanceof PaxWebServletHolder) || (model2 = ((PaxWebServletHolder)sh).getServletModel()) == null || !model2.isDynamic()) continue;
            toRemove.put(model2, Boolean.TRUE);
            removed[0] = removed[0] + 1;
        }
        if (!toRemove.isEmpty()) {
            this.visitServletModelChange(new ServletModelChange(OpCode.DELETE, toRemove));
        }
        FilterHolder[] allFilters = sch.getServletHandler().getFilters();
        ArrayList<FilterHolder> filtersToRemove = new ArrayList<FilterHolder>();
        for (FilterHolder fh : allFilters) {
            FilterModel model3;
            if (!(fh instanceof PaxWebFilterHolder) || (model3 = ((PaxWebFilterHolder)fh).getFilterModel()) != null && !model3.isDynamic()) continue;
            filtersToRemove.add(fh);
            removed[0] = removed[0] + 1;
        }
        if (!filtersToRemove.isEmpty()) {
            ArrayList<PaxWebFilterHolder> newFilters = new ArrayList<PaxWebFilterHolder>();
            ArrayList<PaxWebFilterMapping> newFilterMappings = new ArrayList<PaxWebFilterMapping>();
            for (FilterHolder fh : allFilters) {
                if (!(fh instanceof PaxWebFilterHolder) || filtersToRemove.contains(fh)) continue;
                PaxWebFilterHolder pwfh = (PaxWebFilterHolder)fh;
                newFilters.add(pwfh);
                newFilterMappings.addAll(pwfh.getMapping());
            }
            sch.getServletHandler().setFilters(newFilters.toArray(new PaxWebFilterHolder[0]));
            sch.getServletHandler().setFilterMappings(newFilterMappings.toArray(new PaxWebFilterMapping[0]));
        }
        if ((contextRegistrations = this.dynamicRegistrations.get(contextPath)) != null) {
            contextRegistrations.getDynamicListenerModels().forEach((l, model) -> {
                if (model.isDynamic()) {
                    OsgiServletContext c;
                    removed[0] = removed[0] + 1;
                    if (l instanceof ServletContextAttributeListener && (c = this.osgiServletContexts.get(context)) != null) {
                        c.removeServletContextAttributeListener((ServletContextAttributeListener)l);
                    }
                    sch.removeEventListener((EventListener)l);
                }
            });
            contextRegistrations.getDynamicListenerModels().clear();
            contextRegistrations.getDynamicServletRegistrations().clear();
            contextRegistrations.getDynamicFilterRegistrations().clear();
            contextRegistrations.getDynamicListenerRegistrations().clear();
        }
        if (removed[0] > 0) {
            LOG.debug("Removed {} dynamically registered servlets/filters/listeners from context {}", (Object)removed[0], (Object)contextPath);
        }
    }

    public void visitContextStartChange(ContextStartChange change) {
        String contextPath = change.getContextPath();
        PaxWebServletContextHandler servletContextHandler = this.contextHandlers.get(contextPath);
        if (servletContextHandler != null) {
            this.ensureServletContextStarted(servletContextHandler);
        } else {
            LOG.debug("Not starting unknown context {}.", (Object)contextPath);
        }
    }

    public void visitContextStopChange(ContextStopChange change) {
        String contextPath = change.getContextPath();
        PaxWebServletContextHandler sch = this.contextHandlers.get(contextPath);
        if (sch != null && sch.isStarted()) {
            LOG.info("Stopping Jetty context \"{}\"", (Object)contextPath);
            try {
                sch.stop();
            }
            catch (Exception e) {
                LOG.warn("Error stopping Jetty context \"{}\": {}", new Object[]{contextPath, e.getMessage(), e});
            }
        }
    }

    public void visitContextParamsChange(ContextParamsChange change) {
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding init parameters to {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getOsgiContextModel().getContextParams().putAll(change.getParams());
        } else {
            LOG.info("Removing init parameters from {}: {}", (Object)change.getOsgiContextModel(), (Object)change.getParams());
            change.getParams().keySet().forEach(param -> change.getOsgiContextModel().getContextParams().remove(param));
        }
    }

    public void visitSecurityConfigChange(SecurityConfigChange change) {
        LoginConfigModel loginConfigModel = change.getLoginConfigModel();
        List securityRoles = change.getSecurityRoles();
        List securityConstraints = change.getSecurityConstraints();
        OsgiContextModel ocm = change.getOsgiContextModel();
        if (change.getKind() == OpCode.ADD) {
            LOG.info("Adding security configuration to {}", (Object)ocm);
            if (loginConfigModel != null) {
                ocm.getSecurityConfiguration().setLoginConfig(loginConfigModel);
            }
            ocm.getSecurityConfiguration().getSecurityRoles().addAll(securityRoles);
            ocm.getSecurityConfiguration().getSecurityConstraints().addAll(securityConstraints);
            this.contextSecurityConstraints.computeIfAbsent(ocm.getContextPath(), c -> new TreeMap()).put(ocm, ocm.getSecurityConfiguration());
        } else {
            LOG.info("Removing security configuration from {}", (Object)ocm);
            if (!ocm.hasDirectHttpContextInstance() || loginConfigModel != null) {
                ocm.getSecurityConfiguration().setLoginConfig(null);
            }
            if (ocm.hasDirectHttpContextInstance() && loginConfigModel == null) {
                ocm.getSecurityConfiguration().getSecurityRoles().clear();
                ocm.getSecurityConfiguration().getSecurityConstraints().clear();
            } else {
                securityRoles.forEach(ocm.getSecurityConfiguration().getSecurityRoles()::remove);
                securityConstraints.forEach(sc -> ocm.getSecurityConfiguration().getSecurityConstraints().removeIf(scm -> scm.getName().equals(sc.getName())));
                TreeMap<OsgiContextModel, SecurityConfigurationModel> constraints = this.contextSecurityConstraints.get(ocm.getContextPath());
                if (constraints != null) {
                    constraints.remove(ocm);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureServletContextStarted(PaxWebServletContextHandler sch) {
        String contextPath;
        String string = contextPath = sch.getContextPath().equals("") ? "/" : sch.getContextPath();
        if (sch.isStarted() || this.pendingTransaction(contextPath)) {
            return;
        }
        try {
            ArrayList<String> connectors;
            LoginConfigModel loginConfig;
            OsgiContextModel highestRanked = ((PaxWebServletHandler)sch.getServletHandler()).getDefaultOsgiContextModel();
            OsgiServletContext highestRankedContext = ((PaxWebServletHandler)sch.getServletHandler()).getDefaultServletContext();
            highestRankedContext.allowServletContextListeners();
            LOG.info("Starting Jetty context \"{}\" with default Osgi Context {}", (Object)contextPath, (Object)highestRanked);
            sch.setClassLoader(highestRankedContext.getClassLoader());
            this.osgiContextModels.get(contextPath).forEach(ocm -> ocm.getContextParams().forEach((k, v) -> sch.getInitParams().put((String)k, (String)v)));
            highestRankedContext.clearAttributesFromPreviousCycle();
            this.clearDynamicRegistrations(contextPath, highestRanked);
            DynamicRegistrations registrations = this.dynamicRegistrations.get(contextPath);
            OsgiDynamicServletContext dynamicContext = new OsgiDynamicServletContext(highestRankedContext, registrations);
            sch.setOsgiServletContext((ServletContext)dynamicContext);
            LinkedList<SCIWrapper> initializers = new LinkedList<SCIWrapper>(this.initializers.get(contextPath).values());
            initializers.add((SCIWrapper)new RegisteringContainerInitializer(highestRankedContext, registrations));
            sch.setServletContainerInitializers(initializers);
            SessionHandler sessionHandler = sch.getSessionHandler();
            SessionConfigurationModel sessionConfig = highestRanked.getSessionConfiguration();
            if (sessionConfig != null) {
                SessionCookieConfig scc;
                if (sessionConfig.getSessionTimeout() != null) {
                    sessionHandler.setMaxInactiveInterval(sessionConfig.getSessionTimeout() * 60);
                }
                if ((scc = sessionConfig.getSessionCookieConfig()) != null) {
                    if (scc.getName() != null) {
                        sessionHandler.setSessionCookie(scc.getName());
                    }
                    if (scc.getDomain() != null) {
                        sessionHandler.getSessionCookieConfig().setDomain(scc.getDomain());
                    }
                    if (scc.getPath() != null) {
                        sessionHandler.getSessionCookieConfig().setPath(scc.getPath());
                    }
                    sessionHandler.getSessionCookieConfig().setMaxAge(scc.getMaxAge());
                    sessionHandler.getSessionCookieConfig().setHttpOnly(scc.isHttpOnly());
                    sessionHandler.getSessionCookieConfig().setSecure(scc.isSecure());
                    String comment = scc.getComment();
                    sessionHandler.getSessionCookieConfig().setComment(comment);
                    String sameSiteValue = this.configuration.session().getSessionCookieSameSite();
                    if (sameSiteValue != null && !"unset".equalsIgnoreCase(sameSiteValue)) {
                        if ("none".equalsIgnoreCase(sameSiteValue)) {
                            sessionHandler.setSameSite(HttpCookie.SameSite.NONE);
                        } else if ("lax".equalsIgnoreCase(sameSiteValue)) {
                            sessionHandler.setSameSite(HttpCookie.SameSite.LAX);
                        } else if ("strict".equalsIgnoreCase(sameSiteValue)) {
                            sessionHandler.setSameSite(HttpCookie.SameSite.STRICT);
                        }
                    }
                    if (sessionConfig.getTrackingModes().size() > 0) {
                        sessionHandler.setSessionTrackingModes(sessionConfig.getTrackingModes());
                    }
                }
            }
            Map<OsgiContextModel, SecurityConfigurationModel> allSecConfigs = (Map<OsgiContextModel, SecurityConfigurationModel>)this.contextSecurityConstraints.get(contextPath);
            SecurityConfigurationModel securityConfig = null;
            if (allSecConfigs != null && allSecConfigs.size() > 0) {
                securityConfig = (SecurityConfigurationModel)allSecConfigs.values().iterator().next();
            }
            if (securityConfig == null) {
                securityConfig = highestRanked.getSecurityConfiguration();
                allSecConfigs = Collections.singletonMap(highestRanked, securityConfig);
            }
            LoginConfigModel loginConfigModel = loginConfig = securityConfig != null ? securityConfig.getLoginConfig() : null;
            if (loginConfig == null) {
                sch.setSecurityHandler(new ConstraintSecurityHandler());
            } else {
                ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
                sch.setSecurityHandler(securityHandler);
                securityHandler.setRealmName(loginConfig.getRealmName());
                if (securityHandler.getRealmName() == null) {
                    securityHandler.setRealmName("default");
                }
                switch (loginConfig.getAuthMethod().toUpperCase()) {
                    case "BASIC": {
                        securityHandler.setAuthenticator(new BasicAuthenticator());
                        break;
                    }
                    case "DIGEST": {
                        Iterator digestAuthenticator = new DigestAuthenticator();
                        ((DigestAuthenticator)((Object)digestAuthenticator)).setMaxNonceAge(this.configuration.security().getDigestAuthMaxNonceAge());
                        ((DigestAuthenticator)((Object)digestAuthenticator)).setMaxNonceCount(this.configuration.security().getDigestAuthMaxNonceCount());
                        securityHandler.setAuthenticator((Authenticator)((Object)digestAuthenticator));
                        break;
                    }
                    case "CLIENT_CERT": 
                    case "CLIENT-CERT": {
                        securityHandler.setAuthenticator(new ClientCertAuthenticator());
                        break;
                    }
                    case "FORM": {
                        FormAuthenticator formAuthenticator = new FormAuthenticator(loginConfig.getFormLoginPage(), loginConfig.getFormErrorPage(), this.configuration.security().getFormAuthRedirect() == false);
                        securityHandler.setInitParameter("org.eclipse.jetty.security.form_login_page", loginConfig.getFormLoginPage());
                        securityHandler.setInitParameter("org.eclipse.jetty.security.form_error_page", loginConfig.getFormErrorPage());
                        securityHandler.setInitParameter("org.eclipse.jetty.security.dispatch", Boolean.toString(this.configuration.security().getFormAuthRedirect() == false));
                        securityHandler.setAuthenticator(formAuthenticator);
                        break;
                    }
                    case "NEGOTIATE": {
                        securityHandler.setAuthenticator(new ConfigurableSpnegoAuthenticator());
                        break;
                    }
                    default: {
                        Authenticator authenticator = this.getAuthenticator(loginConfig.getAuthMethod().toUpperCase());
                        if (authenticator == null) {
                            LOG.warn("Can't find Jetty Authenticator for auth method {}", (Object)loginConfig.getAuthMethod().toUpperCase());
                            break;
                        }
                        LOG.debug("Setting custom Jetty authenticator {}", (Object)authenticator);
                        securityHandler.setAuthenticator(authenticator);
                    }
                }
                ArrayList<SecurityConstraintModel> allConstraints = new ArrayList<SecurityConstraintModel>();
                allSecConfigs.values().forEach(sc -> {
                    allConstraints.addAll(sc.getSecurityConstraints());
                    for (String role : sc.getSecurityRoles()) {
                        securityHandler.addRole(role);
                    }
                });
                this.ensureSecurityConstraintsConfigured(securityHandler, allConstraints);
            }
            ArrayList<String> allVirtualHosts = new ArrayList<String>();
            ArrayList<String> vhosts = new ArrayList<String>(highestRanked.getVirtualHosts());
            if (vhosts.isEmpty()) {
                vhosts.addAll(Arrays.asList(this.configuration.server().getVirtualHosts()));
            }
            if ((connectors = new ArrayList<String>(highestRanked.getConnectors())).isEmpty()) {
                connectors.addAll(Arrays.asList(this.configuration.server().getConnectors()));
            }
            for (String vhost : vhosts) {
                if (vhost == null || "".equals(vhost.trim())) continue;
                if (vhost.startsWith("@")) {
                    allVirtualHosts.add(vhost);
                    continue;
                }
                allVirtualHosts.add(vhost);
            }
            for (String c : connectors) {
                if (c == null || "".equals(c.trim())) continue;
                if (c.startsWith("@")) {
                    allVirtualHosts.add(c);
                    continue;
                }
                allVirtualHosts.add("@" + c);
            }
            boolean connectorOnly = false;
            boolean vhostOnly = false;
            boolean vhostAndConnector = false;
            for (String vh : allVirtualHosts) {
                if (!vh.contains("@")) {
                    vhostOnly = true;
                    continue;
                }
                if (vh.startsWith("@")) {
                    connectorOnly = true;
                    continue;
                }
                vhostAndConnector = true;
            }
            if (vhostOnly && connectorOnly && !vhostAndConnector) {
                allVirtualHosts.add("_@_");
            }
            sch.setVirtualHosts(allVirtualHosts.toArray(new String[0]));
            XmlConfiguration previous = null;
            LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
            objects.put("Context", sch);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(sch.getClassLoader());
            try {
                ArrayList<URL> contextConfigs = new ArrayList<URL>();
                if (this.configuration.server().getContextConfigurationFile() != null) {
                    LOG.info("Found global Jetty context configuration file: {}", (Object)this.configuration.server().getContextConfigurationFile());
                    contextConfigs.add(this.configuration.server().getContextConfigurationFile().toURI().toURL());
                }
                for (URL url : highestRanked.getServerSpecificDescriptors()) {
                    String path = url.getPath();
                    if (!path.startsWith("/WEB-INF/") || !path.endsWith(".xml") || !path.contains("jetty")) continue;
                    contextConfigs.add(url);
                }
                for (URL url : contextConfigs) {
                    XmlConfiguration cfg = new XmlConfiguration(Resource.newResource(url));
                    LOG.info("Processing context specific {} for {}", (Object)url, (Object)contextPath);
                    this.processConfiguration(cfg, previous, objects);
                    previous = cfg;
                }
                sch.start();
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
            dynamicContext.rememberAttributesFromSCIs();
            highestRankedContext.register();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private Authenticator getAuthenticator(String authMethod) {
        ServiceLoader<AuthenticatorService> sl = ServiceLoader.load(AuthenticatorService.class, this.getClass().getClassLoader());
        for (AuthenticatorService svc : sl) {
            try {
                Authenticator auth = (Authenticator)svc.getAuthenticatorService(authMethod, Authenticator.class);
                if (auth == null) continue;
                return auth;
            }
            catch (Throwable t) {
                LOG.debug("Unable to load AuthenticatorService for: " + authMethod, t);
            }
        }
        return null;
    }

    private void ensureSecurityConstraintsConfigured(ConstraintSecurityHandler securityHandler, List<SecurityConstraintModel> models) {
        for (SecurityConstraintModel constraint : models) {
            Constraint base = new Constraint();
            if (constraint.isAuthRolesSet()) {
                base.setAuthenticate(true);
                base.setRoles(constraint.getAuthRoles().toArray(new String[0]));
                for (String role : constraint.getAuthRoles()) {
                    securityHandler.addRole(role);
                }
            }
            if (constraint.getTransportGuarantee() == ServletSecurity.TransportGuarantee.NONE) {
                base.setDataConstraint(0);
            } else {
                base.setDataConstraint(2);
            }
            for (SecurityConstraintModel.WebResourceCollection wrc : constraint.getWebResourceCollections()) {
                Constraint sc = null;
                try {
                    sc = (Constraint)base.clone();
                    sc.setName(wrc.getName());
                }
                catch (CloneNotSupportedException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
                if (wrc.getMethods().size() > 0 && wrc.getOmittedMethods().size() > 0) {
                    LOG.warn("Both methods and method omissions specified in the descriptor. Using methods only");
                    wrc.getOmittedMethods().clear();
                }
                for (String url : wrc.getPatterns()) {
                    ConstraintMapping mapping;
                    boolean hit = false;
                    for (String method : wrc.getMethods()) {
                        mapping = new ConstraintMapping();
                        mapping.setMethod(method);
                        mapping.setPathSpec(url);
                        mapping.setConstraint(sc);
                        securityHandler.addConstraintMapping(mapping);
                        hit = true;
                    }
                    for (String method : wrc.getOmittedMethods()) {
                        mapping = new ConstraintMapping();
                        mapping.setMethodOmissions(new String[]{method});
                        mapping.setPathSpec(url);
                        mapping.setConstraint(sc);
                        securityHandler.addConstraintMapping(mapping);
                        hit = true;
                    }
                    if (hit) continue;
                    ConstraintMapping mapping2 = new ConstraintMapping();
                    mapping2.setPathSpec(url);
                    mapping2.setConstraint(sc);
                    securityHandler.addConstraintMapping(mapping2);
                }
            }
        }
    }

    private boolean pendingTransaction(String contextPath) {
        return this.transactions.contains(contextPath);
    }

    private void configureErrorPages(String location, ErrorPageErrorHandler eph, ErrorPageModel epm) {
        for (String ex : epm.getExceptionClassNames()) {
            eph.addErrorPage(ex, location);
        }
        Iterator iterator = epm.getErrorCodes().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            eph.addErrorPage(code, location);
        }
        if (epm.isXx4()) {
            eph.addErrorPage(400, 499, location);
        }
        if (epm.isXx5()) {
            eph.addErrorPage(500, 599, location);
        }
    }

    private boolean quickFilterChange(ServletHandler servletHandler, PaxWebFilterHolder[] newFilterHolders) {
        boolean quick;
        FilterHolder[] existingFilterHolders = servletHandler.getFilters();
        boolean bl = quick = newFilterHolders.length >= existingFilterHolders.length;
        for (int pos = 0; quick && pos < existingFilterHolders.length; ++pos) {
            if (((PaxWebFilterHolder)existingFilterHolders[pos]).getFilterModel() == null || newFilterHolders[pos].getFilterModel() == null) {
                if (existingFilterHolders[pos].getName() != null && !existingFilterHolders[pos].getName().equals(newFilterHolders[pos].getName())) {
                    quick = false;
                    break;
                }
                if (existingFilterHolders[pos].getHeldClass() == null || existingFilterHolders[pos].getHeldClass().equals(newFilterHolders[pos].getHeldClass())) continue;
                quick = false;
                break;
            }
            if (((PaxWebFilterHolder)existingFilterHolders[pos]).getFilterModel().equals((Object)newFilterHolders[pos].getFilterModel())) continue;
            quick = false;
            break;
        }
        if (quick) {
            for (int i = pos; i < newFilterHolders.length; ++i) {
                PaxWebFilterHolder fh = newFilterHolders[i];
                servletHandler.addFilter(fh);
                for (PaxWebFilterMapping paxWebFilterMapping : fh.getMapping()) {
                    if (paxWebFilterMapping.isAfter()) {
                        servletHandler.addFilterMapping(paxWebFilterMapping);
                        continue;
                    }
                    servletHandler.prependFilterMapping(paxWebFilterMapping);
                }
            }
            return true;
        }
        return false;
    }

    private List<PaxWebFilterMapping> configureFilterMappings(FilterModel model) {
        LinkedList<PaxWebFilterMapping> mappings = new LinkedList<PaxWebFilterMapping>();
        if (model.getDynamicServletNames().size() > 0 || model.getDynamicUrlPatterns().size() > 0) {
            model.getDynamicServletNames().forEach(dm -> {
                if (!dm.isAfter()) {
                    mappings.add(new PaxWebFilterMapping(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (!dm.isAfter()) {
                    mappings.add(new PaxWebFilterMapping(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicServletNames().forEach(dm -> {
                if (dm.isAfter()) {
                    mappings.add(new PaxWebFilterMapping(model, (FilterModel.DynamicMapping)dm));
                }
            });
            model.getDynamicUrlPatterns().forEach(dm -> {
                if (dm.isAfter()) {
                    mappings.add(new PaxWebFilterMapping(model, (FilterModel.DynamicMapping)dm));
                }
            });
        } else {
            for (FilterModel.Mapping map : model.getMappingsPerDispatcherTypes()) {
                mappings.add(new PaxWebFilterMapping(model, map));
            }
        }
        return mappings;
    }

    private void processConfiguration(XmlConfiguration cfg, XmlConfiguration previous, Map<String, Object> objects) {
        cfg.getIdMap().putAll(previous == null ? objects : previous.getIdMap());
        cfg.getProperties().putAll(this.configuration.all());
        try {
            cfg.configure();
        }
        catch (Exception e) {
            LOG.warn("Problem parsing {}: {}", new Object[]{cfg, e.getMessage(), e});
        }
        objects.putAll(cfg.getIdMap());
        cfg.getIdMap().forEach((id, v) -> {
            if (HttpConfiguration.class.isAssignableFrom(v.getClass())) {
                this.httpConfigs.put((String)id, (HttpConfiguration)v);
            }
        });
    }

    public void setHandlers(Set<PriorityValue<Handler>> handlers) {
        this.mainHandler.setPriorityHandlers(handlers);
    }

    public void setCustomizers(Set<PriorityValue<HttpConfiguration.Customizer>> customizers) {
        this.registeredCustomizers.clear();
        this.registeredCustomizers.addAll(customizers);
        if (this.server != null) {
            this.configureServerCustomizers();
        }
    }

    private void configureServerCustomizers() {
        Connector[] connectors;
        for (Connector connector : connectors = this.server.getConnectors()) {
            Collection<ConnectionFactory> connectionFactories = connector.getConnectionFactories();
            for (ConnectionFactory connectionFactory : connectionFactories) {
                if (!(connectionFactory instanceof HttpConnectionFactory)) continue;
                HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)connectionFactory;
                HttpConfiguration httpConfiguration = httpConnectionFactory.getHttpConfiguration();
                for (PriorityValue<HttpConfiguration.Customizer> customizer : this.registeredCustomizers) {
                    httpConfiguration.addCustomizer(customizer.getValue());
                }
            }
        }
    }

    public void removeCustomizer(HttpConfiguration.Customizer customizer) {
        if (this.server != null) {
            Connector[] connectors;
            for (Connector connector : connectors = this.server.getConnectors()) {
                Collection<ConnectionFactory> connectionFactories = connector.getConnectionFactories();
                for (ConnectionFactory connectionFactory : connectionFactories) {
                    if (!(connectionFactory instanceof HttpConnectionFactory)) continue;
                    HttpConnectionFactory httpConnectionFactory = (HttpConnectionFactory)connectionFactory;
                    HttpConfiguration httpConfiguration = httpConnectionFactory.getHttpConfiguration();
                    List<HttpConfiguration.Customizer> httpConfigurationCustomizers = httpConfiguration.getCustomizers();
                    httpConfigurationCustomizers.remove(customizer);
                }
            }
        }
        this.registeredCustomizers.removeIf(pv -> pv.getValue() == customizer);
    }
}

