/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.HandshakeResponse;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.websocket.core.client.UpgradeListener;

public class JsrUpgradeListener
implements UpgradeListener {
    private final ClientEndpointConfig.Configurator configurator;

    public JsrUpgradeListener(ClientEndpointConfig.Configurator configurator) {
        this.configurator = configurator;
    }

    @Override
    public void onHandshakeRequest(HttpRequest request) {
        if (this.configurator == null) {
            return;
        }
        HttpFields fields = request.getHeaders();
        HashMap originalHeaders = new HashMap();
        fields.forEach(field -> {
            originalHeaders.putIfAbsent(field.getName(), new ArrayList());
            List values = (List)originalHeaders.get(field.getName());
            Collections.addAll(values, field.getValues());
        });
        this.configurator.beforeRequest(originalHeaders);
        request.headers(headers -> {
            headers.clear();
            originalHeaders.forEach(headers::put);
        });
    }

    @Override
    public void onHandshakeResponse(HttpRequest request, HttpResponse response) {
        if (this.configurator == null) {
            return;
        }
        HandshakeResponse handshakeResponse = () -> {
            HashMap ret = new HashMap();
            response.getHeaders().forEach(field -> {
                ret.putIfAbsent(field.getName(), new ArrayList());
                List values = (List)ret.get(field.getName());
                Collections.addAll(values, field.getValues());
            });
            return ret;
        };
        this.configurator.afterResponse(handshakeResponse);
    }
}

