/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.common;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.internal.util.ReflectUtils;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketAsyncRemote;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketBasicRemote;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketExtension;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandler;
import org.eclipse.jetty.websocket.javax.common.PathParamProvider;
import org.eclipse.jetty.websocket.javax.common.decoders.AvailableDecoders;
import org.eclipse.jetty.websocket.javax.common.encoders.AvailableEncoders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxWebSocketSession
implements Session {
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketSession.class);
    private final JavaxWebSocketContainer container;
    private final CoreSession coreSession;
    private final JavaxWebSocketFrameHandler frameHandler;
    private final AvailableDecoders availableDecoders;
    private final AvailableEncoders availableEncoders;
    private final Map<String, String> pathParameters;
    private final String sessionId;
    private final Map<String, Object> userProperties;
    private List<Extension> negotiatedExtensions;
    private JavaxWebSocketAsyncRemote asyncRemote;
    private JavaxWebSocketBasicRemote basicRemote;

    public JavaxWebSocketSession(JavaxWebSocketContainer container, CoreSession coreSession, JavaxWebSocketFrameHandler frameHandler, EndpointConfig endpointConfig) {
        Objects.requireNonNull(endpointConfig);
        this.container = container;
        this.coreSession = coreSession;
        this.frameHandler = frameHandler;
        this.sessionId = UUID.randomUUID().toString();
        this.availableDecoders = new AvailableDecoders(endpointConfig, container.getWebSocketComponents());
        this.availableEncoders = new AvailableEncoders(endpointConfig, container.getWebSocketComponents());
        if (endpointConfig instanceof PathParamProvider) {
            PathParamProvider pathParamProvider = (PathParamProvider)endpointConfig;
            this.pathParameters = new HashMap<String, String>(pathParamProvider.getPathParams());
        } else {
            this.pathParameters = Collections.emptyMap();
        }
        this.userProperties = endpointConfig.getUserProperties();
        container.notifySessionListeners(listener -> listener.onJavaxWebSocketSessionCreated(this));
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) {
        Objects.requireNonNull(handler, "MessageHandler.Partial cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add MessageHandler.Partial: {}", handler);
        }
        this.frameHandler.addMessageHandler(clazz, handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) {
        Objects.requireNonNull(handler, "MessageHandler.Whole cannot be null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add MessageHandler.Whole: {}", handler);
        }
        this.frameHandler.addMessageHandler(clazz, handler);
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        Class<?> onMessageClass;
        Objects.requireNonNull(handler, "MessageHandler cannot be null");
        Class<?> handlerClass = handler.getClass();
        boolean added = false;
        if (MessageHandler.Whole.class.isAssignableFrom(handlerClass)) {
            onMessageClass = ReflectUtils.findGenericClassFor(handlerClass, MessageHandler.Whole.class);
            this.addMessageHandler(onMessageClass, (MessageHandler.Whole)handler);
            added = true;
        }
        if (MessageHandler.Partial.class.isAssignableFrom(handlerClass)) {
            onMessageClass = ReflectUtils.findGenericClassFor(handlerClass, MessageHandler.Partial.class);
            this.addMessageHandler(onMessageClass, (MessageHandler.Partial)handler);
            added = true;
        }
        if (!added) {
            throw new IllegalStateException("Not a recognized " + MessageHandler.class.getName() + " type: " + handler.getClass());
        }
    }

    public void close() {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, null));
    }

    public void close(CloseReason closeReason) {
        try {
            FutureCallback b = new FutureCallback();
            this.coreSession.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase(), b);
            b.block(this.getBlockingTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            LOG.trace("IGNORED", (Throwable)e);
        }
    }

    private long getBlockingTimeout() {
        long idleTimeout = this.getMaxIdleTimeout();
        return idleTimeout > 0L ? idleTimeout + 1000L : idleTimeout;
    }

    public void filterReturnType(Object obj) {
        if (obj != null) {
            try {
                this.getBasicRemote().sendObject(obj);
            }
            catch (Exception cause) {
                throw new RuntimeException(cause);
            }
        }
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        if (this.asyncRemote == null) {
            this.asyncRemote = new JavaxWebSocketAsyncRemote(this, this.coreSession);
        }
        return this.asyncRemote;
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        if (this.basicRemote == null) {
            this.basicRemote = new JavaxWebSocketBasicRemote(this, this.coreSession);
        }
        return this.basicRemote;
    }

    public WebSocketContainer getContainer() {
        return this.container;
    }

    public JavaxWebSocketContainer getContainerImpl() {
        return this.container;
    }

    public AvailableDecoders getDecoders() {
        return this.availableDecoders;
    }

    public AvailableEncoders getEncoders() {
        return this.availableEncoders;
    }

    public Object getEndpoint() {
        return this.frameHandler.getEndpoint();
    }

    public JavaxWebSocketFrameHandler getFrameHandler() {
        return this.frameHandler;
    }

    public void abort() {
        this.coreSession.abort();
    }

    public String getId() {
        return this.sessionId;
    }

    public int getMaxBinaryMessageBufferSize() {
        long maxBinaryMsgSize = this.coreSession.getMaxBinaryMessageSize();
        return maxBinaryMsgSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxBinaryMsgSize;
    }

    public void setMaxBinaryMessageBufferSize(int length) {
        this.coreSession.setMaxBinaryMessageSize(length);
    }

    public long getMaxIdleTimeout() {
        return this.coreSession.getIdleTimeout().toMillis();
    }

    public void setMaxIdleTimeout(long milliseconds) {
        this.coreSession.setIdleTimeout(Duration.ofMillis(milliseconds));
    }

    public int getMaxTextMessageBufferSize() {
        long maxTextMsgSize = this.coreSession.getMaxTextMessageSize();
        return maxTextMsgSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxTextMsgSize;
    }

    public void setMaxTextMessageBufferSize(int length) {
        this.coreSession.setMaxTextMessageSize(length);
    }

    public Set<MessageHandler> getMessageHandlers() {
        return this.frameHandler.getMessageHandlers();
    }

    public List<Extension> getNegotiatedExtensions() {
        List<ExtensionConfig> extensions = this.coreSession.getNegotiatedExtensions();
        if (this.negotiatedExtensions == null && extensions != null) {
            this.negotiatedExtensions = extensions.stream().map(JavaxWebSocketExtension::new).collect(Collectors.toList());
        }
        return this.negotiatedExtensions;
    }

    public String getNegotiatedSubprotocol() {
        String acceptedSubProtocol = this.coreSession.getNegotiatedSubProtocol();
        if (acceptedSubProtocol == null) {
            return "";
        }
        return acceptedSubProtocol;
    }

    public Set<Session> getOpenSessions() {
        return this.container.getOpenSessions();
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public String getProtocolVersion() {
        return this.coreSession.getProtocolVersion();
    }

    public String getQueryString() {
        return this.coreSession.getRequestURI().getQuery();
    }

    public Map<String, List<String>> getRequestParameterMap() {
        return this.coreSession.getParameterMap();
    }

    public URI getRequestURI() {
        return this.coreSession.getRequestURI();
    }

    public Principal getUserPrincipal() {
        return this.frameHandler.getUpgradeRequest().getUserPrincipal();
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    public boolean isOpen() {
        return this.coreSession.isOutputOpen();
    }

    public boolean isSecure() {
        return this.coreSession.isSecure();
    }

    public void removeMessageHandler(MessageHandler handler) {
        this.frameHandler.removeMessageHandler(handler);
    }

    public String toString() {
        return String.format("%s@%x[%s,%s]", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.coreSession.getBehavior(), this.frameHandler});
    }
}

