/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.websocket.core.FrameHandler;
import org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import org.eclipse.jetty.websocket.javax.client.internal.JavaxWebSocketClientFrameHandlerFactory;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketFrameHandlerMetadata;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxServerUpgradeRequest;
import org.eclipse.jetty.websocket.javax.server.internal.PathParamIdentifier;

public class JavaxWebSocketServerFrameHandlerFactory
extends JavaxWebSocketClientFrameHandlerFactory
implements FrameHandlerFactory {
    public JavaxWebSocketServerFrameHandlerFactory(JavaxWebSocketContainer container) {
        super(container, new PathParamIdentifier());
    }

    @Override
    public JavaxWebSocketFrameHandlerMetadata getMetadata(Class<?> endpointClass, EndpointConfig endpointConfig) {
        if (Endpoint.class.isAssignableFrom(endpointClass)) {
            return this.createEndpointMetadata(endpointConfig);
        }
        ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            return super.getMetadata(endpointClass, endpointConfig);
        }
        UriTemplatePathSpec templatePathSpec = new UriTemplatePathSpec(anno.value());
        JavaxWebSocketFrameHandlerMetadata metadata = new JavaxWebSocketFrameHandlerMetadata(endpointConfig, this.components);
        metadata.setUriTemplatePathSpec(templatePathSpec);
        return this.discoverJavaxFrameHandlerMetadata(endpointClass, metadata);
    }

    @Override
    public FrameHandler newFrameHandler(Object websocketPojo, ServerUpgradeRequest upgradeRequest, ServerUpgradeResponse upgradeResponse) {
        return this.newJavaxWebSocketFrameHandler(websocketPojo, new JavaxServerUpgradeRequest(upgradeRequest));
    }
}

