/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.jetty.internal;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.ops4j.pax.web.service.jetty.internal.JettyServerControllerFactory;
import org.ops4j.pax.web.service.jetty.internal.PriorityValue;

public class PrioritizedHandlerCollection
extends ContextHandlerCollection {
    protected final HandlerCollection handlerCollectionBefore = new HandlerCollection();
    protected final HandlerCollection handlerCollectionAfter = new HandlerCollection();
    private final Set<PriorityValue<Handler>> handlersBefore = new TreeSet(JettyServerControllerFactory.priorityComparator);
    private final Set<PriorityValue<Handler>> handlersAfter = new TreeSet(JettyServerControllerFactory.priorityComparator);

    public void setPriorityHandlers(Set<PriorityValue<Handler>> handlers) {
        handlers.forEach(pv -> {
            if (pv.getPriority() > 0) {
                this.handlersBefore.add((PriorityValue<Handler>)pv);
            } else {
                this.handlersAfter.add((PriorityValue<Handler>)pv);
            }
        });
        this.handlerCollectionBefore.setHandlers((Handler[])this.handlersBefore.stream().map(PriorityValue::getValue).toArray(Handler[]::new));
        this.handlerCollectionAfter.setHandlers((Handler[])this.handlersAfter.stream().map(PriorityValue::getValue).toArray(Handler[]::new));
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.handlerCollectionBefore.setServer(this.getServer());
        this.handlerCollectionAfter.setServer(this.getServer());
        this.handlerCollectionBefore.start();
        this.handlerCollectionAfter.start();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.handlerCollectionBefore.stop();
        this.handlerCollectionAfter.stop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isStarted()) {
            try {
                this.handlerCollectionBefore.handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) {
                    if ("OPTIONS".equals(baseRequest.getMethod()) && "*".equals(target)) {
                        response.setStatus(200);
                        response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                        baseRequest.setHandled(true);
                    }
                    super.handle(target, baseRequest, request, response);
                }
                this.handlerCollectionAfter.handle(target, baseRequest, request, response);
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }
}

