/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.xml.ElementHelper;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultPropertyResolver
extends DictionaryPropertyResolver {
    private static final Log LOG = LogFactory.getLog(DefaultPropertyResolver.class);

    public DefaultPropertyResolver() {
        super(DefaultPropertyResolver.getDefaltProperties());
    }

    private static Dictionary<String, String> getDefaltProperties() {
        File temporaryDirectory;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        InputStream stream = DefaultPropertyResolver.class.getClassLoader().getResourceAsStream("OSGI-INF/metatype/metatype.xml");
        try {
            Element[] children;
            Element rootElement = ElementHelper.getRootElement(stream);
            for (Element element : children = ElementHelper.getChildren(rootElement, "AD")) {
                String id = element.getAttribute("id");
                String required = element.getAttribute("required");
                String defaultAttribute = element.getAttribute("default");
                if (Boolean.parseBoolean(required)) {
                    ((Dictionary)properties).put(id, defaultAttribute);
                    continue;
                }
                if (defaultAttribute == null || defaultAttribute.length() <= 0) continue;
                ((Dictionary)properties).put(id, defaultAttribute);
            }
        }
        catch (ParserConfigurationException e) {
            LOG.error("Could not parse metatype.xml. Reason: " + e.getMessage());
            return properties;
        }
        catch (IOException e) {
            LOG.error("Could not parse metatype.xml. Reason: " + e.getMessage());
            return properties;
        }
        catch (SAXException e) {
            LOG.error("Could not parse metatype.xml. Reason: " + e.getMessage());
            return properties;
        }
        if (((Dictionary)properties).get("javax.servlet.context.tempdir") != null) {
            temporaryDirectory = new File((String)((Dictionary)properties).get("javax.servlet.context.tempdir"));
            if (!temporaryDirectory.exists()) {
                temporaryDirectory.mkdirs();
            }
        } else {
            try {
                temporaryDirectory = File.createTempFile(".paxweb", "");
                temporaryDirectory.delete();
                temporaryDirectory = new File(temporaryDirectory.getAbsolutePath());
                temporaryDirectory.mkdirs();
                temporaryDirectory.deleteOnExit();
                ((Dictionary)properties).put("javax.servlet.context.tempdir", temporaryDirectory.getCanonicalPath());
            }
            catch (Exception e) {
                LOG.warn("Could not create temporary directory. Reason: " + e.getMessage());
            }
        }
        return properties;
    }
}

