/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletException;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.SharedWebContainerContext;
import org.ops4j.pax.web.service.internal.HttpServiceStopped;
import org.ops4j.pax.web.service.internal.StoppableHttpService;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceProxy
implements StoppableHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceProxy.class);
    private StoppableHttpService m_delegate;

    public HttpServiceProxy(StoppableHttpService delegate) {
        NullArgumentException.validateNotNull(delegate, "Delegate");
        LOG.debug("HttpServiceProxy created for HttpService {}", (Object)delegate);
        this.m_delegate = delegate;
    }

    @Override
    public void registerServlet(String alias, Servlet servlet, Dictionary initParams, HttpContext httpContext) throws ServletException, NamespaceException {
        LOG.debug("Registering servlet: [" + alias + "] -> " + servlet);
        this.m_delegate.registerServlet(alias, servlet, initParams, httpContext);
    }

    @Override
    public void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        LOG.debug("Registering resource: [" + alias + "] -> " + name);
        this.m_delegate.registerResources(alias, name, httpContext);
    }

    @Override
    public void unregister(String alias) {
        LOG.debug("Unregistering [" + alias + "]");
        this.m_delegate.unregister(alias);
    }

    @Override
    public HttpContext createDefaultHttpContext() {
        LOG.debug("Creating a default context");
        return this.m_delegate.createDefaultHttpContext();
    }

    @Override
    public synchronized void stop() {
        LOG.debug("Stopping http service: [" + this + "]");
        StoppableHttpService stopping = this.m_delegate;
        this.m_delegate = new HttpServiceStopped();
        stopping.stop();
    }

    @Override
    public void registerServlet(Servlet servlet, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "]");
        this.m_delegate.registerServlet(servlet, urlPatterns, initParams, httpContext);
    }

    @Override
    public void registerServlet(Servlet servlet, String servletName, String[] urlPatterns, Dictionary initParams, HttpContext httpContext) throws ServletException {
        LOG.debug("Registering servlet [" + servlet + "] with name [" + servletName + "]");
        this.m_delegate.registerServlet(servlet, servletName, urlPatterns, initParams, httpContext);
    }

    @Override
    public void unregisterServlet(Servlet servlet) {
        LOG.debug("Unregistering servlet [" + servlet + "]");
        this.m_delegate.unregisterServlet(servlet);
    }

    @Override
    public void registerEventListener(EventListener listener, HttpContext httpContext) {
        LOG.debug("Registering event listener [" + listener + "]");
        this.m_delegate.registerEventListener(listener, httpContext);
    }

    @Override
    public void unregisterEventListener(EventListener listener) {
        LOG.debug("Unregistering event listener [" + listener + "]");
        this.m_delegate.unregisterEventListener(listener);
    }

    @Override
    public void registerFilter(Filter filter, String[] urlPatterns, String[] aliases, Dictionary initParams, HttpContext httpContext) {
        LOG.debug("Registering filter [" + filter + "]");
        this.m_delegate.registerFilter(filter, urlPatterns, aliases, initParams, httpContext);
    }

    @Override
    public void unregisterFilter(Filter filter) {
        LOG.debug("Unregistering filter [" + filter + "]");
        this.m_delegate.unregisterFilter(filter);
    }

    @Override
    public void setContextParam(Dictionary params, HttpContext httpContext) {
        LOG.debug("Setting context paramters [" + params + "] for http context [" + httpContext + "]");
        this.m_delegate.setContextParam(params, httpContext);
    }

    @Override
    public void setSessionTimeout(Integer minutes, HttpContext httpContext) {
        LOG.debug("Setting session timeout to " + minutes + " minutes for http context [" + httpContext + "]");
        this.m_delegate.setSessionTimeout(minutes, httpContext);
    }

    @Override
    public void registerJsps(String[] urlPatterns, HttpContext httpContext) {
        LOG.debug("Registering jsps");
        this.m_delegate.registerJsps(urlPatterns, httpContext);
    }

    @Override
    public void registerJsps(String[] urlPatterns, Dictionary initParams, HttpContext httpContext) {
        LOG.debug("Registering jsps");
        this.m_delegate.registerJsps(urlPatterns, initParams, httpContext);
    }

    @Override
    public void unregisterJsps(HttpContext httpContext) {
        LOG.debug("Unregistering jsps");
        this.m_delegate.unregisterJsps(httpContext);
    }

    @Override
    public void unregisterJsps(String[] urlPatterns, HttpContext httpContext) {
        LOG.debug("Unregistering jsps");
        this.m_delegate.unregisterJsps(urlPatterns, httpContext);
    }

    @Override
    public void registerErrorPage(String error, String location, HttpContext httpContext) {
        LOG.debug("Registering error page [" + error + "]");
        this.m_delegate.registerErrorPage(error, location, httpContext);
    }

    @Override
    public void unregisterErrorPage(String error, HttpContext httpContext) {
        LOG.debug("Unregistering error page [" + error + "]");
        this.m_delegate.unregisterErrorPage(error, httpContext);
    }

    @Override
    public void registerWelcomeFiles(String[] welcomeFiles, boolean redirect, HttpContext httpContext) {
        LOG.debug("Registering welcome files [" + Arrays.toString(welcomeFiles) + "]");
        this.m_delegate.registerWelcomeFiles(welcomeFiles, redirect, httpContext);
    }

    @Override
    public void unregisterWelcomeFiles(HttpContext httpContext) {
        LOG.debug("Unregistering welcome files");
        this.m_delegate.unregisterWelcomeFiles(httpContext);
    }

    @Override
    public void registerLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage, HttpContext httpContext) {
        LOG.debug("Registering LoginConfig for realm [ " + realmName + " ]");
        this.m_delegate.registerLoginConfig(authMethod, realmName, formLoginPage, formErrorPage, httpContext);
    }

    @Override
    public void unregisterLoginConfig(HttpContext httpContext) {
        LOG.debug("Unregistering LoginConfig");
        this.m_delegate.unregisterLoginConfig(httpContext);
    }

    @Override
    public void registerConstraintMapping(String constraintName, String url, String mapping, String dataConstraint, boolean authentication, List<String> roles, HttpContext httpContext) {
        LOG.debug("Registering constraint mapping for [ " + constraintName + " ] ");
        this.m_delegate.registerConstraintMapping(constraintName, url, mapping, dataConstraint, authentication, roles, httpContext);
    }

    @Override
    public void unregisterConstraintMapping(HttpContext httpContext) {
        LOG.debug("Unregister constraint mapping");
        this.m_delegate.unregisterConstraintMapping(httpContext);
    }

    @Override
    public SharedWebContainerContext getDefaultSharedHttpContext() {
        return this.m_delegate.getDefaultSharedHttpContext();
    }

    @Override
    public void registerServletContainerInitializer(ServletContainerInitializer servletContainerInitializer, Class[] classes, HttpContext httpContext) {
        this.m_delegate.registerServletContainerInitializer(servletContainerInitializer, classes, httpContext);
    }

    @Override
    public void unregisterServletContainerInitializer(HttpContext m_httpContext) {
        this.m_delegate.unregisterServletContainerInitializer(m_httpContext);
    }

    @Override
    public void registerJettyWebXml(URL jettyWebXmlURL, HttpContext m_httpContext) {
        this.m_delegate.registerJettyWebXml(jettyWebXmlURL, m_httpContext);
    }

    @Override
    public void registerJspServlet(String[] urlPatterns, HttpContext httpContext, String jspFile) {
        this.m_delegate.registerJspServlet(urlPatterns, httpContext, jspFile);
    }

    @Override
    public void registerJspServlet(String[] urlPatterns, Dictionary initParams, HttpContext httpContext, String jspFile) {
        this.m_delegate.registerJspServlet(urlPatterns, initParams, httpContext, jspFile);
    }

    @Override
    public void setVirtualHosts(List<String> virtualHosts, HttpContext httpContext) {
        this.m_delegate.setVirtualHosts(virtualHosts, httpContext);
    }

    @Override
    public void setConnectors(List<String> connectors, HttpContext httpContext) {
        this.m_delegate.setConnectors(connectors, httpContext);
    }

    @Override
    public void begin(HttpContext m_httpContext) {
        this.m_delegate.begin(m_httpContext);
    }

    @Override
    public void end(HttpContext m_httpContext) {
        this.m_delegate.end(m_httpContext);
    }
}

