/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathUtil.class);

    public static URL[] getClassPathJars(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        String bundleClasspath = (String)bundle.getHeaders().get("Bundle-ClassPath");
        if (bundleClasspath != null) {
            String[] segments;
            for (String segment : segments = bundleClasspath.split(",")) {
                URL url = bundle.getEntry(segment);
                if (url == null || !url.toExternalForm().endsWith("jar")) continue;
                LOG.debug("Using url: " + url);
                try {
                    URL jarUrl = new URL("jar:" + url.toExternalForm() + "!/");
                    urls.add(jarUrl);
                }
                catch (MalformedURLException ignore) {
                    LOG.debug(ignore.getMessage());
                }
            }
        }
        LOG.debug("Bundle-ClassPath URLs: " + urls);
        urls.addAll(ClassPathUtil.getLocationsOfBundlesInClassSpace(bundle));
        return urls.toArray(new URL[urls.size()]);
    }

    private static List<URL> getLocationsOfBundlesInClassSpace(Bundle bundle) {
        ArrayList<URL> urls = new ArrayList<URL>();
        Set<Bundle> importedBundles = ClassPathUtil.getBundlesInClassSpace(bundle, new HashSet<Bundle>());
        for (Bundle importedBundle : importedBundles) {
            URL url = ClassPathUtil.getLocationOfBundle(importedBundle);
            if (url == null) continue;
            urls.add(url);
        }
        return urls;
    }

    private static URL getLocationOfBundle(Bundle importedBundle) {
        URL url = null;
        try {
            url = new URL(importedBundle.getLocation());
        }
        catch (MalformedURLException e) {
            try {
                url = importedBundle.getEntry("/");
            }
            catch (Exception e2) {
                LOG.warn("Exception while calculating location of bundle", (Throwable)e);
            }
        }
        return url;
    }

    public static Set<Bundle> getBundlesInClassSpace(Bundle bundle, Set<Bundle> bundleSet) {
        return ClassPathUtil.getBundlesInClassSpace(bundle.getBundleContext(), bundle, bundleSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Bundle> getBundlesInClassSpace(BundleContext context, Bundle bundle, Set<Bundle> bundleSet) {
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        if (bundle == null) {
            LOG.error("Incoming bundle is null");
            return bundles;
        }
        if (context == null) {
            LOG.error("Incoming context is null");
            return bundles;
        }
        ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
        if (ref == null) {
            LOG.error("PackageAdmin service is unavailable.");
            return bundles;
        }
        try {
            String name;
            String[] split;
            PackageAdmin pa = (PackageAdmin)context.getService(ref);
            if (pa == null) {
                LOG.error("PackageAdmin service is unavailable.");
                HashSet<Bundle> hashSet = bundles;
                return hashSet;
            }
            Dictionary headers = bundle.getHeaders();
            String importPackage = (String)headers.get("Import-Package");
            String requiredBundleHeader = (String)headers.get("Require-Bundle");
            if (importPackage != null) {
                String[] importPackages;
                for (String impPackage : importPackages = importPackage.split(",")) {
                    ExportedPackage[] exportedPackages;
                    split = impPackage.split(";");
                    name = split[0].trim();
                    if (name.matches("^[0-9].*") || (exportedPackages = pa.getExportedPackages(name)) == null) continue;
                    for (ExportedPackage exportedPackage : exportedPackages) {
                        Bundle exportingBundle;
                        if (!Arrays.asList(exportedPackage.getImportingBundles()).contains(bundle) || (exportingBundle = exportedPackage.getExportingBundle()).getBundleId() == 0L || bundles.contains(exportingBundle)) continue;
                        bundles.add(exportingBundle);
                    }
                }
            }
            if (requiredBundleHeader != null) {
                String[] reqBundles;
                for (String reqBundle : reqBundles = requiredBundleHeader.split(",")) {
                    RequiredBundle[] requiredBundles;
                    split = reqBundle.split(";");
                    name = split[0].trim();
                    if (name.matches("^[0-9].*") || (requiredBundles = pa.getRequiredBundles(name)) == null) continue;
                    for (ExportedPackage exportedPackage : requiredBundles) {
                        if (!Arrays.asList(exportedPackage.getRequiringBundles()).contains(bundle) || exportedPackage.getBundle().getBundleId() == 0L) continue;
                        bundles.add(exportedPackage.getBundle());
                    }
                }
            }
        }
        finally {
            context.ungetService(ref);
        }
        HashSet<Bundle> transitiveBundles = new HashSet<Bundle>();
        if (!bundleSet.containsAll(bundles)) {
            bundles.removeAll(bundleSet);
            bundleSet.addAll(bundles);
            for (Bundle importedBundle : bundles) {
                transitiveBundles.addAll(ClassPathUtil.getBundlesInClassSpace(context, importedBundle, bundleSet));
            }
        }
        return bundleSet;
    }
}

