/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi;

import java.util.Collection;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WebEvent {
    public static final int DEPLOYING = 1;
    public static final int DEPLOYED = 2;
    public static final int UNDEPLOYING = 3;
    public static final int UNDEPLOYED = 4;
    public static final int FAILED = 5;
    public static final int WAITING = 6;
    private boolean replay;
    private int type;
    private Bundle bundle;
    private Bundle extenderBundle;
    private Throwable cause;
    private long timestamp;
    private String contextPath;
    private Collection<Long> collisionIds;
    private HttpService httpService;
    private HttpContext httpContext;

    public WebEvent(WebEvent event, boolean replay) {
        this.type = event.getType();
        this.contextPath = event.getContextPath();
        this.bundle = event.getBundle();
        this.extenderBundle = event.getExtenderBundle();
        this.collisionIds = event.getCollisionIds();
        this.cause = event.getCause();
        this.timestamp = event.getTimestamp();
        this.httpService = event.getHttpService();
        this.httpContext = event.getHttpContext();
        this.replay = replay;
    }

    public WebEvent(int type, String contextPath, Bundle bundle, Bundle extenderBundle) {
        this.timestamp = System.currentTimeMillis();
        this.type = type;
        this.contextPath = contextPath;
        this.bundle = bundle;
        this.extenderBundle = extenderBundle;
    }

    public WebEvent(int type, String contextPath, Bundle bundle, Bundle extenderBundle, Throwable cause) {
        this(type, contextPath, bundle, extenderBundle);
        this.cause = cause;
    }

    public WebEvent(int type, String contextPath, Bundle bundle, Bundle extenderBundle, Collection<Long> ids) {
        this(type, contextPath, bundle, extenderBundle);
        this.collisionIds = ids;
    }

    public WebEvent(int type, String contextPath, Bundle bundle, Bundle extenderBundle, HttpService httpService, HttpContext httpContext) {
        this(type, contextPath, bundle, extenderBundle);
        this.httpContext = httpContext;
        this.httpService = httpService;
    }

    public int getType() {
        return this.type;
    }

    public boolean isReplay() {
        return this.replay;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle getExtenderBundle() {
        return this.extenderBundle;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Collection<Long> getCollisionIds() {
        return this.collisionIds;
    }

    public HttpService getHttpService() {
        return this.httpService;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public String toString() {
        return "WebEvent [replay=" + this.replay + ", type=" + this.type + ", bundle=" + this.bundle + ", extenderBundle=" + this.extenderBundle + ", cause=" + this.cause + ", timestamp=" + this.timestamp + ", contextPath=" + this.contextPath + ", collisionIds=" + this.collisionIds + ", httpService=" + this.httpService + ", httpContext=" + this.httpContext + "]";
    }

    public static enum WebTopic {
        DEPLOYING("org/osgi/service/web/DEPLOYING"),
        DEPLOYED("org/osgi/service/web/DEPLOYED"),
        UNDEPLOYING("org/osgi/service/web/UNDEPLOYING"),
        UNDEPLOYED("org/osgi/service/web/UNDEPLOYED"),
        FAILED("org/osgi/service/web/FAILED"),
        WAITING("org/osgi/service/web/WAITING");

        private final String topic;

        private WebTopic(String topic) {
            this.topic = topic;
        }

        public String toString() {
            return this.topic;
        }
    }
}

