/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.osgi.framework.Bundle;
import org.osgi.service.http.HttpContext;

public class ContextModel
extends Identity {
    private final HttpContext m_httpContext;
    private final ClassLoader m_classLoader;
    private final Map<String, String> m_contextParams;
    private String m_contextName;
    private Filter m_welcomeFilesFilter;
    private AccessControlContext m_accessControllerContext;
    private Map<Servlet, String[]> m_jspServlets;
    private Integer m_sessionTimeout;
    private String m_sessionCookie;
    private String m_sessionUrl;
    private Boolean m_sessionCookieHttpOnly;
    private String m_sessionWorkerName;
    private final Bundle m_bundle;
    private String realmName;
    private String authMethod;
    private String formLoginPage;
    private String formErrorPage;
    private Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers;
    private URL jettyWebXmlUrl;
    private final List<String> virtualHosts;
    private final List<String> connectors;

    public ContextModel(HttpContext httpContext, Bundle bundle, ClassLoader classLoader) {
        this.m_bundle = bundle;
        NullArgumentException.validateNotNull(httpContext, "Http context");
        NullArgumentException.validateNotNull(classLoader, "Class loader");
        this.m_classLoader = classLoader;
        this.m_httpContext = httpContext;
        this.m_contextParams = new HashMap<String, String>();
        this.m_jspServlets = new IdentityHashMap<Servlet, String[]>();
        this.m_contextName = "";
        this.m_accessControllerContext = AccessController.getContext();
        this.virtualHosts = new ArrayList<String>();
        this.connectors = new ArrayList<String>();
    }

    public HttpContext getHttpContext() {
        return this.m_httpContext;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public void setContextParams(Dictionary contextParams) {
        this.m_contextParams.clear();
        if (contextParams != null && !contextParams.isEmpty()) {
            Enumeration keys = contextParams.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = contextParams.get(key);
                if (!(key instanceof String) || !(value instanceof String)) {
                    throw new IllegalArgumentException("Context params keys and values must be Strings");
                }
                this.m_contextParams.put((String)key, (String)value);
            }
            this.m_contextName = this.m_contextParams.get("webapp.context");
        }
        this.m_contextName = this.m_contextName != null ? this.m_contextName.trim() : "";
    }

    public Map<String, String> getContextParams() {
        return this.m_contextParams;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public Map<Servlet, String[]> getJspServlets() {
        return this.m_jspServlets;
    }

    public AccessControlContext getAccessControllerContext() {
        return this.m_accessControllerContext;
    }

    public Filter getWelcomeFilesFilter() {
        return this.m_welcomeFilesFilter;
    }

    public void setWelcomeFilesFilter(Filter welcomeFilesFilter) {
        this.m_welcomeFilesFilter = welcomeFilesFilter;
    }

    public Integer getSessionTimeout() {
        return this.m_sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.m_sessionTimeout = sessionTimeout;
    }

    public String getSessionCookie() {
        return this.m_sessionCookie;
    }

    public void setSessionCookie(String sessionCookie) {
        this.m_sessionCookie = sessionCookie;
    }

    public String getSessionUrl() {
        return this.m_sessionUrl;
    }

    public void setSessionUrl(String sessionUrl) {
        this.m_sessionUrl = sessionUrl;
    }

    public Boolean getSessionCookieHttpOnly() {
        return this.m_sessionCookieHttpOnly;
    }

    public void setSessionCookieHttpOnly(Boolean sessionCookieHttpOnly) {
        this.m_sessionCookieHttpOnly = sessionCookieHttpOnly;
    }

    public String getSessionWorkerName() {
        return this.m_sessionWorkerName;
    }

    public void setSessionWorkerName(String sessionWorkerName) {
        this.m_sessionWorkerName = sessionWorkerName;
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.getClass().getSimpleName()).append("{").append("id=").append(this.getId()).append(",name=").append(this.m_contextName).append(",httpContext=").append(this.m_httpContext).append(",contextParams=").append(this.m_contextParams).append(",virtualHosts={");
        for (String virtualHost : this.virtualHosts) {
            sb.append(virtualHost).append(",");
        }
        sb.append("},connectors={");
        for (String connector : this.connectors) {
            sb.append(connector).append(",");
        }
        return sb.append("}}").toString();
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public void setFormLoginPage(String formLoginPage) {
        this.formLoginPage = formLoginPage;
    }

    public void setFormErrorPage(String formErrorPage) {
        this.formErrorPage = formErrorPage;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Map<ServletContainerInitializer, Set<Class<?>>> getContainerInitializers() {
        return this.containerInitializers;
    }

    public void setContainerInitializers(Map<ServletContainerInitializer, Set<Class<?>>> containerInitializers) {
        this.containerInitializers = containerInitializers;
    }

    public void addContainerInitializer(ServletContainerInitializer containerInitializer, Set<Class<?>> classes) {
        if (this.containerInitializers == null) {
            this.containerInitializers = new HashMap();
        }
        this.containerInitializers.put(containerInitializer, classes);
    }

    public void setVirtualHosts(List<String> virtualHosts) {
        this.virtualHosts.clear();
        this.virtualHosts.addAll(virtualHosts);
    }

    public List<String> getVirtualHosts() {
        return this.virtualHosts;
    }

    public void setConnectors(List<String> connectors) {
        this.connectors.clear();
        this.connectors.addAll(connectors);
    }

    public List<String> getConnectors() {
        return this.connectors;
    }

    public void setJettyWebXmlUrl(URL jettyWebXmlUrl) {
        this.jettyWebXmlUrl = jettyWebXmlUrl;
    }

    public URL getJettyWebXmlURL() {
        return this.jettyWebXmlUrl;
    }
}

