/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.ContainerInitializerModel;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.EventListenerModel;
import org.ops4j.pax.web.service.spi.model.FilterModel;
import org.ops4j.pax.web.service.spi.model.LoginConfigModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.model.SecurityConstraintMappingModel;
import org.ops4j.pax.web.service.spi.model.ServletModel;
import org.osgi.service.http.HttpContext;

public class ServiceModel {
    private final Map<String, ServletModel> m_aliasMapping = new HashMap<String, ServletModel>();
    private final Set<ServletModel> m_servletModels = new HashSet<ServletModel>();
    private final Map<Filter, FilterModel> m_filterModels = new LinkedHashMap<Filter, FilterModel>();
    private final Map<EventListener, EventListenerModel> m_eventListenerModels = new HashMap<EventListener, EventListenerModel>();
    private final Map<String, LoginConfigModel> m_loginConfigModels;
    private final Map<String, ErrorPageModel> m_errorPageModels = new HashMap<String, ErrorPageModel>();
    private final Map<HttpContext, ContextModel> m_contextModels = new HashMap<HttpContext, ContextModel>();
    private final Map<String, SecurityConstraintMappingModel> m_securityConstraintMappingModels;
    private final Map<ServletContainerInitializer, ContainerInitializerModel> containerInitializers;

    public ServiceModel() {
        this.m_loginConfigModels = new HashMap<String, LoginConfigModel>();
        this.m_securityConstraintMappingModels = new HashMap<String, SecurityConstraintMappingModel>();
        this.containerInitializers = new HashMap<ServletContainerInitializer, ContainerInitializerModel>();
    }

    public synchronized ServletModel getServletModelWithAlias(String alias) {
        NullArgumentException.validateNotEmpty(alias, "Alias");
        return this.m_aliasMapping.get(alias);
    }

    public synchronized void addServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.m_aliasMapping.put(model.getAlias(), model);
        }
        this.m_servletModels.add(model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized void removeServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.m_aliasMapping.remove(model.getAlias());
        }
        this.m_servletModels.remove(model);
    }

    public synchronized ServletModel removeServlet(Servlet servlet) {
        ServletModel model = this.findServletModel(servlet);
        if (model == null) {
            throw new IllegalArgumentException("Servlet [" + servlet + " is not currently registered in any context");
        }
        this.m_servletModels.remove(servlet);
        return model;
    }

    private synchronized ServletModel findServletModel(Servlet servlet) {
        for (ServletModel servletModel : this.m_servletModels) {
            if (servletModel.getServlet() == null || !servletModel.getServlet().equals(servlet)) continue;
            return servletModel;
        }
        return null;
    }

    public synchronized Set<ServletModel> removeServletClass(Class<? extends Servlet> servletClass) {
        Set<ServletModel> models = this.findServletModels(servletClass);
        if (models == null) {
            throw new IllegalArgumentException("Servlet class [" + servletClass + " is not currently registered in any context");
        }
        this.m_servletModels.removeAll(models);
        return models;
    }

    private synchronized Set<ServletModel> findServletModels(Class<? extends Servlet> servletClass) {
        HashSet<ServletModel> servletModels = null;
        for (ServletModel servletModel : this.m_servletModels) {
            if (servletModel.getServletClass() == null || !servletModel.getServletClass().equals(servletClass)) continue;
            if (servletModels == null) {
                servletModels = new HashSet<ServletModel>();
            }
            servletModels.add(servletModel);
        }
        return servletModels;
    }

    public synchronized void addEventListenerModel(EventListenerModel model) {
        if (this.m_eventListenerModels.containsKey(model.getEventListener())) {
            throw new IllegalArgumentException("Listener [" + model.getEventListener() + "] already registered.");
        }
        this.m_eventListenerModels.put(model.getEventListener(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized EventListenerModel removeEventListener(EventListener listener) {
        EventListenerModel model = this.m_eventListenerModels.get(listener);
        if (model == null) {
            throw new IllegalArgumentException("Listener [" + listener + " is not currently registered in any context");
        }
        this.m_eventListenerModels.remove(listener);
        return model;
    }

    public synchronized void addFilterModel(FilterModel model) {
        if (this.m_filterModels.containsKey(model.getFilter())) {
            throw new IllegalArgumentException("Filter [" + model.getFilter() + "] is already registered.");
        }
        this.m_filterModels.put(model.getFilter(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized FilterModel removeFilter(Filter filter) {
        FilterModel model = this.m_filterModels.get(filter);
        if (model == null) {
            throw new IllegalArgumentException("Filter [" + filter + " is not currently registered in any context");
        }
        this.m_filterModels.remove(filter);
        return model;
    }

    public synchronized ServletModel[] getServletModels() {
        return this.m_servletModels.toArray(new ServletModel[this.m_servletModels.size()]);
    }

    public synchronized EventListenerModel[] getEventListenerModels() {
        Collection<EventListenerModel> models = this.m_eventListenerModels.values();
        return models.toArray(new EventListenerModel[models.size()]);
    }

    public synchronized FilterModel[] getFilterModels() {
        Collection<FilterModel> models = this.m_filterModels.values();
        return models.toArray(new FilterModel[models.size()]);
    }

    public synchronized ErrorPageModel[] getErrorPageModels() {
        Collection<ErrorPageModel> models = this.m_errorPageModels.values();
        return models.toArray(new ErrorPageModel[models.size()]);
    }

    public synchronized void addContextModel(ContextModel contextModel) {
        if (!this.m_contextModels.containsKey(contextModel.getHttpContext())) {
            this.m_contextModels.put(contextModel.getHttpContext(), contextModel);
        }
    }

    public synchronized ContextModel[] getContextModels() {
        Collection<ContextModel> contextModels = this.m_contextModels.values();
        if (contextModels == null || contextModels.size() == 0) {
            return new ContextModel[0];
        }
        return contextModels.toArray(new ContextModel[contextModels.size()]);
    }

    public synchronized ContextModel getContextModel(HttpContext httpContext) {
        return this.m_contextModels.get(httpContext);
    }

    public synchronized void addErrorPageModel(ErrorPageModel model) {
        String key = model.getError() + "|" + model.getContextModel().getId();
        if (this.m_errorPageModels.containsKey(key)) {
            throw new IllegalArgumentException("Error page for [" + model.getError() + "] already registered.");
        }
        this.m_errorPageModels.put(key, model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized ErrorPageModel removeErrorPage(String error, ContextModel contextModel) {
        String key = error + "|" + contextModel.getId();
        ErrorPageModel model = this.m_errorPageModels.get(key);
        if (model == null) {
            throw new IllegalArgumentException("Error page for [" + error + "] cannot be found in the provided http context");
        }
        this.m_errorPageModels.remove(key);
        return model;
    }

    public synchronized void addLoginModel(LoginConfigModel model) {
        if (this.m_loginConfigModels.containsKey(model.getRealmName())) {
            throw new IllegalArgumentException("Login Config [" + model.getRealmName() + "] is already registered.");
        }
        this.m_loginConfigModels.put(model.getRealmName(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized LoginConfigModel[] getLoginModels() {
        Collection<LoginConfigModel> loginModels = this.m_loginConfigModels.values();
        return loginModels.toArray(new LoginConfigModel[loginModels.size()]);
    }

    public synchronized void addSecurityConstraintMappingModel(SecurityConstraintMappingModel model) {
        if (this.m_securityConstraintMappingModels.containsKey(model.getConstraintName())) {
            throw new IllegalArgumentException("Security Mapping [" + model.getConstraintName() + "] is already registered.");
        }
        this.m_securityConstraintMappingModels.put(model.getConstraintName(), model);
        this.addContextModel(model.getContextModel());
    }

    public synchronized SecurityConstraintMappingModel[] getSecurityConstraintMappings() {
        Collection<SecurityConstraintMappingModel> collection = this.m_securityConstraintMappingModels.values();
        return collection.toArray(new SecurityConstraintMappingModel[collection.size()]);
    }

    public synchronized void addContainerInitializerModel(ContainerInitializerModel model) {
        if (this.containerInitializers.containsKey(model.getContainerInitializer())) {
            throw new IllegalArgumentException("ServletContainerInitializer " + model.getContainerInitializer() + " already registered");
        }
        this.containerInitializers.put(model.getContainerInitializer(), model);
    }

    public synchronized void removeContainerInitializerModel(ContainerInitializerModel model) {
    }

    public synchronized boolean canBeConfigured(HttpContext httpContext) {
        return this.canBeConfigured(httpContext, this.m_servletModels) && this.canBeConfigured(httpContext, this.m_filterModels.values()) && this.canBeConfigured(httpContext, this.m_eventListenerModels.values()) && this.canBeConfigured(httpContext, this.m_errorPageModels.values()) && this.canBeConfigured(httpContext, this.m_loginConfigModels.values());
    }

    private boolean canBeConfigured(HttpContext httpContext, Collection<? extends Model> models) {
        for (Model model : models) {
            ContextModel contextModel = model.getContextModel();
            HttpContext candidateHttpContext = contextModel.getHttpContext();
            if (!candidateHttpContext.equals(httpContext)) continue;
            return false;
        }
        return true;
    }
}

