/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;

public class ResourceDelegatingBundleClassLoader
extends BundleClassLoader {
    private List<Bundle> bundles;

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles) {
        super(bundles.get(0));
        this.bundles = bundles;
    }

    public ResourceDelegatingBundleClassLoader(List<Bundle> bundles, ClassLoader parent) {
        super(bundles.get(0), parent);
        this.bundles = bundles;
    }

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    public List<Bundle> getBundles() {
        return this.bundles;
    }

    @Override
    protected URL findResource(String name) {
        for (Bundle delegate : this.bundles) {
            try {
                URL resource = delegate.getResource(name);
                if (resource == null) continue;
                return resource;
            }
            catch (IllegalStateException exc) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector resources = new Vector();
        for (Bundle delegate : this.bundles) {
            try {
                Enumeration urls = delegate.getResources(name);
                if (urls == null) continue;
                while (urls.hasMoreElements()) {
                    resources.add(urls.nextElement());
                }
            }
            catch (IllegalStateException exc) {
            }
        }
        return resources.elements();
    }
}

