/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.SessionCookieConfig;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.core.ApplicationFilterRegistration;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.ops4j.pax.web.service.WebContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceContext
extends StandardContext {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceContext.class);
    private WebContainerContext httpContext;
    private final AccessControlContext accessControllerContext;
    private Map<String, Object> contextAttributes = Collections.emptyMap();
    private WsServerContainer sc;

    public HttpServiceContext(Host host, AccessControlContext accessControllerContext) {
        this.accessControllerContext = accessControllerContext;
    }

    public void setHttpContext(WebContainerContext httpContext) {
        this.httpContext = httpContext;
    }

    public void setContextAttributes(Map<String, Object> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ServletApplicationContext(this);
            ((ServletApplicationContext)this.context).setSessionCookieConfig(new HttpServiceSessionCookieConfig());
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
            if (this.sc != null) {
                this.context.setAttribute("javax.websocket.server.ServerContainer", (Object)this.sc);
            }
            for (Map.Entry<String, Object> attribute : this.contextAttributes.entrySet()) {
                this.context.setAttribute(attribute.getKey(), attribute.getValue());
            }
        }
        return super.getServletContext();
    }

    public class ServletApplicationContext
    extends ApplicationContext {
        private SessionCookieConfig sessionCookieConfig;

        public ServletApplicationContext(StandardContext context) {
            super(context);
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            FilterDef filterDef;
            FilterRegistration.Dynamic fr = super.addFilter(filterName, filter);
            if (fr == null && (filterDef = this.getContext().findFilterDef(filterName)) != null) {
                fr = new ApplicationFilterRegistration(filterDef, (Context)this.getContext());
            }
            return fr;
        }

        public String getRealPath(String path) {
            File file;
            String fileName;
            String protocol;
            URL resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting real path: [{}]", (Object)path);
            }
            if ((resource = this.getResource(path)) != null && (protocol = resource.getProtocol()).equals("file") && (fileName = resource.getFile()) != null && (file = new File(fileName)).exists()) {
                String realPath = file.getAbsolutePath();
                LOG.debug("found real path: [{}]", (Object)realPath);
                return realPath;
            }
            return null;
        }

        public URL getResource(String path) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting resource: [" + path + "]");
            }
            URL resource = null;
            try {
                resource = new URL(path);
                LOG.debug("resource: [" + path + "] is already a URL, returning");
                return resource;
            }
            catch (MalformedURLException e) {
                LOG.debug("not a URL or invalid URL: [" + path + "], treating as a file path");
                final String p = path.endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
                try {
                    resource = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                        @Override
                        public URL run() throws Exception {
                            return HttpServiceContext.this.httpContext.getResource(p);
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource: " + resource);
                    }
                    if (resource != null) {
                        return resource;
                    }
                }
                catch (PrivilegedActionException e2) {
                    LOG.warn("Unauthorized access: " + e2.getMessage());
                }
                WebResourceRoot resources = HttpServiceContext.this.getResources();
                if (resources != null) {
                    resource = resources.getResource(path).getURL();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("found resource: " + resource);
                    }
                }
                return resource;
            }
        }

        public InputStream getResourceAsStream(String path) {
            final URL url = this.getResource(path);
            if (url != null) {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                        @Override
                        public InputStream run() throws Exception {
                            try {
                                return url.openStream();
                            }
                            catch (IOException e) {
                                LOG.warn("URL canot be accessed: " + e.getMessage());
                                return null;
                            }
                        }
                    }, HttpServiceContext.this.accessControllerContext);
                }
                catch (PrivilegedActionException e) {
                    LOG.warn("Unauthorized access: " + e.getMessage());
                }
            }
            return null;
        }

        public Set<String> getResourcePaths(final String path) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getting resource paths for : [" + path + "]");
            }
            try {
                Set<String> paths = AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                    @Override
                    public Set<String> run() throws Exception {
                        return HttpServiceContext.this.httpContext.getResourcePaths(path);
                    }
                }, HttpServiceContext.this.accessControllerContext);
                if (paths == null) {
                    return null;
                }
                HashSet<String> slashedPaths = new HashSet<String>();
                for (String foundPath : paths) {
                    if (foundPath == null) continue;
                    if (foundPath.trim().startsWith("/")) {
                        slashedPaths.add(foundPath.trim());
                        continue;
                    }
                    slashedPaths.add("/" + foundPath.trim());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("found resource paths: " + paths);
                }
                return slashedPaths;
            }
            catch (PrivilegedActionException e) {
                LOG.warn("Unauthorized access: " + e.getMessage());
                return null;
            }
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return this.sessionCookieConfig;
        }

        public void setAttribute(String name, Object value) {
            super.setAttribute(name, value);
            if ("javax.websocket.server.ServerContainer".equals(name) && value instanceof WsServerContainer) {
                HttpServiceContext.this.sc = (WsServerContainer)value;
            }
        }

        public void setSessionCookieConfig(SessionCookieConfig sessionCookieConfig) {
            this.sessionCookieConfig = sessionCookieConfig;
        }
    }

    public class HttpServiceSessionCookieConfig
    implements SessionCookieConfig {
        private boolean httpOnly;
        private boolean secure;
        private int maxAge = -1;
        private String comment;
        private String domain;
        private String name;
        private String path;
        private StandardContext context;

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public int getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(int maxAge) {
            this.maxAge = maxAge;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public StandardContext getContext() {
            return this.context;
        }

        public void setContext(StandardContext context) {
            this.context = context;
        }
    }
}

