/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.tomcat.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.pax.web.service.tomcat.internal.InstalledServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerFactory;
import org.ops4j.pax.web.service.tomcat.internal.ServerState;
import org.ops4j.pax.web.service.tomcat.internal.ServerStateFactory;
import org.ops4j.pax.web.service.tomcat.internal.ServerWrapper;

class InitializedServerState
extends InstalledServerState {
    private Configuration configuration;
    private final ServerFactory serverFactory;

    private InitializedServerState(ServerStateFactory serverStateFactory, Configuration configuration, ServerFactory serverFactory) {
        super(serverStateFactory);
        this.configuration = configuration;
        this.serverFactory = serverFactory;
    }

    static InitializedServerState getInstance(ServerStateFactory serverStateFactory, Configuration configuration, ServerFactory serverFactory) {
        return new InitializedServerState(serverStateFactory, configuration, serverFactory);
    }

    @Override
    public ServerState start() {
        ServerWrapper server = this.serverFactory.newServer(this.configuration);
        server.start();
        return this.getServerStateFactory().newActiveState(server, this);
    }

    @Override
    public ServerState configure(Configuration config) {
        this.configuration = config;
        return this;
    }

    @Override
    Collection<String> getSupportedOperations() {
        ArrayList<String> result = new ArrayList<String>(super.getSupportedOperations());
        result.add(this.formatSupportedOperation("start", new Class[0]));
        return result;
    }

    @Override
    public boolean isConfigured() {
        return true;
    }

    @Override
    public ServerState.States getState() {
        return ServerState.States.INITIALIZED;
    }

    @Override
    public Integer getHttpPort() {
        return this.configuration.getHttpPort();
    }

    @Override
    public Integer getHttpSecurePort() {
        return this.configuration.getHttpSecurePort();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }
}

