/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.algebra;

import com.google.inject.Inject;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.DoubleGenotype;
import org.opt4j.operators.algebra.Algebra;
import org.opt4j.operators.algebra.Term;
import org.opt4j.operators.normalize.NormalizeDouble;

public class AlgebraDouble
implements Algebra<DoubleGenotype> {
    protected final NormalizeDouble normalize;

    @Inject
    public AlgebraDouble(NormalizeDouble normalize) {
        this.normalize = normalize;
    }

    @Override
    public DoubleGenotype algebra(Term term, Genotype ... genotypes) {
        int n = genotypes.length;
        assert (n > 0);
        DoubleGenotype[] list = new DoubleGenotype[n];
        for (int i = 0; i < n; ++i) {
            list[i] = (DoubleGenotype)genotypes[i];
        }
        DoubleGenotype offspring = (DoubleGenotype)list[0].newInstance();
        offspring.clear();
        int size = list[0].size();
        double[] values = new double[n];
        for (int j = 0; j < size; ++j) {
            for (int i = 0; i < n; ++i) {
                values[i] = list[i] == null ? 0.0 : (Double)list[i].get(j);
            }
            double result = term.calculate(values);
            offspring.add((Object)result);
        }
        this.normalize.normalize(offspring);
        return offspring;
    }
}

