/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.algebra;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.opt4j.core.Genotype;
import org.opt4j.core.genotype.CompositeGenotype;
import org.opt4j.operators.AbstractGenericOperator;
import org.opt4j.operators.algebra.Algebra;
import org.opt4j.operators.algebra.AlgebraDouble;
import org.opt4j.operators.algebra.Term;

@Singleton
public class AlgebraGenericImplementation
extends AbstractGenericOperator<Algebra<Genotype>, Algebra<?>>
implements Algebra<Genotype> {
    @Inject
    protected AlgebraGenericImplementation() {
        super(AlgebraDouble.class);
    }

    @Override
    public Genotype algebra(Term term, Genotype ... genotypes) {
        Algebra algebra = (Algebra)this.getOperator(genotypes[0]);
        if (algebra == null) {
            return this.algebraComposite(term, genotypes);
        }
        return algebra.algebra(term, genotypes);
    }

    protected CompositeGenotype<?, ?> algebraComposite(Term term, Genotype ... genotypes) {
        int n = genotypes.length;
        ArrayList<CompositeGenotype> composites = new ArrayList<CompositeGenotype>();
        for (int i = 0; i < n; ++i) {
            composites.add((CompositeGenotype)genotypes[i]);
        }
        CompositeGenotype offspring = (CompositeGenotype)((CompositeGenotype)composites.get(0)).newInstance();
        for (Object key : ((CompositeGenotype)composites.get(0)).keySet()) {
            Genotype[] g = new Genotype[n];
            for (int i = 0; i < n; ++i) {
                Genotype genotype;
                g[i] = composites.get(i) == null ? null : (genotype = (Genotype)((CompositeGenotype)composites.get(i)).get(key));
            }
            Genotype value = this.algebra(term, g);
            offspring.put(key, value);
        }
        return offspring;
    }
}

