/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Required;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.crossover.CrossoverBoolean;
import org.opt4j.operators.crossover.CrossoverBooleanRate;
import org.opt4j.operators.crossover.CrossoverBooleanXPoint;
import org.opt4j.operators.crossover.CrossoverDouble;
import org.opt4j.operators.crossover.CrossoverDoubleBLX;
import org.opt4j.operators.crossover.CrossoverDoubleSBX;
import org.opt4j.operators.crossover.CrossoverDoubleUnfairAverage;
import org.opt4j.operators.crossover.CrossoverInteger;
import org.opt4j.operators.crossover.CrossoverIntegerRate;
import org.opt4j.operators.crossover.CrossoverIntegerXPoint;
import org.opt4j.operators.crossover.CrossoverModule;
import org.opt4j.operators.crossover.CrossoverPermutation;
import org.opt4j.operators.crossover.CrossoverPermutationBucket;
import org.opt4j.operators.crossover.CrossoverPermutationOnePoint;

@Info(value="Setting for the basic crossover classOperators for genotype variation.")
public class BasicCrossoverModule
extends CrossoverModule {
    @Info(value="The type of the crossover operator for the Boolean genotype.")
    protected BooleanType booleanType = BooleanType.RATE;
    @Required(property="booleanType", elements={"RATE"})
    @Info(value="The probability for a crossover point.")
    @Constant(value="rate", namespace=CrossoverBooleanRate.class)
    protected double booleanRate = 0.5;
    @Required(property="booleanType", elements={"XPOINT"})
    @Info(value="The number of crossover points.")
    @Constant(value="x", namespace=CrossoverBooleanXPoint.class)
    protected int booleanXPoints = 1;
    @Info(value="The type of the crossover operator for the Double genotype.")
    protected DoubleType doubleType = DoubleType.SBX;
    @Required(property="doubleType", elements={"BLX", "UNFAIR_AVERAGE"})
    protected double alpha = 0.5;
    @Required(property="doubleType", elements={"SBX"})
    @Constant(value="nu", namespace=CrossoverDoubleSBX.class)
    protected double nu = 15.0;
    @Info(value="The type of the crossover operator for the Permutation genotype.")
    protected PermutationType permutationType = PermutationType.ONEPOINT;
    @Required(property="permutationType", elements={"ONEPOINT"})
    @Constant(value="rotation", namespace=CrossoverPermutationOnePoint.class)
    protected boolean rotation = false;
    @Info(value="The type of the crossover operator for the Integer genotype.")
    protected IntegerType integerType = IntegerType.RATE;
    @Required(property="integerType", elements={"RATE"})
    @Info(value="The probability for a crossover point.")
    @Constant(value="rate", namespace=CrossoverIntegerRate.class)
    protected double integerRate = 0.5;
    @Required(property="integerType", elements={"XPOINT"})
    @Info(value="The number of crossover points.")
    @Constant(value="x", namespace=CrossoverIntegerXPoint.class)
    protected int integerXPoints = 1;

    public double getIntegerRate() {
        return this.integerRate;
    }

    public void setIntegerRate(double integerRate) {
        this.integerRate = integerRate;
    }

    public int getIntegerXPoints() {
        return this.integerXPoints;
    }

    public void setIntegerXPoints(int integerXPoint) {
        this.integerXPoints = integerXPoint;
    }

    public IntegerType getIntegerType() {
        return this.integerType;
    }

    public void setIntegerType(IntegerType integerType) {
        this.integerType = integerType;
    }

    public double getBooleanRate() {
        return this.booleanRate;
    }

    public void setBooleanRate(double booleanRate) {
        this.booleanRate = booleanRate;
    }

    public int getBooleanXPoints() {
        return this.booleanXPoints;
    }

    public void setBooleanXPoints(int booleanXPoints) {
        this.booleanXPoints = booleanXPoints;
    }

    public BooleanType getBooleanType() {
        return this.booleanType;
    }

    public void setBooleanType(BooleanType booleanType) {
        this.booleanType = booleanType;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public double getNu() {
        return this.nu;
    }

    public void setNu(double nu) {
        this.nu = nu;
    }

    public DoubleType getDoubleType() {
        return this.doubleType;
    }

    public void setDoubleType(DoubleType doubleType) {
        this.doubleType = doubleType;
    }

    public PermutationType getPermutationType() {
        return this.permutationType;
    }

    public void setPermutationType(PermutationType permutationType) {
        this.permutationType = permutationType;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public void config() {
        switch (this.booleanType) {
            case XPOINT: {
                this.bind(CrossoverBoolean.class).to(CrossoverBooleanXPoint.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(CrossoverBoolean.class).to(CrossoverBooleanRate.class).in(SINGLETON);
            }
        }
        switch (this.integerType) {
            case XPOINT: {
                this.bind(CrossoverInteger.class).to(CrossoverIntegerXPoint.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(CrossoverInteger.class).to(CrossoverIntegerRate.class).in(SINGLETON);
            }
        }
        switch (this.doubleType) {
            case BLX: {
                this.bind(CrossoverDouble.class).to(CrossoverDoubleBLX.class).in(SINGLETON);
                break;
            }
            case UNFAIR_AVERAGE: {
                this.bind(CrossoverDouble.class).to(CrossoverDoubleUnfairAverage.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(CrossoverDouble.class).to(CrossoverDoubleSBX.class).in(SINGLETON);
            }
        }
        switch (this.permutationType) {
            case BUCKET: {
                this.bind(CrossoverPermutation.class).to(CrossoverPermutationBucket.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(CrossoverPermutation.class).to(CrossoverPermutationOnePoint.class).in(SINGLETON);
            }
        }
        this.bindConstant("alpha", CrossoverDoubleBLX.class).to(this.alpha);
        this.bindConstant("alpha", CrossoverDoubleUnfairAverage.class).to(this.alpha);
        this.bindConstant(CrossoverDoubleSBX.Nu.class).to(this.nu);
    }

    public static enum IntegerType {
        RATE,
        XPOINT;

    }

    public static enum PermutationType {
        ONEPOINT,
        BUCKET;

    }

    public static enum DoubleType {
        BLX,
        SBX,
        UNFAIR_AVERAGE;

    }

    public static enum BooleanType {
        RATE,
        XPOINT;

    }
}

