/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import com.google.inject.Inject;
import java.util.Random;
import java.util.TreeSet;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.ListGenotype;
import org.opt4j.operators.crossover.Crossover;
import org.opt4j.operators.crossover.Pair;

public abstract class CrossoverListXPoint<G extends ListGenotype<?>>
implements Crossover<G> {
    protected final int x;
    protected final Random random;

    @Inject
    public CrossoverListXPoint(int x, Rand random) {
        this.x = x;
        this.random = random;
    }

    @Override
    public Pair<G> crossover(G p1, G p2) {
        ListGenotype o1 = (ListGenotype)p1.newInstance();
        ListGenotype o2 = (ListGenotype)p2.newInstance();
        int size = p1.size();
        if (this.x <= 0 || this.x > size - 1) {
            throw new RuntimeException(this.getClass() + " : x is " + this.x + " for binary vector size " + size);
        }
        TreeSet<Integer> points = new TreeSet<Integer>();
        while (points.size() < this.x) {
            points.add(this.random.nextInt(size - 1) + 1);
        }
        int flip = 0;
        boolean select = this.random.nextBoolean();
        for (int i = 0; i < size; ++i) {
            if (i == flip) {
                boolean bl = select = !select;
                if (points.size() > 0) {
                    flip = (Integer)points.first();
                    points.remove(flip);
                }
            }
            if (select) {
                o1.add(p1.get(i));
                o2.add(p2.get(i));
                continue;
            }
            o1.add(p2.get(i));
            o2.add(p1.get(i));
        }
        Pair<ListGenotype> offspring = new Pair<ListGenotype>(o1, o2);
        return offspring;
    }
}

