/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.crossover;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Random;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.PermutationGenotype;
import org.opt4j.operators.crossover.CrossoverPermutation;
import org.opt4j.operators.crossover.Pair;

public class CrossoverPermutationBucket
implements CrossoverPermutation {
    protected final Random random;

    @Inject
    public CrossoverPermutationBucket(Rand random) {
        this.random = random;
    }

    @Override
    public Pair<PermutationGenotype<?>> crossover(PermutationGenotype<?> p1, PermutationGenotype<?> p2) {
        PermutationGenotype o1 = (PermutationGenotype)p1.newInstance();
        PermutationGenotype o2 = (PermutationGenotype)p1.newInstance();
        int size = p1.size();
        assert (size == p2.size()) : "Permutation is undefined for genotypes with different lengths.";
        assert (p1.containsAll(p2)) : "Permutation is undefined for different domains.";
        HashSet<Object> elements = new HashSet<Object>();
        int i = 0;
        int j = 0;
        while (o1.size() != size || o2.size() != size) {
            Object e;
            if (j == size || this.random.nextBoolean() && i < size) {
                e = p1.get(i);
                ++i;
                if (elements.add(e)) {
                    o1.add(e);
                    continue;
                }
                o2.add(e);
                continue;
            }
            e = p2.get(j);
            ++j;
            if (elements.add(e)) {
                o1.add(e);
                continue;
            }
            o2.add(e);
        }
        Pair offspring = new Pair(o1, o2);
        return offspring;
    }
}

