/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operators.mutate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.operators.mutate.MutationRate;

@Singleton
public class AdaptiveMutationRate
implements MutationRate,
IndividualStateListener {
    protected boolean isInit = false;
    protected double rate = 0.0;
    protected final IndividualFactory individualFactory;

    @Inject
    public AdaptiveMutationRate(IndividualFactory individualFactory) {
        this.individualFactory = individualFactory;
    }

    @Inject
    public void init() {
        this.individualFactory.addIndividualStateListener((IndividualStateListener)this);
    }

    @Override
    public double get() {
        return this.rate;
    }

    @Override
    public void set(double value) {
        this.rate = value;
    }

    public synchronized void inidividualStateChanged(Individual individual) {
        if (!this.isInit && individual.getState() != Individual.State.EMPTY) {
            int size = individual.getGenotype().size();
            if (size > 0) {
                this.set(1.0 / (double)individual.getGenotype().size());
            }
            this.individualFactory.removeIndividualStateListener((IndividualStateListener)this);
            this.isInit = true;
        }
    }
}

