/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Parent;
import org.opt4j.optimizers.ea.Coupler;
import org.opt4j.optimizers.ea.CouplerDefault;
import org.opt4j.optimizers.ea.CouplerRandom;
import org.opt4j.optimizers.ea.CouplerUnique;
import org.opt4j.optimizers.ea.EvolutionaryAlgorithmModule;
import org.opt4j.optimizers.ea.MatingModule;

@Parent(value=EvolutionaryAlgorithmModule.class)
@Info(value="Basic strategies to determine couples from the set of parents for a crossover.")
public class BasicMatingModule
extends MatingModule {
    @Info(value="The type of couple operation")
    protected CouplerType type = CouplerType.DEFAULT;

    public CouplerType getType() {
        return this.type;
    }

    public void setType(CouplerType type) {
        this.type = type;
    }

    public void config() {
        switch (this.type) {
            case RANDOM: {
                this.bind(Coupler.class).to(CouplerRandom.class).in(SINGLETON);
                break;
            }
            case UNIQUE: {
                this.bind(Coupler.class).to(CouplerUnique.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(Coupler.class).to(CouplerDefault.class).in(SINGLETON);
            }
        }
    }

    public static enum CouplerType {
        DEFAULT,
        RANDOM,
        UNIQUE;

    }
}

