/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.opt4j.core.Individual;
import org.opt4j.core.common.random.Rand;
import org.opt4j.operators.crossover.Pair;
import org.opt4j.optimizers.ea.Coupler;

public class CouplerUnique
implements Coupler {
    protected final Random random;

    @Inject
    public CouplerUnique(Rand random) {
        this.random = random;
    }

    @Override
    public Collection<Pair<Individual>> getCouples(int size, List<Individual> parents) {
        ArrayList<Pair<Individual>> couples = new ArrayList<Pair<Individual>>();
        HashSet<Individual> set = new HashSet<Individual>(parents);
        ArrayList<Individual> p = new ArrayList<Individual>(set);
        int n = p.size();
        for (int i = 0; i < size; ++i) {
            Individual second;
            Individual first;
            if (n == 1) {
                second = first = (Individual)p.get(0);
            } else {
                int x = this.random.nextInt(n);
                int y = (x + this.random.nextInt(n - 1) + 1) % n;
                first = (Individual)p.get(x);
                second = (Individual)p.get(y);
                assert (first != second) : x + "==" + y;
            }
            Pair pair = new Pair((Object)first, (Object)second);
            couples.add((Pair<Individual>)pair);
        }
        return couples;
    }
}

