/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.ea;

import org.opt4j.core.config.annotations.Ignore;
import org.opt4j.core.config.annotations.Info;
import org.opt4j.core.config.annotations.Order;
import org.opt4j.core.optimizer.MaxIterations;
import org.opt4j.core.optimizer.OptimizerModule;
import org.opt4j.core.start.Constant;
import org.opt4j.optimizers.ea.ConstantCrossoverRate;
import org.opt4j.optimizers.ea.CrossoverRate;
import org.opt4j.optimizers.ea.EvolutionaryAlgorithm;

@Info(value="Multi-Objective Evolutionary Algorithm that performs a Crossover and Mutate for variation and uses a Selector for the environmental selection.")
public class EvolutionaryAlgorithmModule
extends OptimizerModule {
    @Info(value="The number of generations.")
    @Order(value=0)
    @MaxIterations
    protected int generations = 1000;
    @Constant(value="alpha", namespace=EvolutionaryAlgorithm.class)
    @Info(value="The size of the population.")
    @Order(value=1)
    protected int alpha = 100;
    @Constant(value="mu", namespace=EvolutionaryAlgorithm.class)
    @Info(value="The number of parents per generation.")
    @Order(value=2)
    protected int mu = 25;
    @Constant(value="lambda", namespace=EvolutionaryAlgorithm.class)
    @Info(value="The number of offspring per generation.")
    @Order(value=3)
    protected int lambda = 25;
    @Info(value="Performs a crossover operation with this given rate.")
    @Order(value=4)
    @Constant(value="rate", namespace=ConstantCrossoverRate.class)
    protected double crossoverRate = 0.95;
    @Ignore
    protected CrossoverRateType crossoverRateType = CrossoverRateType.CONSTANT;

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getGenerations() {
        return this.generations;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public int getLambda() {
        return this.lambda;
    }

    public void setLambda(int lambda) {
        this.lambda = lambda;
    }

    public int getMu() {
        return this.mu;
    }

    public void setMu(int mu) {
        this.mu = mu;
    }

    public CrossoverRateType getCrossoverRateType() {
        return this.crossoverRateType;
    }

    public void setCrossoverRateType(CrossoverRateType crossoverRateType) {
        this.crossoverRateType = crossoverRateType;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public void config() {
        this.bindIterativeOptimizer(EvolutionaryAlgorithm.class);
        this.bind(CrossoverRate.class).to(ConstantCrossoverRate.class).in(SINGLETON);
    }

    public static enum CrossoverRateType {
        CONSTANT;

    }
}

