/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.mopso;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.Objectives;
import org.opt4j.core.common.archive.Crowding;
import org.opt4j.core.common.archive.CrowdingArchive;
import org.opt4j.core.common.random.Rand;
import org.opt4j.core.genotype.DoubleGenotype;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.IncompatibilityException;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.IterativeOptimizer;
import org.opt4j.core.optimizer.Population;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.start.Constant;
import org.opt4j.operators.algebra.Add;
import org.opt4j.operators.algebra.AlgebraDouble;
import org.opt4j.operators.algebra.Index;
import org.opt4j.operators.algebra.Term;
import org.opt4j.operators.mutate.MutationRate;
import org.opt4j.operators.normalize.NormalizeDouble;
import org.opt4j.optimizers.mopso.MutateDoubleNonUniform;
import org.opt4j.optimizers.mopso.MutateDoubleUniform;
import org.opt4j.optimizers.mopso.Particle;
import org.opt4j.optimizers.mopso.ParticleFactory;
import org.opt4j.optimizers.mopso.VelocityTerm;

public class MOPSO
implements IterativeOptimizer {
    protected final int size;
    protected final Archive leaders;
    protected final ParticleFactory particleFactory;
    protected final AlgebraDouble algebra;
    protected final Random random;
    protected final VelocityTerm velocityTerm;
    protected final Term positionTerm;
    protected final MutateDoubleUniform uniform;
    protected final MutateDoubleUniform nonUniform;
    protected final MutationRate mutationRate;
    private final Population population;
    private final IndividualCompleter completer;

    @Inject
    public MOPSO(Population population, IndividualFactory individualFactory, IndividualCompleter completer, Rand random, MutateDoubleUniform uniform, MutateDoubleNonUniform nonUniform, MutationRate mutationRate, @Constant(value="size", namespace=MOPSO.class) int size, @Constant(value="archiveSize", namespace=MOPSO.class) int archiveSize) {
        this.particleFactory = (ParticleFactory)individualFactory;
        this.leaders = new CrowdingArchive(archiveSize);
        this.random = random;
        this.uniform = uniform;
        this.nonUniform = nonUniform;
        this.mutationRate = mutationRate;
        this.population = population;
        this.completer = completer;
        this.size = size;
        this.algebra = new AlgebraDouble(new NormalizeDouble(){

            public void normalize(DoubleGenotype genotype) {
            }
        });
        Index x = new Index(0);
        Index v = new Index(1);
        this.positionTerm = new Add(new Term[]{x, v});
        this.velocityTerm = new VelocityTerm(random);
    }

    public void initialize() {
    }

    public void next() throws TerminationException {
        if (this.population.isEmpty()) {
            int id = 0;
            while (this.population.size() < this.size) {
                Particle particle = this.particleFactory.create();
                particle.setId(id++);
                Genotype genotype = particle.getGenotype();
                if (!(genotype instanceof DoubleGenotype)) {
                    throw new IncompatibilityException("MOPSO is restricted to " + DoubleGenotype.class + ", current Genotype is: " + genotype.getClass());
                }
                this.population.add((Individual)particle);
            }
        } else {
            this.updateLeaders(this.leaders, this.population);
            Map<Particle, Particle> lead = this.getLeaders(this.leaders, this.population);
            Map<Particle, Particle> next = this.move(this.population, lead);
            this.population.addAll(next.values());
            this.completer.complete((Iterable)this.population);
            this.updatePersonalBest(next);
            this.population.removeAll(next.keySet());
        }
    }

    protected Map<Particle, Particle> move(Population population, Map<Particle, Particle> leaders) {
        HashMap<Particle, Particle> map = new HashMap<Particle, Particle>();
        for (Individual individual : population) {
            Particle particle = (Particle)individual;
            DoubleGenotype position = (DoubleGenotype)particle.getGenotype();
            DoubleGenotype velocity = (DoubleGenotype)particle.getVelocity();
            DoubleGenotype best = (DoubleGenotype)particle.getBest();
            int id = particle.getId();
            DoubleGenotype leader = (DoubleGenotype)leaders.get((Object)particle).getGenotype();
            this.velocityTerm.randomize();
            DoubleGenotype nextVelocity = this.algebra.algebra((Term)this.velocityTerm, new Genotype[]{position, velocity, best, leader});
            DoubleGenotype nextPosition = this.algebra.algebra(this.positionTerm, new Genotype[]{position, nextVelocity});
            for (int k = 0; k < nextPosition.size(); ++k) {
                double value = (Double)nextPosition.get(k);
                double lb = nextPosition.getLowerBound(k);
                double ub = nextPosition.getUpperBound(k);
                if (value < lb) {
                    nextPosition.set(k, (Object)lb);
                    nextVelocity.set(k, (Object)(-((Double)nextVelocity.get(k)).doubleValue()));
                    continue;
                }
                if (!(value > ub)) continue;
                nextPosition.set(k, (Object)ub);
                nextVelocity.set(k, (Object)(-((Double)nextVelocity.get(k)).doubleValue()));
            }
            if (id % 3 == 0) {
                this.uniform.mutate(nextPosition, this.mutationRate.get());
            } else if (id % 3 == 1) {
                this.nonUniform.mutate(nextPosition, this.mutationRate.get());
            }
            Particle p = this.particleFactory.create(id, (Genotype)nextPosition, (Genotype)nextVelocity);
            map.put(particle, p);
        }
        return map;
    }

    protected void updateLeaders(Archive leaders, Population population) {
        leaders.update((Set)population);
    }

    protected void updatePersonalBest(Map<Particle, Particle> next) {
        for (Map.Entry<Particle, Particle> entry : next.entrySet()) {
            Particle current;
            Particle old = entry.getKey();
            if (this.dominates(old, current = entry.getValue())) {
                current.setBest(old.getBest(), old.getBestObjectives());
                continue;
            }
            current.setBest(current.getGenotype(), current.getObjectives());
        }
    }

    protected boolean dominates(Particle old, Particle current) {
        if (old.getBest() == null) {
            return false;
        }
        Objectives oldObjectives = old.getBestObjectives();
        Objectives currentObjectives = current.getObjectives();
        return oldObjectives.dominates(currentObjectives);
    }

    protected Map<Particle, Particle> getLeaders(Archive leaders, Population population) {
        int i;
        HashMap<Particle, Particle> map = new HashMap<Particle, Particle>();
        Crowding crowding = new Crowding();
        Map values = crowding.getDensityValues((Collection)leaders);
        ArrayList l = new ArrayList(leaders);
        ArrayList<Individual> best = new ArrayList<Individual>();
        for (i = 0; i < population.size(); ++i) {
            Individual i1 = (Individual)l.get(this.random.nextInt(l.size()));
            Individual i2 = (Individual)l.get(this.random.nextInt(l.size()));
            if ((Double)values.get(i1) >= (Double)values.get(i2)) {
                best.add(i1);
                continue;
            }
            best.add(i2);
        }
        i = 0;
        for (Individual individual : population) {
            Particle particle = (Particle)individual;
            Particle leader = (Particle)((Object)best.get(i++));
            map.put(particle, leader);
        }
        return map;
    }
}

