/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizers.mopso;

import java.util.Random;
import org.opt4j.core.common.random.Rand;
import org.opt4j.operators.algebra.Add;
import org.opt4j.operators.algebra.Index;
import org.opt4j.operators.algebra.Mult;
import org.opt4j.operators.algebra.Sub;
import org.opt4j.operators.algebra.Term;
import org.opt4j.operators.algebra.Var;

public class VelocityTerm
implements Term {
    protected final Term term;
    protected final Random random;
    protected final Var W = new Var();
    protected final Var C1 = new Var();
    protected final Var C2 = new Var();
    protected final Var r1 = new Var();
    protected final Var r2 = new Var();

    public VelocityTerm(Rand random) {
        this.random = random;
        Index x = new Index(0);
        Index v = new Index(1);
        Index xbest = new Index(2);
        Index xleader = new Index(3);
        Mult m1 = new Mult(new Term[]{this.W, v});
        Mult m2 = new Mult(new Term[]{this.C1, this.r1, new Sub((Term)xbest, (Term)x)});
        Mult m3 = new Mult(new Term[]{this.C2, this.r2, new Sub((Term)xleader, (Term)x)});
        this.term = new Add(new Term[]{m1, m2, m3});
        this.randomize();
    }

    public double calculate(double ... values) {
        return this.term.calculate(values);
    }

    public void randomize() {
        this.W.setValue(this.random.nextDouble() * 0.4 + 0.1);
        this.C1.setValue(this.random.nextDouble() * 0.5 + 1.5);
        this.C2.setValue(this.random.nextDouble() * 0.5 + 1.5);
        this.r1.setValue(this.random.nextDouble());
        this.r2.setValue(this.random.nextDouble());
    }
}

