/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.roster;

import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.openshift.employeerostering.server.common.generator.StringDataGenerator;
import org.optaplanner.openshift.employeerostering.server.rotation.ShiftGenerator;
import org.optaplanner.openshift.employeerostering.shared.employee.Employee;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailability;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailabilityState;
import org.optaplanner.openshift.employeerostering.shared.roster.Roster;
import org.optaplanner.openshift.employeerostering.shared.roster.RosterState;
import org.optaplanner.openshift.employeerostering.shared.rotation.ShiftTemplate;
import org.optaplanner.openshift.employeerostering.shared.shift.Shift;
import org.optaplanner.openshift.employeerostering.shared.skill.Skill;
import org.optaplanner.openshift.employeerostering.shared.spot.Spot;
import org.optaplanner.openshift.employeerostering.shared.tenant.Tenant;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantConfiguration;

@Singleton
@Startup
public class RosterGenerator {
    private final StringDataGenerator tenantNameGenerator = StringDataGenerator.buildLocationNames();
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    private final StringDataGenerator spotNameGenerator = StringDataGenerator.buildAssemblyLineNames();
    private final StringDataGenerator skillNameGenerator = new StringDataGenerator().addPart("Mechanical", "Electrical", "Safety", "Transportation", "Operational", "Physics", "Monitoring", "ICT").addPart("bachelor", "engineer", "instructor", "coordinator", "manager", "expert", "inspector", "analyst");
    private Random random = new Random(37L);
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private ShiftGenerator shiftGenerator;

    public RosterGenerator() {
    }

    public RosterGenerator(EntityManager entityManager, ShiftGenerator shiftGenerator) {
        this.entityManager = entityManager;
        this.shiftGenerator = shiftGenerator;
    }

    @PostConstruct
    public void setUpGeneratedData() {
        this.tenantNameGenerator.predictMaximumSizeAndReset(10);
        this.generateRoster(10, 7, false, false);
        this.generateRoster(10, 28, false, false);
        this.generateRoster(20, 28, false, true);
        this.generateRoster(40, 14, false, false);
        this.generateRoster(80, 28, false, true);
        this.generateRoster(10, 28, true, false);
        this.generateRoster(20, 28, true, true);
        this.generateRoster(40, 14, true, false);
        this.generateRoster(80, 28, true, true);
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays, boolean continuousPlanning, boolean assignDefaultEmployee) {
        int employeeListSize = spotListSize * 7 / 2;
        int skillListSize = (spotListSize + 4) / 5;
        Integer tenantId = this.createTenant(spotListSize, employeeListSize, lengthInDays);
        List<Skill> skillList = this.createSkillList(tenantId, skillListSize);
        List<Spot> spotList = this.createSpotList(tenantId, spotListSize, skillList);
        List<Employee> employeeList = this.createEmployeeList(tenantId, employeeListSize, skillList);
        RosterState rosterState = (RosterState)this.entityManager.createNamedQuery("RosterState.find", RosterState.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
        TenantConfiguration tenantConfiguration = (TenantConfiguration)this.entityManager.createNamedQuery("TenantConfiguration.find", TenantConfiguration.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
        ShiftGenerator.ParserOut parserOutput = this.shiftGenerator.parse(tenantId, tenantConfiguration, rosterState, rosterState.getPublishLength() * 2, this.generateShiftTemplate(tenantId, spotList, employeeList, assignDefaultEmployee));
        for (Shift shift : parserOutput.getShiftOutputList()) {
            this.entityManager.persist((Object)shift);
        }
        for (EmployeeAvailability avaliability : parserOutput.getEmployeeAvailabilityOutputList()) {
            this.entityManager.persist((Object)avaliability);
        }
        this.entityManager.merge((Object)parserOutput.getNewRosterState());
        List<Shift> shiftList = parserOutput.getShiftOutputList();
        List<EmployeeAvailability> employeeAvailabilityList = this.createEmployeeAvailabilityList(tenantId, tenantConfiguration, employeeList, parserOutput.getNewRosterState().getLastHistoricDate(), parserOutput.getNewRosterState().getLastDraftDate());
        return new Roster(Long.valueOf(tenantId.intValue()), tenantId, skillList, spotList, employeeList, employeeAvailabilityList, tenantConfiguration, rosterState, shiftList);
    }

    private static LocalDateTime time(long time) {
        return LocalDateTime.ofEpochSecond(time, 0, ZoneOffset.UTC);
    }

    private static LocalDateTime time(Duration time) {
        return LocalDateTime.ofEpochSecond(time.getSeconds(), 0, ZoneOffset.UTC);
    }

    private static LocalDateTime day(int day) {
        return RosterGenerator.time(Duration.ofDays(day));
    }

    private static LocalDateTime hour(int hour) {
        return RosterGenerator.time(Duration.ofHours(hour));
    }

    private List<ShiftTemplate> generateShiftTemplate(Integer tenantId, List<Spot> spots, List<Employee> employees, boolean assignDefaultEmployee) {
        ArrayList<ShiftTemplate> out = new ArrayList<ShiftTemplate>();
        ArrayList spotSettingList = new ArrayList();
        spots.forEach(s -> spotSettingList.add(new SpotSettings((Spot)s)));
        LocalDateTime startDate = RosterGenerator.time(0L);
        LocalDateTime endDate = LocalDateTime.ofEpochSecond(Duration.ofDays(7L).getSeconds(), 0, ZoneOffset.UTC);
        for (SpotSettings spotInfo : spotSettingList) {
            List<TimeSlotInfo> timeSlotList = this.getTimeSlotsFor(tenantId, spotInfo, startDate, endDate);
            for (TimeSlotInfo timeSlotInfo : timeSlotList) {
                if (!this.hasAtLeastOneShift(spotInfo, timeSlotInfo)) continue;
                List<ShiftTemplate> toAdd = this.createShiftTemplates(tenantId, spotInfo.getSpot(), this.getNumberOfShifts(spotInfo, timeSlotInfo), employees, timeSlotInfo.getStartTime(), timeSlotInfo.getEndTime(), assignDefaultEmployee);
                out.addAll(toAdd);
                toAdd.forEach(s -> this.entityManager.persist(s));
            }
        }
        return out;
    }

    private Employee getRotationEmployee(List<Employee> employeeList, boolean hasRotationEmployee) {
        if (!hasRotationEmployee) {
            return null;
        }
        return employeeList.get(this.random.nextInt(employeeList.size()));
    }

    private int getNumberOfShifts(SpotSettings spotInfo, TimeSlotInfo timeSlotInfo) {
        if (this.isWeekend(timeSlotInfo.getStartTime()) && timeSlotInfo.isNightShift()) {
            return spotInfo.getNumberOfShiftsWeekendNight();
        }
        if (this.isWeekend(timeSlotInfo.getStartTime())) {
            return spotInfo.getNumberOfShiftsWeekend();
        }
        if (timeSlotInfo.isNightShift()) {
            return spotInfo.getNumberOfShiftsNight();
        }
        return spotInfo.getNumberOfShiftsNormal();
    }

    private boolean hasAtLeastOneShift(SpotSettings spotInfo, TimeSlotInfo timeSlotInfo) {
        return this.getNumberOfShifts(spotInfo, timeSlotInfo) > 0;
    }

    private boolean isWeekend(LocalDateTime timeSlot) {
        return timeSlot.isAfter(RosterGenerator.day(5));
    }

    private List<TimeSlotInfo> getTimeSlotsFor(int tenantId, SpotSettings spotSettings, LocalDateTime start, LocalDateTime end) {
        ArrayList<TimeSlotInfo> out = new ArrayList<TimeSlotInfo>();
        Duration duration = Duration.ZERO;
        int i = 0;
        while (duration.compareTo(Duration.between(start, end)) < 0) {
            out.addAll(spotSettings.getTimeSlotPattern().getTimeSlotInfoForOffset(tenantId, i));
            ++i;
            duration = duration.plus(spotSettings.getTimeSlotPattern().getDuration());
        }
        return out;
    }

    private List<ShiftTemplate> createShiftTemplates(int tenantId, Spot spot, int shifts, List<Employee> employeeList, LocalDateTime start, LocalDateTime end, boolean assignDefaultEmployee) {
        ArrayList<ShiftTemplate> out = new ArrayList<ShiftTemplate>(shifts);
        for (int i = 0; i < shifts; ++i) {
            ShiftTemplate shift = new ShiftTemplate();
            shift.setOffsetStartDay(Integer.valueOf((int)Duration.between(RosterGenerator.day(0), start).toDays()));
            shift.setStartTime(start.toLocalTime());
            shift.setOffsetEndDay(Integer.valueOf((int)Duration.between(RosterGenerator.day(0), end).toDays()));
            shift.setEndTime(end.toLocalTime());
            shift.setTenantId(Integer.valueOf(tenantId));
            shift.setSpot(spot);
            shift.setRotationEmployee(this.getRotationEmployee(employeeList, assignDefaultEmployee));
            out.add(shift);
        }
        return out;
    }

    private Integer createTenant(int spotListSize, int employeeListSize, int lengthInDays) {
        Tenant tenant = new Tenant(this.tenantNameGenerator.generateNextValue() + " (" + employeeListSize + " employees, " + spotListSize + "spots)");
        TenantConfiguration configuration = new TenantConfiguration();
        RosterState rosterState = new RosterState();
        rosterState.setDraftLength(Integer.valueOf(0));
        rosterState.setFirstDraftDate(LocalDate.now());
        rosterState.setPublishLength(Integer.valueOf(lengthInDays));
        rosterState.setPublishNotice(Integer.valueOf(lengthInDays));
        rosterState.setRotationLength(Integer.valueOf(7));
        rosterState.setUnplannedRotationOffset(Integer.valueOf(0));
        rosterState.setLastHistoricDate(LocalDate.now());
        this.entityManager.persist((Object)tenant);
        configuration.setTenantId(tenant.getId());
        rosterState.setTenantId(tenant.getId());
        this.entityManager.persist((Object)rosterState);
        this.entityManager.persist((Object)configuration);
        return tenant.getId();
    }

    private List<Skill> createSkillList(Integer tenantId, int size) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(size);
        this.skillNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.skillNameGenerator.generateNextValue();
            Skill skill = new Skill(tenantId, name);
            this.entityManager.persist((Object)skill);
            skillList.add(skill);
        }
        return skillList;
    }

    private List<Spot> createSpotList(Integer tenantId, int size, List<Skill> skillList) {
        ArrayList<Spot> spotList = new ArrayList<Spot>(size);
        this.spotNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.spotNameGenerator.generateNextValue();
            Spot spot = new Spot(tenantId, name, this.extractRandomSubListOfLength(skillList, this.random.nextInt(skillList.size())).stream().collect(Collectors.toSet()));
            this.entityManager.persist((Object)spot);
            spotList.add(spot);
        }
        return spotList;
    }

    private List<Employee> createEmployeeList(Integer tenantId, int size, List<Skill> generalSkillList) {
        ArrayList<Employee> employeeList = new ArrayList<Employee>(size);
        this.employeeNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.employeeNameGenerator.generateNextValue();
            Employee employee = new Employee(tenantId, name);
            employee.setSkillProficiencySet((Set)this.extractRandomSubList(generalSkillList, 1.0).stream().collect(Collectors.toCollection(HashSet::new)));
            this.entityManager.persist((Object)employee);
            employeeList.add(employee);
        }
        return employeeList;
    }

    private List<EmployeeAvailability> createEmployeeAvailabilityList(int tenantId, TenantConfiguration config, List<Employee> employeeList, LocalDate fromDate, LocalDate toDate) {
        ArrayList<LocalDate> datesBetween = new ArrayList<LocalDate>();
        LocalDate currDate = fromDate;
        while (currDate.isBefore(toDate)) {
            datesBetween.add(currDate);
            currDate = currDate.plusDays(1L);
        }
        for (LocalDate date : datesBetween) {
            ArrayList<Employee> employeesListCopy = new ArrayList<Employee>(employeeList);
            ArrayList<Employee> unavailableEmployees = new ArrayList<Employee>(this.extractRandomSubList(employeesListCopy, 0.3));
            employeesListCopy.removeAll(unavailableEmployees);
            ArrayList<Employee> undesiredEmployees = new ArrayList<Employee>(this.extractRandomSubList(employeesListCopy, 0.3));
            employeesListCopy.removeAll(undesiredEmployees);
            ArrayList<Employee> desiredEmployees = new ArrayList<Employee>(this.extractRandomSubList(employeesListCopy, 0.3));
            employeesListCopy.removeAll(desiredEmployees);
            unavailableEmployees.forEach(e -> this.createEmployeeAvailability(tenantId, config, (Employee)e, date, EmployeeAvailabilityState.UNAVAILABLE));
            undesiredEmployees.forEach(e -> this.createEmployeeAvailability(tenantId, config, (Employee)e, date, EmployeeAvailabilityState.UNDESIRED));
            desiredEmployees.forEach(e -> this.createEmployeeAvailability(tenantId, config, (Employee)e, date, EmployeeAvailabilityState.DESIRED));
        }
        return this.entityManager.createNamedQuery("EmployeeAvailability.findAll", EmployeeAvailability.class).setParameter("tenantId", (Object)tenantId).getResultList();
    }

    private void createEmployeeAvailability(int tenantId, TenantConfiguration config, Employee employee, LocalDate date, EmployeeAvailabilityState state) {
        EmployeeAvailability availability = new EmployeeAvailability(Integer.valueOf(tenantId), employee, date, OffsetTime.of(LocalTime.MIN, config.getTimeZone().getRules().getOffset(date.atStartOfDay())), OffsetTime.of(LocalTime.MAX, config.getTimeZone().getRules().getOffset(date.atTime(LocalTime.MAX))));
        availability.setState(state);
        this.entityManager.persist((Object)availability);
    }

    private <E> List<E> extractRandomSubList(List<E> list, double maxRelativeSize) {
        ArrayList<E> subList = new ArrayList<E>(list);
        Collections.shuffle(subList, this.random);
        int size = this.random.nextInt((int)((double)list.size() * maxRelativeSize)) + 1;
        subList.subList(size, subList.size()).clear();
        return subList;
    }

    private <E> List<E> extractRandomSubListOfLength(List<E> list, int length) {
        ArrayList<E> subList = new ArrayList<E>(list);
        Collections.shuffle(subList, this.random);
        subList.subList(length, subList.size()).clear();
        return subList;
    }

    static /* synthetic */ LocalDateTime access$100(int x0) {
        return RosterGenerator.hour(x0);
    }

    static /* synthetic */ LocalDateTime access$200(int x0) {
        return RosterGenerator.day(x0);
    }

    private static enum TimeSlotPattern {
        DAY_AFTERNOON_NIGHT(Duration.ofDays(1L), RosterGenerator.access$100(9), RosterGenerator.access$100(17), RosterGenerator.access$100(16), RosterGenerator.access$100(24), null, RosterGenerator.access$100(22), RosterGenerator.access$200(1).plusHours(6L)),
        DAY(Duration.ofDays(1L), RosterGenerator.access$100(9), RosterGenerator.access$100(17)),
        AFTERNOON(Duration.ofDays(1L), RosterGenerator.access$100(16), RosterGenerator.access$100(24)),
        NIGHT(Duration.ofDays(1L), RosterGenerator.access$100(22), RosterGenerator.access$200(1).plusHours(6L)),
        LONG_DAY(Duration.ofDays(1L), RosterGenerator.access$100(9), RosterGenerator.access$100(24));

        List<TimeSlotInfo> timeSlotInfoList;
        Duration offsetLength;

        private TimeSlotPattern(Duration offsetLength, LocalDateTime ... dateTimes) {
            this.timeSlotInfoList = new ArrayList<TimeSlotInfo>(dateTimes.length);
            this.offsetLength = offsetLength;
            boolean isNightShift = false;
            for (int i = 0; i < dateTimes.length; i += 2) {
                if (null == dateTimes[i]) {
                    ++i;
                    isNightShift = true;
                    continue;
                }
                this.timeSlotInfoList.add(new TimeSlotInfo(dateTimes[i], dateTimes[i + 1], isNightShift));
            }
        }

        public static TimeSlotPattern getRandomTimeSlotPattern(Random random) {
            return TimeSlotPattern.values()[random.nextInt(TimeSlotPattern.values().length)];
        }

        public List<TimeSlotInfo> getTimeSlotInfoForOffset(int tenant, int offset) {
            return this.timeSlotInfoList.stream().map(t -> new TimeSlotInfo(t.getStartTime().plus(this.offsetLength.multipliedBy(offset)), t.getEndTime().plus(this.offsetLength.multipliedBy(offset)), t.isNightShift())).collect(Collectors.toList());
        }

        public Duration getDuration() {
            return this.offsetLength;
        }
    }

    private static final class TimeSlotInfo {
        private final LocalDateTime startTime;
        private final LocalDateTime endTime;
        private final boolean isNightShift;

        public TimeSlotInfo(LocalDateTime startTime, LocalDateTime endTime, boolean isNightShift) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.isNightShift = isNightShift;
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        public LocalDateTime getEndTime() {
            return this.endTime;
        }

        public boolean isNightShift() {
            return this.isNightShift;
        }
    }

    private class SpotSettings {
        private final Spot spot;
        private final TimeSlotPattern timeSlotPattern;
        private final int numberOfShiftsNormal;
        private final int numberOfShiftsNight;
        private final int numberOfShiftsWeekend;
        private final int numberOfShiftsWeekendNight;

        public SpotSettings(Spot spot) {
            this.spot = spot;
            this.timeSlotPattern = TimeSlotPattern.getRandomTimeSlotPattern(RosterGenerator.this.random);
            this.numberOfShiftsNormal = RosterGenerator.this.random.nextInt(3) + 1;
            this.numberOfShiftsNight = RosterGenerator.this.random.nextInt(this.numberOfShiftsNormal + 1);
            this.numberOfShiftsWeekend = RosterGenerator.this.random.nextInt(this.numberOfShiftsNormal + 1);
            this.numberOfShiftsWeekendNight = RosterGenerator.this.random.nextInt(Math.min(this.numberOfShiftsNight + 1, this.numberOfShiftsWeekend + 1));
        }

        public Spot getSpot() {
            return this.spot;
        }

        public TimeSlotPattern getTimeSlotPattern() {
            return this.timeSlotPattern;
        }

        public int getNumberOfShiftsNormal() {
            return this.numberOfShiftsNormal;
        }

        public int getNumberOfShiftsNight() {
            return this.numberOfShiftsNight;
        }

        public int getNumberOfShiftsWeekend() {
            return this.numberOfShiftsWeekend;
        }

        public int getNumberOfShiftsWeekendNight() {
            return this.numberOfShiftsWeekendNight;
        }
    }
}

