/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.roster;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.openshift.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaplanner.openshift.employeerostering.server.rotation.ShiftGenerator;
import org.optaplanner.openshift.employeerostering.server.solver.WannabeSolverManager;
import org.optaplanner.openshift.employeerostering.shared.common.AbstractPersistable;
import org.optaplanner.openshift.employeerostering.shared.employee.Employee;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailability;
import org.optaplanner.openshift.employeerostering.shared.employee.view.EmployeeAvailabilityView;
import org.optaplanner.openshift.employeerostering.shared.roster.Pagination;
import org.optaplanner.openshift.employeerostering.shared.roster.Roster;
import org.optaplanner.openshift.employeerostering.shared.roster.RosterRestService;
import org.optaplanner.openshift.employeerostering.shared.roster.RosterState;
import org.optaplanner.openshift.employeerostering.shared.roster.view.EmployeeRosterView;
import org.optaplanner.openshift.employeerostering.shared.roster.view.SpotRosterView;
import org.optaplanner.openshift.employeerostering.shared.shift.Shift;
import org.optaplanner.openshift.employeerostering.shared.shift.ShiftRestService;
import org.optaplanner.openshift.employeerostering.shared.shift.view.ShiftView;
import org.optaplanner.openshift.employeerostering.shared.skill.Skill;
import org.optaplanner.openshift.employeerostering.shared.spot.Spot;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantConfiguration;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantRestService;

public class RosterRestServiceImpl
extends AbstractRestServiceImpl
implements RosterRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private WannabeSolverManager solverManager;
    @Inject
    private ShiftGenerator shiftGenerator;
    @Inject
    private TenantRestService tenantRestService;
    @Inject
    private ShiftRestService shiftRestService;

    @Transactional
    public SpotRosterView getCurrentSpotRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getFirstPublishedDate();
        LocalDate endDate = rosterState.getLastDraftDate();
        return this.getSpotRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public SpotRosterView getSpotRosterView(Integer tenantId, String startDateString, String endDateString) {
        return this.getSpotRosterView(tenantId, LocalDate.parse(startDateString), LocalDate.parse(endDateString));
    }

    private SpotRosterView getSpotRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List spots = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).setMaxResults(pagination.getNumberOfItemsPerPage().intValue()).setFirstResult(pagination.getFirstResultIndex().intValue()).getResultList();
        return this.getSpotRosterView(tenantId, startDate, endDate, spots);
    }

    private SpotRosterView getSpotRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate) {
        List spots = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        return this.getSpotRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    public SpotRosterView getSpotRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Spot> spots) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (null == spots) {
            throw new IllegalArgumentException("spots is null!");
        }
        return this.getSpotRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    protected SpotRosterView getSpotRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Spot> spotList) {
        SpotRosterView spotRosterView = new SpotRosterView(tenantId, startDate, endDate);
        spotRosterView.setSpotList(spotList);
        List employeeList = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList();
        spotRosterView.setEmployeeList(employeeList);
        List shiftList = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList();
        LinkedHashMap<Long, List> spotIdToShiftViewListMap = new LinkedHashMap<Long, List>(spotList.size());
        HashSet<Spot> spotSet = new HashSet<Spot>(spotList);
        for (Shift shift : shiftList) {
            if (!spotSet.contains(shift.getSpot())) continue;
            spotIdToShiftViewListMap.computeIfAbsent(shift.getSpot().getId(), k -> new ArrayList()).add(new ShiftView(shift));
        }
        spotRosterView.setSpotIdToShiftViewListMap(spotIdToShiftViewListMap);
        spotRosterView.setScore((HardSoftScore)this.solverManager.getRoster(tenantId).map(Roster::getScore).orElse(null));
        spotRosterView.setRosterState(this.getRosterState(tenantId));
        return spotRosterView;
    }

    @Transactional
    public EmployeeRosterView getCurrentEmployeeRosterView(Integer tenantId, Integer pageNumber, Integer numberOfItemsPerPage) {
        RosterState rosterState = this.getRosterState(tenantId);
        LocalDate startDate = rosterState.getLastHistoricDate();
        LocalDate endDate = rosterState.getLastDraftDate();
        return this.getEmployeeRosterView(tenantId, startDate, endDate, Pagination.of((Integer)pageNumber, (Integer)numberOfItemsPerPage));
    }

    @Transactional
    public EmployeeRosterView getEmployeeRosterView(Integer tenantId, String startDateString, String endDateString) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        return this.getEmployeeRosterView(tenantId, startDate, endDate, this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList());
    }

    @Transactional
    public EmployeeRosterView getEmployeeRosterViewFor(Integer tenantId, String startDateString, String endDateString, List<Employee> employees) {
        LocalDate startDate = LocalDate.parse(startDateString);
        LocalDate endDate = LocalDate.parse(endDateString);
        if (null == employees) {
            throw new IllegalArgumentException("employees is null!");
        }
        return this.getEmployeeRosterView(tenantId, startDate, endDate, employees);
    }

    private EmployeeRosterView getEmployeeRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, Pagination pagination) {
        List spots = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).setMaxResults(pagination.getNumberOfItemsPerPage().intValue()).setFirstResult(pagination.getFirstResultIndex().intValue()).getResultList();
        return this.getEmployeeRosterView(tenantId, startDate, endDate, spots);
    }

    @Transactional
    protected EmployeeRosterView getEmployeeRosterView(Integer tenantId, LocalDate startDate, LocalDate endDate, List<Employee> employeeList) {
        EmployeeRosterView employeeRosterView = new EmployeeRosterView(tenantId, startDate, endDate);
        List spotList = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        employeeRosterView.setSpotList(spotList);
        employeeRosterView.setEmployeeList(employeeList);
        List shiftList = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList();
        LinkedHashMap<Long, List> employeeIdToShiftViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        ArrayList<ShiftView> unassignedShiftViewList = new ArrayList<ShiftView>();
        HashSet<Employee> employeeSet = new HashSet<Employee>(employeeList);
        for (Shift shift : shiftList) {
            if (shift.getEmployee() != null) {
                if (!employeeSet.contains(shift.getEmployee())) continue;
                employeeIdToShiftViewListMap.computeIfAbsent(shift.getEmployee().getId(), k -> new ArrayList()).add(new ShiftView(shift));
                continue;
            }
            unassignedShiftViewList.add(new ShiftView(shift));
        }
        employeeRosterView.setEmployeeIdToShiftViewListMap(employeeIdToShiftViewListMap);
        employeeRosterView.setUnassignedShiftViewList(unassignedShiftViewList);
        LinkedHashMap<Long, List> employeeIdToAvailabilityViewListMap = new LinkedHashMap<Long, List>(employeeList.size());
        List employeeAvailabilityList = this.entityManager.createNamedQuery("EmployeeAvailability.findAll", EmployeeAvailability.class).setParameter("tenantId", (Object)tenantId).getResultList();
        for (EmployeeAvailability employeeAvailability : employeeAvailabilityList) {
            if (!employeeSet.contains(employeeAvailability.getEmployee())) continue;
            employeeIdToAvailabilityViewListMap.computeIfAbsent(employeeAvailability.getEmployee().getId(), k -> new ArrayList()).add(new EmployeeAvailabilityView(employeeAvailability));
        }
        employeeRosterView.setEmployeeIdToAvailabilityViewListMap(employeeIdToAvailabilityViewListMap);
        Roster roster = this.solverManager.getRoster(tenantId).orElse(null);
        if (null != roster) {
            employeeRosterView.setScore(roster.getScore());
        }
        employeeRosterView.setRosterState(this.getRosterState(tenantId));
        return employeeRosterView;
    }

    public void solveRoster(Integer tenantId) {
        this.solverManager.solve(tenantId);
    }

    public void terminateRosterEarly(Integer tenantId) {
        this.solverManager.terminate(tenantId);
    }

    @Transactional
    public Roster buildRoster(Integer tenantId) {
        List skillList = this.entityManager.createNamedQuery("Skill.findAll", Skill.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List spotList = this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List employeeList = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List employeeAvailabilityList = this.entityManager.createNamedQuery("EmployeeAvailability.findAll", EmployeeAvailability.class).setParameter("tenantId", (Object)tenantId).getResultList();
        List shiftList = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList();
        return new Roster(Long.valueOf(tenantId.intValue()), tenantId, skillList, spotList, employeeList, employeeAvailabilityList, this.tenantRestService.getTenantConfiguration(tenantId), this.getRosterState(tenantId), shiftList);
    }

    @Transactional
    public void updateShiftsOfRoster(Roster newRoster) {
        Integer tenantId = newRoster.getTenantId();
        Map employeeIdMap = this.entityManager.createNamedQuery("Employee.findAll", Employee.class).setParameter("tenantId", (Object)tenantId).getResultList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        Map shiftIdMap = this.entityManager.createNamedQuery("Shift.findAll", Shift.class).setParameter("tenantId", (Object)tenantId).getResultList().stream().collect(Collectors.toMap(AbstractPersistable::getId, Function.identity()));
        for (Shift shift : newRoster.getShiftList()) {
            Shift attachedShift = (Shift)shiftIdMap.get(shift.getId());
            if (attachedShift == null) continue;
            attachedShift.setEmployee(shift.getEmployee() == null ? null : (Employee)employeeIdMap.get(shift.getEmployee().getId()));
        }
    }

    @Transactional
    public void publishAndProvision(Integer tenantId) {
        RosterState rosterState = this.getRosterState(tenantId);
        this.publish(tenantId, rosterState.getPublishLength());
        this.provision(tenantId, rosterState.getPublishLength());
    }

    @Transactional
    public void publish(Integer tenantId, Integer lengthInDays) {
        RosterState rosterState = this.getRosterState(tenantId);
        rosterState.setFirstDraftDate(rosterState.getFirstDraftDate().plusDays(lengthInDays.intValue()));
        rosterState.setDraftLength(Integer.valueOf(rosterState.getDraftLength() - lengthInDays));
        this.entityManager.merge((Object)rosterState);
    }

    @Transactional
    public List<Long> provision(Integer tenantId, Integer lengthInDays) {
        Collection shiftTemplates = this.shiftRestService.getTemplate(tenantId);
        TenantConfiguration tenantConfiguration = this.tenantRestService.getTenantConfiguration(tenantId);
        ShiftGenerator.ParserOut parserOutput = this.shiftGenerator.parse(tenantId, tenantConfiguration, this.getRosterState(tenantId), lengthInDays, shiftTemplates);
        List<Shift> shifts = parserOutput.getShiftOutputList();
        List<EmployeeAvailability> employeeAvailabilities = parserOutput.getEmployeeAvailabilityOutputList();
        ArrayList<Long> out = new ArrayList<Long>();
        for (Shift shift : shifts) {
            this.entityManager.persist((Object)shift);
            out.add(shift.getId());
        }
        for (EmployeeAvailability availability : employeeAvailabilities) {
            this.entityManager.persist((Object)availability);
        }
        return out;
    }

    public RosterState getRosterState(Integer tenantId) {
        return (RosterState)this.entityManager.createNamedQuery("RosterState.find", RosterState.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
    }
}

