/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.rotation;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailability;
import org.optaplanner.openshift.employeerostering.shared.roster.RosterState;
import org.optaplanner.openshift.employeerostering.shared.rotation.ShiftTemplate;
import org.optaplanner.openshift.employeerostering.shared.shift.Shift;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantConfiguration;

@Singleton
public class ShiftGenerator {
    public ParserOut parse(Integer tenantId, TenantConfiguration tenantConfiguration, RosterState rosterState, int lengthInDays, Collection<ShiftTemplate> shifts) {
        ArrayList<Shift> shiftOutputList = new ArrayList<Shift>();
        LocalDate oldLastDraftDate = rosterState.getLastDraftDate();
        LocalDate newLastDraftDate = oldLastDraftDate.plusDays(lengthInDays);
        LocalDate currDay = oldLastDraftDate.plusDays(1L);
        while (!currDay.isAfter(newLastDraftDate)) {
            List shiftsToAdd = shifts.stream().filter(s -> s.getOffsetStartDay() == rosterState.getUnplannedRotationOffset()).collect(Collectors.toList());
            for (ShiftTemplate shiftTemplate : shiftsToAdd) {
                shiftOutputList.add(shiftTemplate.asShiftOnDate(currDay, tenantConfiguration.getTimeZone()));
            }
            rosterState.setUnplannedRotationOffset(Integer.valueOf((rosterState.getUnplannedRotationOffset() + 1) % rosterState.getRotationLength()));
            currDay = currDay.plusDays(1L);
        }
        rosterState.setDraftLength(Integer.valueOf(rosterState.getDraftLength() + lengthInDays));
        ParserOut out = new ParserOut();
        out.newRosterState = rosterState;
        out.shiftOutputList = shiftOutputList;
        out.employeeAvailabilityOutputList = new ArrayList<EmployeeAvailability>();
        return out;
    }

    public static class ParserOut {
        RosterState newRosterState;
        List<Shift> shiftOutputList;
        List<EmployeeAvailability> employeeAvailabilityOutputList;

        public RosterState getNewRosterState() {
            return this.newRosterState;
        }

        public List<Shift> getShiftOutputList() {
            return this.shiftOutputList;
        }

        public List<EmployeeAvailability> getEmployeeAvailabilityOutputList() {
            return this.employeeAvailabilityOutputList;
        }
    }
}

