/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.shift;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.optaplanner.openshift.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaplanner.openshift.employeerostering.server.rotation.ShiftGenerator;
import org.optaplanner.openshift.employeerostering.shared.common.AbstractPersistable;
import org.optaplanner.openshift.employeerostering.shared.employee.Employee;
import org.optaplanner.openshift.employeerostering.shared.rotation.ShiftTemplate;
import org.optaplanner.openshift.employeerostering.shared.shift.Shift;
import org.optaplanner.openshift.employeerostering.shared.shift.ShiftRestService;
import org.optaplanner.openshift.employeerostering.shared.shift.view.ShiftView;
import org.optaplanner.openshift.employeerostering.shared.spot.Spot;

public class ShiftRestServiceImpl
extends AbstractRestServiceImpl
implements ShiftRestService {
    @PersistenceContext
    private EntityManager entityManager;
    @Inject
    private ShiftGenerator shiftGenerator;

    @Transactional
    public ShiftView getShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.entityManager.find(Shift.class, (Object)id);
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shift);
        return new ShiftView(shift);
    }

    @Transactional
    public Long addShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        this.entityManager.persist((Object)shift);
        return shift.getId();
    }

    @Transactional
    public Shift updateShift(Integer tenantId, ShiftView shiftView) {
        Shift shift = this.convertFromView(tenantId, shiftView);
        return (Shift)this.entityManager.merge((Object)shift);
    }

    private Shift convertFromView(Integer tenantId, ShiftView shiftView) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shiftView);
        Spot spot = (Spot)this.entityManager.find(Spot.class, (Object)shiftView.getSpotId());
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        Long rotationEmployeeId = shiftView.getRotationEmployeeId();
        Employee rotationEmployee = null;
        if (rotationEmployeeId != null) {
            rotationEmployee = (Employee)this.entityManager.find(Employee.class, (Object)rotationEmployeeId);
            if (rotationEmployee == null) {
                throw new IllegalArgumentException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + rotationEmployeeId + ").");
            }
            this.validateTenantIdParameter(tenantId, (AbstractPersistable)rotationEmployee);
        }
        Shift shift = new Shift(shiftView, spot, shiftView.getStartDateTime(), shiftView.getEndDateTime(), rotationEmployee);
        shift.setPinnedByUser(shiftView.isPinnedByUser());
        Long employeeId = shiftView.getEmployeeId();
        if (employeeId != null) {
            Employee employee = (Employee)this.entityManager.find(Employee.class, (Object)employeeId);
            if (employee == null) {
                throw new IllegalArgumentException("ShiftView (" + shiftView + ") has an non-existing employeeId (" + employeeId + ").");
            }
            this.validateTenantIdParameter(tenantId, (AbstractPersistable)employee);
            shift.setEmployee(employee);
        }
        return shift;
    }

    @Transactional
    public Boolean removeShift(Integer tenantId, Long id) {
        Shift shift = (Shift)this.entityManager.find(Shift.class, (Object)id);
        if (shift == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)shift);
        this.entityManager.remove((Object)shift);
        return true;
    }

    public List<ShiftView> getShifts(Integer tenantId) {
        return this.getAllShifts(tenantId).stream().map(s -> new ShiftView(s)).collect(Collectors.toList());
    }

    private List<Shift> getAllShifts(Integer tenantId) {
        TypedQuery q = this.entityManager.createNamedQuery("Shift.findAll", Shift.class);
        q.setParameter("tenantId", (Object)tenantId);
        return q.getResultList();
    }

    public Collection<ShiftTemplate> getTemplate(Integer tenantId) {
        TypedQuery q = this.entityManager.createNamedQuery("ShiftTemplate.findAll", ShiftTemplate.class);
        q.setParameter("tenantId", (Object)tenantId);
        return q.getResultList();
    }

    @Transactional
    public void updateTemplate(Integer tenantId, Collection<ShiftTemplate> shifts) {
        Collection<ShiftTemplate> oldShiftTemplates = this.getTemplate(tenantId);
        oldShiftTemplates.forEach(s -> this.entityManager.remove(s));
        shifts.forEach(s -> this.entityManager.persist(s));
    }
}

