/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.skill;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.openshift.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaplanner.openshift.employeerostering.shared.common.AbstractPersistable;
import org.optaplanner.openshift.employeerostering.shared.skill.Skill;
import org.optaplanner.openshift.employeerostering.shared.skill.SkillRestService;

public class SkillRestServiceImpl
extends AbstractRestServiceImpl
implements SkillRestService {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public List<Skill> getSkillList(Integer tenantId) {
        return this.entityManager.createNamedQuery("Skill.findAll", Skill.class).setParameter("tenantId", (Object)tenantId).getResultList();
    }

    @Transactional
    public Skill getSkill(Integer tenantId, Long id) {
        Skill skill = (Skill)this.entityManager.find(Skill.class, (Object)id);
        if (skill == null) {
            throw new EntityNotFoundException("No Skill entity found with ID (" + id + ").");
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)skill);
        return skill;
    }

    @Transactional
    public Skill addSkill(Integer tenantId, Skill skill) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)skill);
        this.entityManager.persist((Object)skill);
        return skill;
    }

    @Transactional
    public Skill updateSkill(Integer tenantId, Skill skill) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)skill);
        skill = (Skill)this.entityManager.merge((Object)skill);
        return skill;
    }

    @Transactional
    public Boolean removeSkill(Integer tenantId, Long id) {
        Skill skill = (Skill)this.entityManager.find(Skill.class, (Object)id);
        if (skill == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)skill);
        this.entityManager.remove((Object)skill);
        return true;
    }
}

