/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.tenant;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.openshift.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaplanner.openshift.employeerostering.shared.tenant.Tenant;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantConfiguration;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantRestService;

public class TenantRestServiceImpl
extends AbstractRestServiceImpl
implements TenantRestService {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public List<Tenant> getTenantList() {
        return this.entityManager.createNamedQuery("Tenant.findAll", Tenant.class).getResultList();
    }

    @Transactional
    public Tenant getTenant(Integer id) {
        Tenant tenant = (Tenant)this.entityManager.find(Tenant.class, (Object)id);
        return tenant;
    }

    @Transactional
    public Tenant addTenant(Tenant tenant) {
        this.entityManager.persist((Object)tenant);
        return tenant;
    }

    @Transactional
    public TenantConfiguration updateTenantConfiguration(TenantConfiguration tenantConfiguration) {
        return (TenantConfiguration)this.entityManager.merge((Object)tenantConfiguration);
    }

    public TenantConfiguration getTenantConfiguration(Integer tenantId) {
        return (TenantConfiguration)this.entityManager.createNamedQuery("TenantConfiguration.find", TenantConfiguration.class).setParameter("tenantId", (Object)tenantId).getSingleResult();
    }
}

