/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.roster;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.openshift.employeerostering.server.admin.SystemPropertiesRetriever;
import org.optaplanner.openshift.employeerostering.server.common.generator.StringDataGenerator;
import org.optaplanner.openshift.employeerostering.shared.employee.Employee;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailability;
import org.optaplanner.openshift.employeerostering.shared.employee.EmployeeAvailabilityState;
import org.optaplanner.openshift.employeerostering.shared.roster.Roster;
import org.optaplanner.openshift.employeerostering.shared.roster.RosterState;
import org.optaplanner.openshift.employeerostering.shared.rotation.ShiftTemplate;
import org.optaplanner.openshift.employeerostering.shared.shift.Shift;
import org.optaplanner.openshift.employeerostering.shared.skill.Skill;
import org.optaplanner.openshift.employeerostering.shared.spot.Spot;
import org.optaplanner.openshift.employeerostering.shared.tenant.Tenant;
import org.optaplanner.openshift.employeerostering.shared.tenant.TenantConfiguration;

@Singleton
@Startup
public class RosterGenerator {
    private static final double[] EXTRA_SHIFT_THRESHOLDS = new double[]{0.5, 0.8, 0.95};
    private final StringDataGenerator tenantNameGenerator = StringDataGenerator.buildLocationNames();
    private final StringDataGenerator employeeNameGenerator = StringDataGenerator.buildFullNames();
    private final GeneratorType hospitalGeneratorType = new GeneratorType("Hospital", new StringDataGenerator().addPart("Ambulatory care", "Critical care", "Midwife", "Gastroenterology", "Neuroscience", "Oncology", "Pediatric", "Psychiatric", "Geriatric", "Radiology").addPart("nurse", "physician", "doctor", "attendant", "specialist", "surgeon", "medic", "practitioner", "pharmacist", "researcher"), new StringDataGenerator(true).addPart(false, 0, "Basic", "Advanced", "Expert", "Specialized", "Elder", "Child", "Infant", "Baby", "Male", "Female", "Common", "Uncommon", "Research", "Administrative", "Regressing").addPart(true, 1, "anaesthetics", "cardiology", "critical care", "emergency", "ear nose throat", "gastroenterology", "haematology", "maternity", "neurology", "oncology", "ophthalmology", "orthopaedics", "physiotherapy", "radiotherapy", "urology").addPart(false, 0, "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"), Arrays.asList(Pair.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0)), Pair.of((Object)LocalTime.of(9, 0), (Object)LocalTime.of(17, 0)), Pair.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0)), Pair.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0))), 21, 6, (startDayOffset, timeslotRangesIndex) -> {
        switch (timeslotRangesIndex) {
            case 0: {
                return startDayOffset % 7 >= 5 ? 3 : startDayOffset / 7;
            }
            case 1: {
                return (startDayOffset + 2) % 7 < 4 ? 5 : (startDayOffset - 16 + 21) % 21 / 7;
            }
            case 2: {
                return startDayOffset % 7 < 3 ? 3 : 4;
            }
            case 3: {
                return startDayOffset % 7 < 1 ? 4 : (startDayOffset - 8 + 21) % 21 / 7;
            }
        }
        throw new IllegalStateException("Impossible state for timeslotRangesIndex (" + timeslotRangesIndex + ").");
    });
    private final GeneratorType factoryAssemblyGeneratorType = new GeneratorType("Factory assembly", new StringDataGenerator().addPart("Mechanical", "Electrical", "Safety", "Transportation", "Operational", "Physics", "Monitoring", "ICT").addPart("bachelor", "engineer", "instructor", "coordinator", "manager", "expert", "inspector", "analyst"), StringDataGenerator.buildAssemblyLineNames(), Arrays.asList(Pair.of((Object)LocalTime.of(6, 0), (Object)LocalTime.of(14, 0)), Pair.of((Object)LocalTime.of(14, 0), (Object)LocalTime.of(22, 0)), Pair.of((Object)LocalTime.of(22, 0), (Object)LocalTime.of(6, 0))), 28, 4, (startDayOffset, timeslotRangesIndex) -> (startDayOffset - 9 * timeslotRangesIndex + 28) % 28 / 7);
    private final GeneratorType guardSecurityGeneratorType = new GeneratorType("Guard security", new StringDataGenerator().addPart("Martial art", "Armed", "Surveillance", "Technical", "Computer").addPart("basic", "advanced", "expert", "master", "novice"), new StringDataGenerator().addPart("Airport", "Harbor", "Bank", "Office", "Warehouse", "Store", "Factory", "Station", "Museum", "Mansion", "Monument", "City hall", "Prison", "Mine", "Palace").addPart("north gate", "south gate", "east gate", "west gate", "roof", "cellar", "north west gate", "north east gate", "south west gate", "south east gate", "main door", "back door", "side door", "balcony", "patio").addPart("Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu", "Xi", "Omicron"), Arrays.asList(Pair.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(19, 0)), Pair.of((Object)LocalTime.of(19, 0), (Object)LocalTime.of(7, 0))), 21, 3, (startDayOffset, timeslotRangesIndex) -> {
        int offset;
        int n = offset = timeslotRangesIndex == 0 ? startDayOffset : (startDayOffset + 7) % 21;
        return offset < 3 ? 0 : (offset < 7 ? 1 : (offset < 10 ? 2 : (offset < 14 ? 0 : (offset < 17 ? 1 : (offset < 21 ? 2 : -1)))));
    });
    private final GeneratorType callCenterGeneratorType = new GeneratorType("Call center", new StringDataGenerator().addPart("English", "Spanish", "French", "German", "Japanese", "Chinese", "Dutch", "Portuguese", "Italian"), new StringDataGenerator().addPart("Business loans", "Checking and savings accounts", "Debit and credit cards", "Insurances", "Merchant services", "Cash management", "Tax management", "Wealth management", "Mortgages", "Personal loans", "Online payment"), Arrays.asList(Pair.of((Object)LocalTime.of(7, 0), (Object)LocalTime.of(16, 0)), Pair.of((Object)LocalTime.of(11, 0), (Object)LocalTime.of(20, 0))), 7, 3, (startDayOffset, timeslotRangesIndex) -> timeslotRangesIndex == 0 ? (startDayOffset < 1 ? 1 : (startDayOffset < 6 ? 0 : (startDayOffset < 7 ? 1 : -1))) : (startDayOffset < 2 ? 2 : (startDayOffset < 4 ? 1 : (startDayOffset < 7 ? 2 : -1))));
    private Random random;
    @PersistenceContext
    private EntityManager entityManager;

    public RosterGenerator() {
    }

    public RosterGenerator(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @PostConstruct
    public void setUpGeneratedData() {
        ZoneId zoneId = SystemPropertiesRetriever.determineZoneId();
        this.setUpGeneratedData(zoneId);
    }

    public void setUpGeneratedData(ZoneId zoneId) {
        this.random = new Random(37L);
        this.tenantNameGenerator.predictMaximumSizeAndReset(12);
        this.generateRoster(10, 7, this.hospitalGeneratorType, zoneId);
        this.generateRoster(10, 7, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(10, 7, this.guardSecurityGeneratorType, zoneId);
        this.generateRoster(10, 7, this.callCenterGeneratorType, zoneId);
        this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(10, 28, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(20, 28, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(40, 14, this.factoryAssemblyGeneratorType, zoneId);
        this.generateRoster(80, 28, this.factoryAssemblyGeneratorType, zoneId);
    }

    public Roster generateRoster(int spotListSize, int lengthInDays) {
        ZoneId zoneId = SystemPropertiesRetriever.determineZoneId();
        return this.generateRoster(spotListSize, lengthInDays, this.factoryAssemblyGeneratorType, zoneId);
    }

    @Transactional
    public Roster generateRoster(int spotListSize, int lengthInDays, GeneratorType generatorType, ZoneId zoneId) {
        int maxShiftSizePerDay = generatorType.timeslotRangeList.size() + EXTRA_SHIFT_THRESHOLDS.length;
        int employeeListSize = spotListSize * maxShiftSizePerDay * 7 / 5;
        int skillListSize = (spotListSize + 4) / 5;
        Tenant tenant = this.createTenant(generatorType, employeeListSize);
        int tenantId = tenant.getId();
        TenantConfiguration tenantConfiguration = this.createTenantConfiguration(generatorType, tenantId, zoneId);
        RosterState rosterState = this.createRosterState(generatorType, tenantId, lengthInDays);
        List<Skill> skillList = this.createSkillList(generatorType, tenantId, skillListSize);
        List<Spot> spotList = this.createSpotList(generatorType, tenantId, spotListSize, skillList);
        List<Employee> employeeList = this.createEmployeeList(generatorType, tenantId, employeeListSize, skillList);
        List<ShiftTemplate> shiftTemplateList = this.createShiftTemplateList(generatorType, tenantId, rosterState, spotList, employeeList);
        List<Shift> shiftList = this.createShiftList(generatorType, tenantId, tenantConfiguration, rosterState, spotList, shiftTemplateList);
        List<EmployeeAvailability> employeeAvailabilityList = this.createEmployeeAvailabilityList(generatorType, tenantId, tenantConfiguration, rosterState, employeeList, shiftList);
        return new Roster(Long.valueOf(tenantId), Integer.valueOf(tenantId), skillList, spotList, employeeList, employeeAvailabilityList, tenantConfiguration, rosterState, shiftList);
    }

    private Tenant createTenant(GeneratorType generatorType, int employeeListSize) {
        String tenantName = generatorType.tenantNamePrefix + " " + this.tenantNameGenerator.generateNextValue() + " (" + employeeListSize + " employees)";
        Tenant tenant = new Tenant(tenantName);
        this.entityManager.persist((Object)tenant);
        return tenant;
    }

    private TenantConfiguration createTenantConfiguration(GeneratorType generatorType, Integer tenantId, ZoneId zoneId) {
        TenantConfiguration tenantConfiguration = new TenantConfiguration();
        tenantConfiguration.setTenantId(tenantId);
        tenantConfiguration.setTimeZone(zoneId);
        this.entityManager.persist((Object)tenantConfiguration);
        return tenantConfiguration;
    }

    private RosterState createRosterState(GeneratorType generatorType, Integer tenantId, int lengthInDays) {
        RosterState rosterState = new RosterState();
        rosterState.setTenantId(tenantId);
        int publishNotice = 14;
        rosterState.setPublishNotice(Integer.valueOf(publishNotice));
        LocalDate firstDraftDate = LocalDate.now().with(TemporalAdjusters.next(DayOfWeek.MONDAY)).plusDays(publishNotice);
        rosterState.setFirstDraftDate(firstDraftDate);
        rosterState.setPublishLength(Integer.valueOf(7));
        rosterState.setDraftLength(Integer.valueOf(14));
        rosterState.setUnplannedRotationOffset(Integer.valueOf(0));
        rosterState.setRotationLength(Integer.valueOf(generatorType.rotationLength));
        rosterState.setLastHistoricDate(LocalDate.now().minusDays(1L));
        this.entityManager.persist((Object)rosterState);
        return rosterState;
    }

    private List<Skill> createSkillList(GeneratorType generatorType, Integer tenantId, int size) {
        ArrayList<Skill> skillList = new ArrayList<Skill>(size);
        generatorType.skillNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.skillNameGenerator.generateNextValue();
            Skill skill = new Skill(tenantId, name);
            this.entityManager.persist((Object)skill);
            skillList.add(skill);
        }
        return skillList;
    }

    private List<Spot> createSpotList(GeneratorType generatorType, Integer tenantId, int size, List<Skill> skillList) {
        ArrayList<Spot> spotList = new ArrayList<Spot>(size);
        generatorType.spotNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = generatorType.spotNameGenerator.generateNextValue();
            HashSet<Skill> requiredSkillSet = new HashSet<Skill>(this.extractRandomSubList(skillList, 0.5, 0.9, 1.0));
            Spot spot = new Spot(tenantId, name, requiredSkillSet);
            this.entityManager.persist((Object)spot);
            spotList.add(spot);
        }
        return spotList;
    }

    private List<Employee> createEmployeeList(GeneratorType generatorType, Integer tenantId, int size, List<Skill> generalSkillList) {
        ArrayList<Employee> employeeList = new ArrayList<Employee>(size);
        this.employeeNameGenerator.predictMaximumSizeAndReset(size);
        for (int i = 0; i < size; ++i) {
            String name = this.employeeNameGenerator.generateNextValue();
            HashSet<Skill> skillProficiencySet = new HashSet<Skill>(this.extractRandomSubList(generalSkillList, 0.1, 0.3, 0.5, 0.7, 0.9, 1.0));
            Employee employee = new Employee(tenantId, name);
            employee.setSkillProficiencySet(skillProficiencySet);
            this.entityManager.persist((Object)employee);
            employeeList.add(employee);
        }
        return employeeList;
    }

    private List<ShiftTemplate> createShiftTemplateList(GeneratorType generatorType, Integer tenantId, RosterState rosterState, List<Spot> spotList, List<Employee> employeeList) {
        int rotationLength = rosterState.getRotationLength();
        ArrayList<ShiftTemplate> shiftTemplateList = new ArrayList<ShiftTemplate>(spotList.size() * rotationLength * generatorType.timeslotRangeList.size());
        ArrayList<Employee> remainingEmployeeList = new ArrayList<Employee>(employeeList);
        for (Spot spot : spotList) {
            List rotationEmployeeList = remainingEmployeeList.stream().filter(employee -> employee.getSkillProficiencySet().containsAll(spot.getRequiredSkillSet())).limit(generatorType.rotationEmployeeListSize).collect(Collectors.toList());
            remainingEmployeeList.removeAll(rotationEmployeeList);
            for (int startDayOffset = 0; startDayOffset < rotationLength; ++startDayOffset) {
                for (int timeslotRangesIndex = 0; timeslotRangesIndex < generatorType.timeslotRangeList.size(); ++timeslotRangesIndex) {
                    int rotationEmployeeIndex;
                    Pair timeslotRange = (Pair)generatorType.timeslotRangeList.get(timeslotRangesIndex);
                    LocalTime startTime = (LocalTime)timeslotRange.getLeft();
                    LocalTime endTime = (LocalTime)timeslotRange.getRight();
                    int endDayOffset = startDayOffset;
                    if (endTime.compareTo(startTime) < 0) {
                        endDayOffset = (startDayOffset + 1) % rotationLength;
                    }
                    if ((rotationEmployeeIndex = ((Integer)generatorType.rotationEmployeeIndexCalculator.apply(startDayOffset, timeslotRangesIndex)).intValue()) < 0 || rotationEmployeeIndex >= generatorType.rotationEmployeeListSize) {
                        throw new IllegalStateException("The rotationEmployeeIndexCalculator for generatorType (" + generatorType.tenantNamePrefix + ") returns an invalid rotationEmployeeIndex (" + rotationEmployeeIndex + ") for startDayOffset (" + startDayOffset + ") and timeslotRangesIndex (" + timeslotRangesIndex + ").");
                    }
                    Employee rotationEmployee = rotationEmployeeIndex >= rotationEmployeeList.size() ? null : (Employee)rotationEmployeeList.get(rotationEmployeeIndex);
                    ShiftTemplate shiftTemplate = new ShiftTemplate(tenantId, spot, startDayOffset, startTime, endDayOffset, endTime, rotationEmployee);
                    this.entityManager.persist((Object)shiftTemplate);
                    shiftTemplateList.add(shiftTemplate);
                }
            }
        }
        return shiftTemplateList;
    }

    private List<Shift> createShiftList(GeneratorType generatorType, Integer tenantId, TenantConfiguration tenantConfiguration, RosterState rosterState, List<Spot> spotList, List<ShiftTemplate> shiftTemplateList) {
        ZoneId zoneId = tenantConfiguration.getTimeZone();
        int rotationLength = rosterState.getRotationLength();
        LocalDate date = rosterState.getLastHistoricDate().with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate firstDraftDate = rosterState.getFirstDraftDate();
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<Shift> shiftList = new ArrayList<Shift>();
        Map<Pair, List<ShiftTemplate>> dayOffsetAndSpotToShiftTemplateListMap = shiftTemplateList.stream().collect(Collectors.groupingBy(shiftTemplate -> Pair.of((Object)shiftTemplate.getStartDayOffset(), (Object)shiftTemplate.getSpot())));
        int dayOffset = 0;
        while (date.compareTo(firstUnplannedDate) < 0) {
            for (Spot spot : spotList) {
                Shift shift;
                List<ShiftTemplate> subShiftTemplateList = dayOffsetAndSpotToShiftTemplateListMap.get(Pair.of((Object)dayOffset, (Object)spot));
                for (ShiftTemplate shiftTemplate2 : subShiftTemplateList) {
                    boolean defaultToRotationEmployee = date.compareTo(firstDraftDate) < 0;
                    shift = shiftTemplate2.createShiftOnDate(date, rosterState.getRotationLength().intValue(), zoneId, defaultToRotationEmployee);
                    this.entityManager.persist((Object)shift);
                    shiftList.add(shift);
                }
                if (date.compareTo(firstDraftDate) < 0) continue;
                int extraShiftCount = this.generateRandomIntFromThresholds(EXTRA_SHIFT_THRESHOLDS);
                for (int i = 0; i < extraShiftCount; ++i) {
                    ShiftTemplate shiftTemplate3 = this.extractRandomElement(subShiftTemplateList);
                    shift = shiftTemplate3.createShiftOnDate(date, rosterState.getRotationLength().intValue(), zoneId, false);
                    this.entityManager.persist((Object)shift);
                    shiftList.add(shift);
                }
            }
            date = date.plusDays(1L);
            dayOffset = (dayOffset + 1) % rotationLength;
        }
        rosterState.setUnplannedRotationOffset(Integer.valueOf(dayOffset));
        return shiftList;
    }

    private List<EmployeeAvailability> createEmployeeAvailabilityList(GeneratorType generatorType, Integer tenantId, TenantConfiguration tenantConfiguration, RosterState rosterState, List<Employee> employeeList, List<Shift> shiftList) {
        ZoneId zoneId = tenantConfiguration.getTimeZone();
        LocalDate date = rosterState.getFirstDraftDate().plusDays(1L);
        LocalDate firstUnplannedDate = rosterState.getFirstUnplannedDate();
        ArrayList<EmployeeAvailability> employeeAvailabilityList = new ArrayList<EmployeeAvailability>();
        Map<LocalDate, List<Shift>> startDayToShiftListMap = shiftList.stream().collect(Collectors.groupingBy(shift -> shift.getStartDateTime().toLocalDate()));
        while (date.compareTo(firstUnplannedDate) < 0) {
            List<Shift> dayShiftList = startDayToShiftListMap.get(date);
            ArrayList<Employee> availableEmployeeList = new ArrayList<Employee>(employeeList);
            int stateCount = (employeeList.size() - dayShiftList.size()) / 4;
            if (stateCount <= 0) {
                stateCount = 1;
            }
            for (EmployeeAvailabilityState state : EmployeeAvailabilityState.values()) {
                for (int i = 0; i < stateCount; ++i) {
                    Employee employee = (Employee)availableEmployeeList.remove(this.random.nextInt(availableEmployeeList.size()));
                    LocalDateTime startDateTime = date.atTime(LocalTime.MIN);
                    LocalDateTime endDateTime = date.plusDays(1L).atTime(LocalTime.MIN);
                    OffsetDateTime startOffsetDateTime = OffsetDateTime.of(startDateTime, zoneId.getRules().getOffset(startDateTime));
                    OffsetDateTime endOffsetDateTime = OffsetDateTime.of(endDateTime, zoneId.getRules().getOffset(endDateTime));
                    EmployeeAvailability employeeAvailability = new EmployeeAvailability(tenantId, employee, startOffsetDateTime, endOffsetDateTime);
                    employeeAvailability.setState(state);
                    this.entityManager.persist((Object)employeeAvailability);
                    employeeAvailabilityList.add(employeeAvailability);
                }
            }
            date = date.plusDays(1L);
        }
        return employeeAvailabilityList;
    }

    private <E> E extractRandomElement(List<E> list) {
        return list.get(this.random.nextInt(list.size()));
    }

    private <E> List<E> extractRandomSubList(List<E> list, double ... thresholds) {
        int size = this.generateRandomIntFromThresholds(thresholds);
        if (size > list.size()) {
            size = list.size();
        }
        return this.extractRandomSubListOfSize(list, size);
    }

    private <E> List<E> extractRandomSubListOfSize(List<E> list, int size) {
        ArrayList<E> subList = new ArrayList<E>(list);
        Collections.shuffle(subList, this.random);
        subList.subList(size, subList.size()).clear();
        return subList;
    }

    private int generateRandomIntFromThresholds(double ... thresholds) {
        double randomDouble = this.random.nextDouble();
        for (int i = 0; i < thresholds.length; ++i) {
            if (!(randomDouble < thresholds[i])) continue;
            return i;
        }
        return thresholds.length;
    }

    private static class GeneratorType {
        private final String tenantNamePrefix;
        private final StringDataGenerator skillNameGenerator;
        private final StringDataGenerator spotNameGenerator;
        private final List<Pair<LocalTime, LocalTime>> timeslotRangeList;
        private final int rotationLength;
        private final int rotationEmployeeListSize;
        private final BiFunction<Integer, Integer, Integer> rotationEmployeeIndexCalculator;

        public GeneratorType(String tenantNamePrefix, StringDataGenerator skillNameGenerator, StringDataGenerator spotNameGenerator, List<Pair<LocalTime, LocalTime>> timeslotRangeList, int rotationLength, int rotationEmployeeListSize, BiFunction<Integer, Integer, Integer> rotationEmployeeIndexCalculator) {
            this.tenantNamePrefix = tenantNamePrefix;
            this.skillNameGenerator = skillNameGenerator;
            this.spotNameGenerator = spotNameGenerator;
            this.timeslotRangeList = timeslotRangeList;
            this.rotationLength = rotationLength;
            this.rotationEmployeeListSize = rotationEmployeeListSize;
            this.rotationEmployeeIndexCalculator = rotationEmployeeIndexCalculator;
        }
    }
}

