/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.openshift.employeerostering.server.spot;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.Transactional;
import org.optaplanner.openshift.employeerostering.server.common.AbstractRestServiceImpl;
import org.optaplanner.openshift.employeerostering.shared.common.AbstractPersistable;
import org.optaplanner.openshift.employeerostering.shared.spot.Spot;
import org.optaplanner.openshift.employeerostering.shared.spot.SpotRestService;

public class SpotRestServiceImpl
extends AbstractRestServiceImpl
implements SpotRestService {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public List<Spot> getSpotList(Integer tenantId) {
        return this.entityManager.createNamedQuery("Spot.findAll", Spot.class).setParameter("tenantId", (Object)tenantId).getResultList();
    }

    @Transactional
    public Spot getSpot(Integer tenantId, Long id) {
        Spot spot = (Spot)this.entityManager.find(Spot.class, (Object)id);
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        return spot;
    }

    @Transactional
    public Spot addSpot(Integer tenantId, Spot spot) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        this.entityManager.persist((Object)spot);
        return spot;
    }

    @Transactional
    public Spot updateSpot(Integer tenantId, Spot spot) {
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        spot = (Spot)this.entityManager.merge((Object)spot);
        return spot;
    }

    @Transactional
    public Boolean removeSpot(Integer tenantId, Long id) {
        Spot spot = (Spot)this.entityManager.find(Spot.class, (Object)id);
        if (spot == null) {
            return false;
        }
        this.validateTenantIdParameter(tenantId, (AbstractPersistable)spot);
        this.entityManager.remove((Object)spot);
        return true;
    }
}

