/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestsolutionmutation;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.io.File;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SingleBenchmark;
import org.optaplanner.benchmark.impl.statistic.AbstractProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.MillisecondsSpendNumberFormat;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationSingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationSingleStatisticPoint;

public class BestSolutionMutationProblemStatistic
extends AbstractProblemStatistic {
    protected File graphStatisticFile = null;

    public BestSolutionMutationProblemStatistic(ProblemBenchmark problemBenchmark) {
        super(problemBenchmark, ProblemStatisticType.BEST_SOLUTION_MUTATION);
    }

    @Override
    public SingleStatistic createSingleStatistic() {
        return new BestSolutionMutationSingleStatistic();
    }

    public String getGraphFilePath() {
        return this.toFilePath(this.graphStatisticFile);
    }

    @Override
    protected void writeCsvStatistic() {
        AbstractProblemStatistic.ProblemStatisticCsv csv = new AbstractProblemStatistic.ProblemStatisticCsv();
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            if (singleBenchmark.isSuccess()) {
                BestSolutionMutationSingleStatistic singleStatistic = (BestSolutionMutationSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (BestSolutionMutationSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    csv.addPoint(singleBenchmark, timeMillisSpend, point.getMutationCount());
                }
                continue;
            }
            csv.addPoint(singleBenchmark, 0L, "Failed");
        }
        this.csvStatisticFile = new File(this.problemBenchmark.getProblemReportDirectory(), this.problemBenchmark.getName() + "BestSolutionMutationStatistic.csv");
        csv.writeCsvStatisticFile();
    }

    @Override
    protected void writeGraphStatistic() {
        Locale locale = this.problemBenchmark.getPlannerBenchmark().getBenchmarkReport().getLocale();
        NumberAxis xAxis = new NumberAxis("Time spend");
        xAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(locale));
        NumberAxis yAxis = new NumberAxis("Best solution mutation count");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(locale));
        yAxis.setAutoRangeIncludesZero(true);
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        plot.setOrientation(PlotOrientation.VERTICAL);
        int seriesIndex = 0;
        for (SingleBenchmark singleBenchmark : this.problemBenchmark.getSingleBenchmarkList()) {
            XYSeries series = new XYSeries((Comparable)((Object)singleBenchmark.getSolverBenchmark().getNameWithFavoriteSuffix()));
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            if (singleBenchmark.isSuccess()) {
                BestSolutionMutationSingleStatistic singleStatistic = (BestSolutionMutationSingleStatistic)singleBenchmark.getSingleStatistic(this.problemStatisticType);
                for (BestSolutionMutationSingleStatisticPoint point : singleStatistic.getPointList()) {
                    long timeMillisSpend = point.getTimeMillisSpend();
                    long mutationCount = point.getMutationCount();
                    series.add((double)timeMillisSpend, (double)mutationCount);
                }
            }
            plot.setDataset(seriesIndex, (XYDataset)new XYSeriesCollection(series));
            if (singleBenchmark.getSolverBenchmark().isFavorite()) {
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        JFreeChart chart = new JFreeChart(this.problemBenchmark.getName() + " best solution mutation statistic", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.graphStatisticFile = this.writeChartToImageFile(chart, this.problemBenchmark.getName() + "BestSolutionMutationStatistic");
    }
}

