/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.optaplanner.benchmark.impl.ProblemBenchmark;
import org.optaplanner.benchmark.impl.SolverBenchmark;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.statistic.ProblemStatistic;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.StatisticType;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.domain.solution.SolutionDescriptor;
import org.optaplanner.core.impl.solution.Solution;
import org.optaplanner.core.impl.solver.DefaultSolver;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBenchmark
implements Callable<SingleBenchmark> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SolverBenchmark solverBenchmark;
    private final ProblemBenchmark problemBenchmark;
    private Map<StatisticType, SingleStatistic> singleStatisticMap = new HashMap<StatisticType, SingleStatistic>();
    private Integer planningEntityCount = null;
    private Long usedMemoryAfterInputSolution = null;
    private Score score = null;
    private Score winningScoreDifference = null;
    private ScoreDifferencePercentage worstScoreDifferencePercentage = null;
    private long timeMillisSpend = -1L;
    private long calculateCount = -1L;
    private Integer ranking = null;
    private Boolean succeeded = null;
    private Throwable failureThrowable = null;

    public SingleBenchmark(SolverBenchmark solverBenchmark, ProblemBenchmark problemBenchmark) {
        this.solverBenchmark = solverBenchmark;
        this.problemBenchmark = problemBenchmark;
    }

    public SolverBenchmark getSolverBenchmark() {
        return this.solverBenchmark;
    }

    public ProblemBenchmark getProblemBenchmark() {
        return this.problemBenchmark;
    }

    public Integer getPlanningEntityCount() {
        return this.planningEntityCount;
    }

    public Long getUsedMemoryAfterInputSolution() {
        return this.usedMemoryAfterInputSolution;
    }

    public Score getScore() {
        return this.score;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public Score getWinningScoreDifference() {
        return this.winningScoreDifference;
    }

    public void setWinningScoreDifference(Score winningScoreDifference) {
        this.winningScoreDifference = winningScoreDifference;
    }

    public ScoreDifferencePercentage getWorstScoreDifferencePercentage() {
        return this.worstScoreDifferencePercentage;
    }

    public void setWorstScoreDifferencePercentage(ScoreDifferencePercentage worstScoreDifferencePercentage) {
        this.worstScoreDifferencePercentage = worstScoreDifferencePercentage;
    }

    public long getTimeMillisSpend() {
        return this.timeMillisSpend;
    }

    public long getCalculateCount() {
        return this.calculateCount;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public Boolean getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Boolean succeeded) {
        this.succeeded = succeeded;
    }

    public Throwable getFailureThrowable() {
        return this.failureThrowable;
    }

    public void setFailureThrowable(Throwable failureThrowable) {
        this.failureThrowable = failureThrowable;
    }

    public String getName() {
        return this.problemBenchmark.getName() + "_" + this.solverBenchmark.getName();
    }

    @Override
    public SingleBenchmark call() {
        Runtime runtime = Runtime.getRuntime();
        Solution inputSolution = this.problemBenchmark.readPlanningProblem();
        if (!this.problemBenchmark.getPlannerBenchmark().hasMultipleParallelBenchmarks()) {
            runtime.gc();
            this.usedMemoryAfterInputSolution = runtime.totalMemory() - runtime.freeMemory();
        }
        this.logger.trace("Benchmark inputSolution has been read for singleBenchmark ({}_{}).", (Object)this.problemBenchmark.getName(), (Object)this.solverBenchmark.getName());
        Solver solver = this.solverBenchmark.getSolverConfig().buildSolver();
        for (ProblemStatistic problemStatistic : this.problemBenchmark.getProblemStatisticList()) {
            SingleStatistic singleStatistic = problemStatistic.createSingleStatistic();
            singleStatistic.open(solver);
            this.singleStatisticMap.put(problemStatistic.getProblemStatisticType(), singleStatistic);
        }
        solver.setPlanningProblem(inputSolution);
        solver.solve();
        Solution outputSolution = solver.getBestSolution();
        this.timeMillisSpend = solver.getTimeMillisSpend();
        DefaultSolverScope solverScope = ((DefaultSolver)solver).getSolverScope();
        this.calculateCount = solverScope.getCalculateCount();
        this.score = outputSolution.getScore();
        SolutionDescriptor solutionDescriptor = ((DefaultSolver)solver).getSolutionDescriptor();
        this.planningEntityCount = solutionDescriptor.getEntityCount(outputSolution);
        this.problemBenchmark.registerProblemScale(solutionDescriptor.getProblemScale(outputSolution));
        for (SingleStatistic singleStatistic : this.singleStatisticMap.values()) {
            singleStatistic.close(solver);
        }
        this.problemBenchmark.writeOutputSolution(this, outputSolution);
        return this;
    }

    public boolean isSuccess() {
        return this.succeeded != null && this.succeeded != false;
    }

    public boolean isFailure() {
        return this.succeeded != null && this.succeeded == false;
    }

    public boolean isScoreFeasible() {
        if (this.score instanceof FeasibilityScore) {
            return ((FeasibilityScore)this.score).isFeasible();
        }
        return true;
    }

    public Long getAverageCalculateCountPerSecond() {
        long timeMillisSpend = this.timeMillisSpend;
        if (timeMillisSpend == 0L) {
            timeMillisSpend = 1L;
        }
        return this.calculateCount * 1000L / timeMillisSpend;
    }

    public boolean isWinner() {
        return this.ranking != null && this.ranking == 0;
    }

    public SingleStatistic getSingleStatistic(StatisticType statisticType) {
        return this.singleStatisticMap.get(statisticType);
    }

    public String toString() {
        return this.getName();
    }
}

