/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.result;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.optaplanner.benchmark.impl.measurement.ScoreDifferencePercentage;
import org.optaplanner.benchmark.impl.report.BenchmarkReport;
import org.optaplanner.benchmark.impl.report.ReportHelper;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.ProblemBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.XmlSolverFactory;
import org.optaplanner.core.impl.score.ScoreUtils;

@XStreamAlias(value="solverBenchmarkResult")
public class SolverBenchmarkResult {
    @XStreamOmitField
    private PlannerBenchmarkResult plannerBenchmarkResult;
    private String name = null;
    private SolverConfig solverConfig = null;
    @XStreamImplicit(itemFieldName="singleBenchmarkResult")
    private List<SingleBenchmarkResult> singleBenchmarkResultList = null;
    private Integer failureCount = null;
    private Score totalScore = null;
    private Score averageScore = null;
    private double[] standardDeviationDoubles = null;
    private Score totalWinningScoreDifference = null;
    private ScoreDifferencePercentage averageWorstScoreDifferencePercentage = null;
    private Long averageAverageCalculateCountPerSecond = null;
    private Long averageTimeMillisSpent = null;
    private Integer ranking = null;

    public SolverBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public PlannerBenchmarkResult getPlannerBenchmarkResult() {
        return this.plannerBenchmarkResult;
    }

    public void setPlannerBenchmarkResult(PlannerBenchmarkResult plannerBenchmarkResult) {
        this.plannerBenchmarkResult = plannerBenchmarkResult;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SolverConfig getSolverConfig() {
        return this.solverConfig;
    }

    public void setSolverConfig(SolverConfig solverConfig) {
        this.solverConfig = solverConfig;
    }

    public List<SingleBenchmarkResult> getSingleBenchmarkResultList() {
        return this.singleBenchmarkResultList;
    }

    public void setSingleBenchmarkResultList(List<SingleBenchmarkResult> singleBenchmarkResultList) {
        this.singleBenchmarkResultList = singleBenchmarkResultList;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public Score getTotalScore() {
        return this.totalScore;
    }

    public Score getAverageScore() {
        return this.averageScore;
    }

    public Score getTotalWinningScoreDifference() {
        return this.totalWinningScoreDifference;
    }

    public ScoreDifferencePercentage getAverageWorstScoreDifferencePercentage() {
        return this.averageWorstScoreDifferencePercentage;
    }

    public Long getAverageAverageCalculateCountPerSecond() {
        return this.averageAverageCalculateCountPerSecond;
    }

    public Long getAverageTimeMillisSpent() {
        return this.averageTimeMillisSpent;
    }

    public Integer getRanking() {
        return this.ranking;
    }

    public void setRanking(Integer ranking) {
        this.ranking = ranking;
    }

    public String getAnchorId() {
        return ReportHelper.escapeHtmlId(this.name);
    }

    public String getNameWithFavoriteSuffix() {
        if (this.isFavorite()) {
            return this.name + " (favorite)";
        }
        return this.name;
    }

    public int getSuccessCount() {
        return this.singleBenchmarkResultList.size() - this.failureCount;
    }

    public boolean hasAnySuccess() {
        return this.getSuccessCount() > 0;
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean isFavorite() {
        return this.ranking != null && this.ranking == 0;
    }

    public String getStandardDeviationString() {
        if (this.standardDeviationDoubles == null) {
            return null;
        }
        StringBuilder standardDeviationString = new StringBuilder(this.standardDeviationDoubles.length * 9);
        boolean first = true;
        for (double standardDeviationDouble : this.standardDeviationDoubles) {
            if (first) {
                first = false;
            } else {
                standardDeviationString.append("/");
            }
            String abbreviated = Double.toString(standardDeviationDouble);
            int dotIndex = abbreviated.lastIndexOf(46);
            if (dotIndex >= 0 && dotIndex + 3 < abbreviated.length()) {
                abbreviated = abbreviated.substring(0, dotIndex + 3);
            }
            standardDeviationString.append(abbreviated);
        }
        return standardDeviationString.toString();
    }

    public Score getAverageWinningScoreDifference() {
        if (this.totalWinningScoreDifference == null) {
            return null;
        }
        return this.totalWinningScoreDifference.divide((double)this.getSuccessCount());
    }

    public List<Score> getScoreList() {
        ArrayList<Score> scoreList = new ArrayList<Score>(this.singleBenchmarkResultList.size());
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            scoreList.add(singleBenchmarkResult.getScore());
        }
        return scoreList;
    }

    public SingleBenchmarkResult findSingleBenchmark(ProblemBenchmarkResult problemBenchmarkResult) {
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (!problemBenchmarkResult.equals(singleBenchmarkResult.getProblemBenchmarkResult())) continue;
            return singleBenchmarkResult;
        }
        return null;
    }

    public String getSolverConfigAsHtmlEscapedXml() {
        XStream xStream = XmlSolverFactory.buildXstream();
        xStream.setMode(1001);
        String xml = xStream.toXML((Object)this.solverConfig);
        return StringEscapeUtils.escapeHtml((String)xml);
    }

    public void accumulateResults(BenchmarkReport benchmarkReport) {
        this.determineTotalsAndAverages();
        this.determineStandardDeviation();
    }

    protected void determineTotalsAndAverages() {
        this.failureCount = 0;
        boolean firstNonFailure = true;
        this.totalScore = null;
        this.totalWinningScoreDifference = null;
        ScoreDifferencePercentage totalWorstScoreDifferencePercentage = null;
        long totalAverageCalculateCountPerSecond = 0L;
        long totalTimeMillisSpent = 0L;
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.isFailure()) {
                Integer n = this.failureCount;
                Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
                continue;
            }
            if (firstNonFailure) {
                this.totalScore = singleBenchmarkResult.getScore();
                this.totalWinningScoreDifference = singleBenchmarkResult.getWinningScoreDifference();
                totalWorstScoreDifferencePercentage = singleBenchmarkResult.getWorstScoreDifferencePercentage();
                totalAverageCalculateCountPerSecond = singleBenchmarkResult.getAverageCalculateCountPerSecond();
                totalTimeMillisSpent = singleBenchmarkResult.getTimeMillisSpent();
                firstNonFailure = false;
                continue;
            }
            this.totalScore = this.totalScore.add(singleBenchmarkResult.getScore());
            this.totalWinningScoreDifference = this.totalWinningScoreDifference.add(singleBenchmarkResult.getWinningScoreDifference());
            totalWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.add(singleBenchmarkResult.getWorstScoreDifferencePercentage());
            totalAverageCalculateCountPerSecond += singleBenchmarkResult.getAverageCalculateCountPerSecond().longValue();
            totalTimeMillisSpent += singleBenchmarkResult.getTimeMillisSpent();
        }
        if (!firstNonFailure) {
            int successCount = this.getSuccessCount();
            this.averageScore = this.totalScore.divide((double)successCount);
            this.averageWorstScoreDifferencePercentage = totalWorstScoreDifferencePercentage.divide(successCount);
            this.averageAverageCalculateCountPerSecond = totalAverageCalculateCountPerSecond / (long)successCount;
            this.averageTimeMillisSpent = totalTimeMillisSpent / (long)successCount;
        }
    }

    protected void determineStandardDeviation() {
        int successCount = this.getSuccessCount();
        if (successCount <= 0) {
            return;
        }
        double[] differenceSquaredTotalDoubles = null;
        for (SingleBenchmarkResult singleBenchmarkResult : this.singleBenchmarkResultList) {
            if (singleBenchmarkResult.isFailure()) continue;
            Score difference = singleBenchmarkResult.getScore().subtract(this.averageScore);
            double[] differenceDoubles = ScoreUtils.extractLevelDoubles((Score)difference);
            if (differenceSquaredTotalDoubles == null) {
                differenceSquaredTotalDoubles = new double[differenceDoubles.length];
            }
            for (int i = 0; i < differenceDoubles.length; ++i) {
                int n = i;
                differenceSquaredTotalDoubles[n] = differenceSquaredTotalDoubles[n] + Math.pow(differenceDoubles[i], 2.0);
            }
        }
        this.standardDeviationDoubles = new double[differenceSquaredTotalDoubles.length];
        for (int i = 0; i < differenceSquaredTotalDoubles.length; ++i) {
            this.standardDeviationDoubles[i] = Math.pow((double)(differenceSquaredTotalDoubles[i] / (double)successCount), 0.5);
        }
    }

    protected static Map<SolverBenchmarkResult, SolverBenchmarkResult> createMergeMap(PlannerBenchmarkResult newPlannerBenchmarkResult, List<SingleBenchmarkResult> singleBenchmarkResultList) {
        SolverBenchmarkResult newResult;
        SolverBenchmarkResult oldResult;
        IdentityHashMap<SolverBenchmarkResult, SolverBenchmarkResult> mergeMap = new IdentityHashMap<SolverBenchmarkResult, SolverBenchmarkResult>();
        HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
        for (SingleBenchmarkResult singleBenchmarkResult : singleBenchmarkResultList) {
            oldResult = singleBenchmarkResult.getSolverBenchmarkResult();
            if (mergeMap.containsKey(oldResult)) continue;
            newResult = new SolverBenchmarkResult(newPlannerBenchmarkResult);
            Integer nameCount = (Integer)nameCountMap.get(oldResult.name);
            if (nameCount == null) {
                nameCount = 1;
            } else {
                Integer n = nameCount;
                Integer n2 = nameCount = Integer.valueOf(nameCount + 1);
            }
            nameCountMap.put(oldResult.name, nameCount);
            newResult.solverConfig = oldResult.solverConfig;
            newResult.singleBenchmarkResultList = new ArrayList<SingleBenchmarkResult>(oldResult.singleBenchmarkResultList.size());
            mergeMap.put(oldResult, newResult);
            newPlannerBenchmarkResult.getSolverBenchmarkResultList().add(newResult);
        }
        for (Map.Entry entry : mergeMap.entrySet()) {
            oldResult = (SolverBenchmarkResult)entry.getKey();
            newResult = (SolverBenchmarkResult)entry.getValue();
            if ((Integer)nameCountMap.get(oldResult.name) > 1) {
                newResult.name = oldResult.name + " (" + oldResult.getPlannerBenchmarkResult().getName() + ")";
                continue;
            }
            newResult.name = oldResult.name;
        }
        return mergeMap;
    }

    public String toString() {
        return this.getName();
    }
}

