/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.stepscore;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.stepscore.StepScoreStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListener;
import org.optaplanner.core.impl.phase.event.SolverPhaseLifecycleListenerAdapter;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solver.DefaultSolver;

public class StepScoreSingleStatistic
extends SingleStatistic<StepScoreStatisticPoint> {
    private final StepScoreSingleStatisticListener listener = new StepScoreSingleStatisticListener();
    private List<StepScoreStatisticPoint> pointList = new ArrayList<StepScoreStatisticPoint>();

    public StepScoreSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, ProblemStatisticType.STEP_SCORE);
    }

    @Override
    public List<StepScoreStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void setPointList(List<StepScoreStatisticPoint> pointList) {
        this.pointList = pointList;
    }

    @Override
    public void open(Solver solver) {
        ((DefaultSolver)solver).addSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        ((DefaultSolver)solver).removeSolverPhaseLifecycleListener((SolverPhaseLifecycleListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return StepScoreStatisticPoint.buildCsvLine("timeMillisSpent", "score");
    }

    @Override
    protected StepScoreStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new StepScoreStatisticPoint(Long.valueOf(csvLine.get(0)), scoreDefinition.parseScore(csvLine.get(1)));
    }

    private class StepScoreSingleStatisticListener
    extends SolverPhaseLifecycleListenerAdapter {
        private StepScoreSingleStatisticListener() {
        }

        public void stepEnded(AbstractStepScope stepScope) {
            if (stepScope.hasNoUninitializedVariables()) {
                long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpent();
                StepScoreSingleStatistic.this.pointList.add(new StepScoreStatisticPoint(timeMillisSpent, stepScope.getScore()));
            }
        }
    }
}

