/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl.statistic.bestsolutionmutation;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.impl.statistic.SingleStatistic;
import org.optaplanner.benchmark.impl.statistic.bestsolutionmutation.BestSolutionMutationStatisticPoint;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.domain.solution.mutation.MutationCounter;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;
import org.optaplanner.core.impl.solution.Solution;

public class BestSolutionMutationSingleStatistic
extends SingleStatistic<BestSolutionMutationStatisticPoint> {
    private BestSolutionMutationSingleStatisticListener listener = new BestSolutionMutationSingleStatisticListener();
    private List<BestSolutionMutationStatisticPoint> pointList = new ArrayList<BestSolutionMutationStatisticPoint>();

    public BestSolutionMutationSingleStatistic(SingleBenchmarkResult singleBenchmarkResult) {
        super(singleBenchmarkResult, ProblemStatisticType.BEST_SOLUTION_MUTATION);
    }

    @Override
    public List<BestSolutionMutationStatisticPoint> getPointList() {
        return this.pointList;
    }

    @Override
    public void setPointList(List<BestSolutionMutationStatisticPoint> pointList) {
        this.pointList = pointList;
    }

    @Override
    public void open(Solver solver) {
        SolutionDescriptor solutionDescriptor = solver.getScoreDirectorFactory().getSolutionDescriptor();
        this.listener.setMutationCounter(new MutationCounter(solutionDescriptor));
        solver.addEventListener((SolverEventListener)this.listener);
    }

    @Override
    public void close(Solver solver) {
        solver.removeEventListener((SolverEventListener)this.listener);
    }

    @Override
    protected String getCsvHeader() {
        return BestSolutionMutationStatisticPoint.buildCsvLine("timeMillisSpent", "mutationCount");
    }

    @Override
    protected BestSolutionMutationStatisticPoint createPointFromCsvLine(ScoreDefinition scoreDefinition, List<String> csvLine) {
        return new BestSolutionMutationStatisticPoint(Long.valueOf(csvLine.get(0)), Integer.valueOf(csvLine.get(1)));
    }

    private class BestSolutionMutationSingleStatisticListener
    implements SolverEventListener {
        private MutationCounter mutationCounter;
        private Solution oldBestSolution = null;

        private BestSolutionMutationSingleStatisticListener() {
        }

        private void setMutationCounter(MutationCounter mutationCounter) {
            if (this.mutationCounter != null) {
                throw new IllegalStateException("Impossible state: mutationCounter (" + mutationCounter + ") is not null.");
            }
            this.mutationCounter = mutationCounter;
        }

        public void bestSolutionChanged(BestSolutionChangedEvent event) {
            Solution newBestSolution = event.getNewBestSolution();
            int mutationCount = this.oldBestSolution == null ? 0 : this.mutationCounter.countMutations(this.oldBestSolution, newBestSolution);
            BestSolutionMutationSingleStatistic.this.pointList.add(new BestSolutionMutationStatisticPoint(event.getTimeMillisSpent(), mutationCount));
            this.oldBestSolution = newBestSolution;
        }
    }
}

